/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.json.internal;

import gg.skytils.ktx-serialization.DeserializationStrategy;
import gg.skytils.ktx-serialization.PolymorphicSerializerKt;
import gg.skytils.ktx-serialization.SealedClassSerializer;
import gg.skytils.ktx-serialization.SerializationException;
import gg.skytils.ktx-serialization.SerializationStrategy;
import gg.skytils.ktx-serialization.descriptors.PolymorphicKind;
import gg.skytils.ktx-serialization.descriptors.PrimitiveKind;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptor;
import gg.skytils.ktx-serialization.descriptors.SerialKind;
import gg.skytils.ktx-serialization.encoding.Encoder;
import gg.skytils.ktx-serialization.internal.AbstractPolymorphicSerializer;
import gg.skytils.ktx-serialization.internal.JsonInternalDependenciesKt;
import gg.skytils.ktx-serialization.json.Json;
import gg.skytils.ktx-serialization.json.JsonClassDiscriminator;
import gg.skytils.ktx-serialization.json.JsonDecoder;
import gg.skytils.ktx-serialization.json.JsonElement;
import gg.skytils.ktx-serialization.json.JsonElementKt;
import gg.skytils.ktx-serialization.json.JsonEncoder;
import gg.skytils.ktx-serialization.json.JsonObject;
import gg.skytils.ktx-serialization.json.JsonPrimitive;
import gg.skytils.ktx-serialization.json.internal.JsonExceptionsKt;
import gg.skytils.ktx-serialization.json.internal.TreeJsonDecoderKt;
import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a1\u0010\u000b\u001a\u00020\u00022\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u001b\u0010\n\u001a\u00020\t*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b\n\u0010\u0010\u001a'\u0010\u0015\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001aG\u0010\u001b\u001a\u00020\u0002\"\u0004\b\u0000\u0010\u0011*\u00020\u00172\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u0018\u001a\u00028\u00002\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\u0019H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d"}, d2={"Lgg/skytils/ktx-serialization/descriptors/SerialKind;", "kind", "", "checkKind", "(Lgg/skytils/ktx-serialization/descriptors/SerialKind;)V", "Lgg/skytils/ktx-serialization/SerializationStrategy;", "serializer", "", "actualSerializer", "", "classDiscriminator", "validateIfSealed", "(Lgg/skytils/ktx-serialization/SerializationStrategy;Lgg/skytils/ktx-serialization/SerializationStrategy;Ljava/lang/String;)V", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "Lgg/skytils/ktx-serialization/json/Json;", "json", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;Lgg/skytils/ktx-serialization/json/Json;)Ljava/lang/String;", "T", "Lgg/skytils/ktx-serialization/json/JsonDecoder;", "Lgg/skytils/ktx-serialization/DeserializationStrategy;", "deserializer", "decodeSerializableValuePolymorphic", "(Lkotlinx/serialization/json/JsonDecoder;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "Lgg/skytils/ktx-serialization/json/JsonEncoder;", "value", "Lkotlin/Function1;", "ifPolymorphic", "encodePolymorphically", "(Lkotlinx/serialization/json/JsonEncoder;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nPolymorphic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n+ 2 TreeJsonEncoder.kt\nkotlinx/serialization/json/internal/TreeJsonEncoderKt\n*L\n1#1,87:1\n252#2,7:88\n*S KotlinDebug\n*F\n+ 1 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n*L\n65#1:88,7\n*E\n"})
public final class PolymorphicKt {
    public static final <T> void encodePolymorphically(@NotNull JsonEncoder $this$encodePolymorphically, @NotNull SerializationStrategy<? super T> serializer2, T value, @NotNull Function1<? super String, Unit> ifPolymorphic) {
        Intrinsics.checkNotNullParameter($this$encodePolymorphically, "<this>");
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        Intrinsics.checkNotNullParameter(ifPolymorphic, "ifPolymorphic");
        boolean $i$f$encodePolymorphically = false;
        if (!(serializer2 instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer2.serialize($this$encodePolymorphically, value);
            return;
        }
        AbstractPolymorphicSerializer casted = (AbstractPolymorphicSerializer)serializer2;
        String baseClassDiscriminator = PolymorphicKt.classDiscriminator(serializer2.getDescriptor(), $this$encodePolymorphically.getJson());
        Encoder encoder2 = $this$encodePolymorphically;
        Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Any");
        SerializationStrategy<T> actualSerializer = PolymorphicSerializerKt.findPolymorphicSerializer(casted, encoder2, value);
        PolymorphicKt.validateIfSealed(casted, actualSerializer, baseClassDiscriminator);
        PolymorphicKt.checkKind(actualSerializer.getDescriptor().getKind());
        ifPolymorphic.invoke(baseClassDiscriminator);
        actualSerializer.serialize($this$encodePolymorphically, value);
    }

    private static final void validateIfSealed(SerializationStrategy<?> serializer2, SerializationStrategy<Object> actualSerializer, String classDiscriminator) {
        if (!(serializer2 instanceof SealedClassSerializer)) {
            return;
        }
        if (JsonInternalDependenciesKt.jsonCachedSerialNames(actualSerializer.getDescriptor()).contains(classDiscriminator)) {
            String baseName = serializer2.getDescriptor().getSerialName();
            String actualName = actualSerializer.getDescriptor().getSerialName();
            throw new IllegalStateException(("Sealed class '" + actualName + "' cannot be serialized as base class '" + baseName + "' because it has property name that conflicts with JSON class discriminator '" + classDiscriminator + "'. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism").toString());
        }
    }

    public static final void checkKind(@NotNull SerialKind kind) {
        Intrinsics.checkNotNullParameter(kind, "kind");
        if (kind instanceof SerialKind.ENUM) {
            throw new IllegalStateException("Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PrimitiveKind) {
            throw new IllegalStateException("Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PolymorphicKind) {
            throw new IllegalStateException("Actual serializer for polymorphic cannot be polymorphic itself".toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T decodeSerializableValuePolymorphic(@NotNull JsonDecoder $this$decodeSerializableValuePolymorphic, @NotNull DeserializationStrategy<? extends T> deserializer) {
        DeserializationStrategy deserializationStrategy;
        void value$iv;
        Intrinsics.checkNotNullParameter($this$decodeSerializableValuePolymorphic, "<this>");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic.getJson().getConfiguration().getUseArrayPolymorphism()) {
            return deserializer.deserialize($this$decodeSerializableValuePolymorphic);
        }
        String discriminator = PolymorphicKt.classDiscriminator(deserializer.getDescriptor(), $this$decodeSerializableValuePolymorphic.getJson());
        JsonElement jsonElement = $this$decodeSerializableValuePolymorphic.decodeJsonElement();
        SerialDescriptor descriptor$iv = deserializer.getDescriptor();
        boolean $i$f$cast = false;
        if (!(value$iv instanceof JsonObject)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " as the serialized body of " + descriptor$iv.getSerialName() + ", but had " + Reflection.getOrCreateKotlinClass(value$iv.getClass()));
        }
        JsonObject jsonTree = (JsonObject)value$iv;
        JsonElement jsonElement2 = (JsonElement)jsonTree.get((Object)discriminator);
        String type2 = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
        try {
            deserializationStrategy = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)deserializer, $this$decodeSerializableValuePolymorphic, type2);
        }
        catch (SerializationException it) {
            String string = it.getMessage();
            Intrinsics.checkNotNull(string);
            throw JsonExceptionsKt.JsonDecodingException(-1, string, jsonTree.toString());
        }
        DeserializationStrategy deserializationStrategy2 = deserializationStrategy;
        Intrinsics.checkNotNull(deserializationStrategy2, "null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.decodeSerializableValuePolymorphic>");
        DeserializationStrategy actualSerializer = deserializationStrategy2;
        return TreeJsonDecoderKt.readPolymorphicJson($this$decodeSerializableValuePolymorphic.getJson(), discriminator, jsonTree, actualSerializer);
    }

    @NotNull
    public static final String classDiscriminator(@NotNull SerialDescriptor $this$classDiscriminator, @NotNull Json json2) {
        Intrinsics.checkNotNullParameter($this$classDiscriminator, "<this>");
        Intrinsics.checkNotNullParameter(json2, "json");
        for (Annotation annotation : $this$classDiscriminator.getAnnotations()) {
            if (!(annotation instanceof JsonClassDiscriminator)) continue;
            return ((JsonClassDiscriminator)annotation).discriminator();
        }
        return json2.getConfiguration().getClassDiscriminator();
    }
}

