/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.engine;

import gg.skytils.ktor.server.application.Application;
import gg.skytils.ktor.server.config.ApplicationConfig;
import gg.skytils.ktor.server.config.MapApplicationConfig;
import gg.skytils.ktor.server.engine.ApplicationEngineEnvironment;
import gg.skytils.ktor.server.engine.ApplicationEngineEnvironmentReloading;
import gg.skytils.ktor.server.engine.EngineConnectorConfig;
import gg.skytils.ktor.server.engine.ServerEngineUtilsJvmKt;
import gg.skytils.ktor.util.PlatformUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\bD\u0010EJ&\u0010\u0007\u001a\u00020\u00062\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\u000b\u001a\u00020\u00032\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R.\u0010/\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0002\b\u00040\u001b8\u0006\u00a2\u0006\f\n\u0004\b/\u0010\u001e\u001a\u0004\b0\u0010 R\"\u00102\u001a\u0002018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\"\u00109\u001a\u0002088\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R(\u0010@\u001a\b\u0012\u0004\u0012\u0002080?8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010\u001e\u001a\u0004\bA\u0010 \"\u0004\bB\u0010C\u00a8\u0006F"}, d2={"Lgg/skytils/ktor/server/engine/ApplicationEngineEnvironmentBuilder;", "", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "builder", "Lgg/skytils/ktor/server/engine/ApplicationEngineEnvironment;", "build", "(Lkotlin/jvm/functions/Function1;)Lgg/skytils/ktor/server/engine/ApplicationEngineEnvironment;", "Lgg/skytils/ktor/server/application/Application;", "body", "module", "(Lkotlin/jvm/functions/Function1;)V", "Ljava/lang/ClassLoader;", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "setClassLoader", "(Ljava/lang/ClassLoader;)V", "Lgg/skytils/ktor/server/config/ApplicationConfig;", "config", "Lgg/skytils/ktor/server/config/ApplicationConfig;", "getConfig", "()Lio/ktor/server/config/ApplicationConfig;", "setConfig", "(Lio/ktor/server/config/ApplicationConfig;)V", "", "Lgg/skytils/ktor/server/engine/EngineConnectorConfig;", "connectors", "Ljava/util/List;", "getConnectors", "()Ljava/util/List;", "", "developmentMode", "Z", "getDevelopmentMode", "()Z", "setDevelopmentMode", "(Z)V", "Lorg/slf4j/Logger;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "setLog", "(Lorg/slf4j/Logger;)V", "modules", "getModules", "Lkotlin/coroutines/CoroutineContext;", "parentCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getParentCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "setParentCoroutineContext", "(Lkotlin/coroutines/CoroutineContext;)V", "", "rootPath", "Ljava/lang/String;", "getRootPath", "()Ljava/lang/String;", "setRootPath", "(Ljava/lang/String;)V", "", "watchPaths", "getWatchPaths", "setWatchPaths", "(Ljava/util/List;)V", "<init>", "()V", "ktor-server-host-common"})
public final class ApplicationEngineEnvironmentBuilder {
    @NotNull
    private ClassLoader classLoader;
    @NotNull
    private CoroutineContext parentCoroutineContext;
    @NotNull
    private List<String> watchPaths;
    @NotNull
    private Logger log;
    @NotNull
    private ApplicationConfig config;
    @NotNull
    private final List<EngineConnectorConfig> connectors;
    @NotNull
    private final List<Function1<Application, Unit>> modules;
    @NotNull
    private String rootPath;
    private boolean developmentMode;

    public ApplicationEngineEnvironmentBuilder() {
        ClassLoader classLoader = ApplicationEngineEnvironment.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue(classLoader, "ApplicationEngineEnviron\u2026t::class.java.classLoader");
        this.classLoader = classLoader;
        this.parentCoroutineContext = EmptyCoroutineContext.INSTANCE;
        this.watchPaths = CollectionsKt.listOf(ServerEngineUtilsJvmKt.getWORKING_DIRECTORY_PATH());
        Logger logger = LoggerFactory.getLogger("Application");
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(\"Application\")");
        this.log = logger;
        this.config = new MapApplicationConfig();
        this.connectors = new ArrayList();
        this.modules = new ArrayList();
        this.rootPath = "";
        this.developmentMode = PlatformUtils.INSTANCE.getIS_DEVELOPMENT_MODE();
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final void setClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(classLoader, "<set-?>");
        this.classLoader = classLoader;
    }

    @NotNull
    public final CoroutineContext getParentCoroutineContext() {
        return this.parentCoroutineContext;
    }

    public final void setParentCoroutineContext(@NotNull CoroutineContext coroutineContext2) {
        Intrinsics.checkNotNullParameter(coroutineContext2, "<set-?>");
        this.parentCoroutineContext = coroutineContext2;
    }

    @NotNull
    public final List<String> getWatchPaths() {
        return this.watchPaths;
    }

    public final void setWatchPaths(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.watchPaths = list;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public final void setLog(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(logger, "<set-?>");
        this.log = logger;
    }

    @NotNull
    public final ApplicationConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull ApplicationConfig applicationConfig) {
        Intrinsics.checkNotNullParameter(applicationConfig, "<set-?>");
        this.config = applicationConfig;
    }

    @NotNull
    public final List<EngineConnectorConfig> getConnectors() {
        return this.connectors;
    }

    @NotNull
    public final List<Function1<Application, Unit>> getModules() {
        return this.modules;
    }

    @NotNull
    public final String getRootPath() {
        return this.rootPath;
    }

    public final void setRootPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.rootPath = string;
    }

    public final boolean getDevelopmentMode() {
        return this.developmentMode;
    }

    public final void setDevelopmentMode(boolean bl) {
        this.developmentMode = bl;
    }

    public final void module(@NotNull Function1<? super Application, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        this.modules.add(body2);
    }

    @NotNull
    public final ApplicationEngineEnvironment build(@NotNull Function1<? super ApplicationEngineEnvironmentBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        builder.invoke(this);
        return new ApplicationEngineEnvironmentReloading(this.classLoader, this.log, this.config, this.connectors, this.modules, this.watchPaths, this.parentCoroutineContext, this.rootPath, this.developmentMode);
    }
}

