/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.serialization.kotlinx;

import gg.skytils.ktor.serialization.WebsocketContentConverter;
import gg.skytils.ktor.serialization.WebsocketConverterNotFoundException;
import gg.skytils.ktor.serialization.WebsocketDeserializeException;
import gg.skytils.ktor.serialization.kotlinx.SerializerLookupKt;
import gg.skytils.ktor.util.reflect.TypeInfo;
import gg.skytils.ktor.websocket.Frame;
import gg.skytils.ktor.websocket.FrameCommonKt;
import gg.skytils.ktx-serialization.BinaryFormat;
import gg.skytils.ktx-serialization.DeserializationStrategy;
import gg.skytils.ktx-serialization.KSerializer;
import gg.skytils.ktx-serialization.SerialFormat;
import gg.skytils.ktx-serialization.SerializationException;
import gg.skytils.ktx-serialization.SerializationStrategy;
import gg.skytils.ktx-serialization.StringFormat;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001a\u0010\u001bJ1\u0010\n\u001a\u0004\u0018\u00010\t2\n\u0010\u0004\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ-\u0010\u0015\u001a\u00020\u00072\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J1\u0010\u0017\u001a\u00020\u00072\n\u0010\u0004\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lgg/skytils/ktor/serialization/kotlinx/KotlinxWebsocketSerializationConverter;", "Lgg/skytils/ktor/serialization/WebsocketContentConverter;", "Ljava/nio/charset/Charset;", "Lgg/skytils/ktor/utils/io/charsets/Charset;", "charset", "Lgg/skytils/ktor/util/reflect/TypeInfo;", "typeInfo", "Lgg/skytils/ktor/websocket/Frame;", "content", "", "deserialize", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Lio/ktor/websocket/Frame;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "frame", "", "isApplicable", "(Lgg/skytils/ktor/websocket/Frame;)Z", "Lgg/skytils/ktx-serialization/KSerializer;", "serializer", "Lgg/skytils/ktx-serialization/SerialFormat;", "format", "value", "serializeContent", "(Lgg/skytils/ktx-serialization/KSerializer;Lgg/skytils/ktx-serialization/SerialFormat;Ljava/lang/Object;)Lgg/skytils/ktor/websocket/Frame;", "serializeNullable", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lgg/skytils/ktx-serialization/SerialFormat;", "<init>", "(Lkotlinx/serialization/SerialFormat;)V", "ktor-serialization-kotlinx"})
public final class KotlinxWebsocketSerializationConverter
implements WebsocketContentConverter {
    @NotNull
    private final SerialFormat format;

    public KotlinxWebsocketSerializationConverter(@NotNull SerialFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        this.format = format;
        if (!(this.format instanceof BinaryFormat || this.format instanceof StringFormat)) {
            boolean bl = false;
            String string = "Only binary and string formats are supported, " + this.format + " is not supported.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @Nullable
    public Object serializeNullable(@NotNull Charset charset, @NotNull TypeInfo typeInfo, @Nullable Object value, @NotNull Continuation<? super Frame> $completion) {
        KSerializer<Object> kSerializer;
        try {
            kSerializer = SerializerLookupKt.serializerForTypeInfo(this.format.getSerializersModule(), typeInfo);
        }
        catch (SerializationException cause) {
            kSerializer = SerializerLookupKt.guessSerializer(value, this.format.getSerializersModule());
        }
        KSerializer<Object> serializer2 = kSerializer;
        return this.serializeContent(serializer2, this.format, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object deserialize(@NotNull Charset charset, @NotNull TypeInfo typeInfo, @NotNull Frame content2, @NotNull Continuation<Object> $completion) {
        Object t;
        if (!this.isApplicable(content2)) {
            throw new WebsocketConverterNotFoundException("Unsupported frame " + content2.getFrameType().name(), null, 2, null);
        }
        KSerializer<?> serializer2 = SerializerLookupKt.serializerForTypeInfo(this.format.getSerializersModule(), typeInfo);
        SerialFormat serialFormat = this.format;
        if (serialFormat instanceof StringFormat) {
            if (!(content2 instanceof Frame.Text)) throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + content2.getFrameType().name(), null, content2, 2, null);
            t = ((StringFormat)this.format).decodeFromString((DeserializationStrategy)serializer2, FrameCommonKt.readText((Frame.Text)content2));
            return t;
        } else {
            if (!(serialFormat instanceof BinaryFormat)) throw new IllegalStateException(("Unsupported format " + this.format).toString());
            if (!(content2 instanceof Frame.Binary)) throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + content2.getFrameType().name(), null, content2, 2, null);
            t = ((BinaryFormat)this.format).decodeFromByteArray((DeserializationStrategy)serializer2, FrameCommonKt.readBytes(content2));
        }
        return t;
    }

    @Override
    public boolean isApplicable(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        return frame instanceof Frame.Text || frame instanceof Frame.Binary;
    }

    private final Frame serializeContent(KSerializer<?> serializer2, SerialFormat format, Object value) {
        Frame frame;
        SerialFormat serialFormat = format;
        if (serialFormat instanceof StringFormat) {
            StringFormat stringFormat = (StringFormat)format;
            Intrinsics.checkNotNull(serializer2, "null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any?>");
            String content2 = stringFormat.encodeToString((SerializationStrategy)serializer2, value);
            frame = new Frame.Text(content2);
        } else if (serialFormat instanceof BinaryFormat) {
            BinaryFormat binaryFormat = (BinaryFormat)format;
            Intrinsics.checkNotNull(serializer2, "null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any?>");
            byte[] content3 = binaryFormat.encodeToByteArray((SerializationStrategy)serializer2, value);
            frame = new Frame.Binary(true, content3);
        } else {
            throw new IllegalStateException(("Unsupported format " + format).toString());
        }
        return frame;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Charset charset, @NotNull TypeInfo typeInfo, @NotNull Object value, @NotNull Continuation<? super Frame> $completion) {
        return WebsocketContentConverter.DefaultImpls.serialize(this, charset, typeInfo, value, $completion);
    }
}

