/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.network.tls.cipher;

import gg.skytils.ktor.network.tls.CipherSuite;
import gg.skytils.ktor.network.tls.TLSRecord;
import gg.skytils.ktor.network.tls.cipher.CipherUtilsKt;
import gg.skytils.ktor.network.tls.cipher.GCMCipherKt;
import gg.skytils.ktor.network.tls.cipher.TLSCipher;
import gg.skytils.ktor.utils.io.core.BytePacketBuilder;
import gg.skytils.ktor.utils.io.core.ByteReadPacket;
import gg.skytils.ktor.utils.io.core.InputPrimitivesKt;
import gg.skytils.ktor.utils.io.core.OutputPrimitivesKt;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0005R\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\tR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lgg/skytils/ktor/network/tls/cipher/GCMCipher;", "Lgg/skytils/ktor/network/tls/cipher/TLSCipher;", "Lgg/skytils/ktor/network/tls/TLSRecord;", "record", "decrypt", "(Lgg/skytils/ktor/network/tls/TLSRecord;)Lgg/skytils/ktor/network/tls/TLSRecord;", "encrypt", "", "inputCounter", "J", "", "keyMaterial", "[B", "outputCounter", "Lgg/skytils/ktor/network/tls/CipherSuite;", "suite", "Lgg/skytils/ktor/network/tls/CipherSuite;", "<init>", "(Lio/ktor/network/tls/CipherSuite;[B)V", "ktor-network-tls"})
public final class GCMCipher
implements TLSCipher {
    @NotNull
    private final CipherSuite suite;
    @NotNull
    private final byte[] keyMaterial;
    private long inputCounter;
    private long outputCounter;

    public GCMCipher(@NotNull CipherSuite suite, @NotNull byte[] keyMaterial2) {
        Intrinsics.checkNotNullParameter(suite, "suite");
        Intrinsics.checkNotNullParameter(keyMaterial2, "keyMaterial");
        this.suite = suite;
        this.keyMaterial = keyMaterial2;
    }

    @Override
    @NotNull
    public TLSRecord encrypt(@NotNull TLSRecord record) {
        Intrinsics.checkNotNullParameter(record, "record");
        Cipher cipher2 = GCMCipherKt.access$gcmEncryptCipher(this.suite, this.keyMaterial, record.getType(), (int)record.getPacket().getRemaining(), this.outputCounter, this.outputCounter);
        long packetId = this.outputCounter;
        ByteReadPacket packet2 = CipherUtilsKt.cipherLoop(record.getPacket(), cipher2, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(packetId){
            final /* synthetic */ long $packetId;
            {
                this.$packetId = $packetId;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$cipherLoop) {
                Intrinsics.checkNotNullParameter($this$cipherLoop, "$this$cipherLoop");
                OutputPrimitivesKt.writeLong($this$cipherLoop, this.$packetId);
            }
        });
        long l = this.outputCounter;
        this.outputCounter = l + 1L;
        return new TLSRecord(record.getType(), null, packet2, 2, null);
    }

    @Override
    @NotNull
    public TLSRecord decrypt(@NotNull TLSRecord record) {
        Intrinsics.checkNotNullParameter(record, "record");
        ByteReadPacket packet2 = record.getPacket();
        long packetSize = packet2.getRemaining();
        long recordIv = InputPrimitivesKt.readLong(packet2);
        long l = this.inputCounter;
        this.inputCounter = l + 1L;
        Cipher cipher2 = GCMCipherKt.access$gcmDecryptCipher(this.suite, this.keyMaterial, record.getType(), (int)packetSize, recordIv, l);
        return new TLSRecord(record.getType(), record.getVersion(), CipherUtilsKt.cipherLoop$default(packet2, cipher2, null, 2, null));
    }
}

