/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.http.cio.internals;

import gg.skytils.ktor.http.cio.internals.CharArrayBuilder;
import gg.skytils.ktor.http.cio.internals.MutableRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001f\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001f\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a'\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"", "text", "Lgg/skytils/ktor/http/cio/internals/MutableRange;", "range", "", "findSpaceOrEnd", "(Ljava/lang/CharSequence;Lgg/skytils/ktor/http/cio/internals/MutableRange;)I", "nextToken", "(Ljava/lang/CharSequence;Lgg/skytils/ktor/http/cio/internals/MutableRange;)Ljava/lang/CharSequence;", "", "skipSpaces", "(Ljava/lang/CharSequence;Lgg/skytils/ktor/http/cio/internals/MutableRange;)V", "Lgg/skytils/ktor/http/cio/internals/CharArrayBuilder;", "start", "end", "skipSpacesAndHorizontalTabs", "(Lgg/skytils/ktor/http/cio/internals/CharArrayBuilder;II)I", "ktor-http-cio"})
public final class TokenizerKt {
    @NotNull
    public static final CharSequence nextToken(@NotNull CharSequence text2, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(range, "range");
        int spaceOrEnd = TokenizerKt.findSpaceOrEnd(text2, range);
        CharSequence s = text2.subSequence(range.getStart(), spaceOrEnd);
        range.setStart(spaceOrEnd);
        return s;
    }

    public static final int skipSpacesAndHorizontalTabs(@NotNull CharArrayBuilder text2, int start2, int end2) {
        char ch;
        int index;
        Intrinsics.checkNotNullParameter(text2, "text");
        for (index = start2; index < end2 && (CharsKt.isWhitespace(ch = text2.charAt(index)) || ch == '\t'); ++index) {
        }
        return index;
    }

    public static final void skipSpaces(@NotNull CharSequence text2, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(range, "range");
        int idx = range.getStart();
        int end2 = range.getEnd();
        if (idx >= end2 || !CharsKt.isWhitespace(text2.charAt(idx))) {
            return;
        }
        ++idx;
        while (idx < end2 && CharsKt.isWhitespace(text2.charAt(idx))) {
            ++idx;
        }
        range.setStart(idx);
    }

    public static final int findSpaceOrEnd(@NotNull CharSequence text2, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(range, "range");
        int idx = range.getStart();
        int end2 = range.getEnd();
        if (idx >= end2 || CharsKt.isWhitespace(text2.charAt(idx))) {
            return idx;
        }
        ++idx;
        while (idx < end2) {
            if (CharsKt.isWhitespace(text2.charAt(idx))) {
                return idx;
            }
            ++idx;
        }
        return idx;
    }
}

