/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.asmhelper.dsl.code;

import gg.skytils.asmhelper.dsl.code.CodeBuilder;
import gg.skytils.asmhelper.dsl.code.modifiers.AsmBlockModifier;
import gg.skytils.asmhelper.dsl.code.modifiers.CodeBlockShortcutModifier;
import gg.skytils.asmhelper.dsl.code.modifiers.LocalVarModifier;
import gg.skytils.asmhelper.dsl.code.modifiers.Modifier;
import gg.skytils.asmhelper.dsl.code.modifiers.MutableRefModifier;
import gg.skytils.asmhelper.dsl.code.modifiers.RemoveReturnModifier;
import gg.skytils.asmhelper.dsl.code.modifiers.ShadowedFieldModifier;
import gg.skytils.asmhelper.dsl.code.modifiers.ShadowedLocalModifier;
import gg.skytils.asmhelper.dsl.code.modifiers.ShadowedMethodModifier;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lgg/skytils/asmhelper/dsl/code/InjectCodeBuilder;", "Lgg/skytils/asmhelper/dsl/code/CodeBuilder;", "", "Lgg/skytils/asmhelper/dsl/code/modifiers/Modifier;", "modifiers", "Ljava/util/List;", "getModifiers", "()Ljava/util/List;", "Lorg/objectweb/asm/tree/ClassNode;", "codeClassNode", "targetClassNode", "Lorg/objectweb/asm/tree/MethodNode;", "targetMethodNode", "<init>", "(Lorg/objectweb/asm/tree/ClassNode;Lorg/objectweb/asm/tree/ClassNode;Lorg/objectweb/asm/tree/MethodNode;)V", "AsmHelper1.8.9"})
public final class InjectCodeBuilder
extends CodeBuilder {
    @NotNull
    private final List<Modifier> modifiers;

    public InjectCodeBuilder(@NotNull ClassNode codeClassNode, @NotNull ClassNode targetClassNode, @NotNull MethodNode targetMethodNode) {
        Intrinsics.checkNotNullParameter(codeClassNode, "codeClassNode");
        Intrinsics.checkNotNullParameter(targetClassNode, "targetClassNode");
        Intrinsics.checkNotNullParameter(targetMethodNode, "targetMethodNode");
        super(codeClassNode);
        Modifier[] modifierArray = new Modifier[8];
        modifierArray[0] = new RemoveReturnModifier();
        modifierArray[1] = new CodeBlockShortcutModifier();
        MethodNode methodNode = this.getMethodNode();
        String string = codeClassNode.name;
        Intrinsics.checkNotNullExpressionValue(string, "codeClassNode.name");
        modifierArray[2] = new MutableRefModifier(methodNode, string);
        modifierArray[3] = new LocalVarModifier(targetMethodNode);
        modifierArray[4] = new AsmBlockModifier(targetMethodNode);
        string = codeClassNode.name;
        Intrinsics.checkNotNullExpressionValue(string, "codeClassNode.name");
        modifierArray[5] = new ShadowedMethodModifier(string, targetClassNode, this.getMethodNode());
        string = codeClassNode.name;
        Intrinsics.checkNotNullExpressionValue(string, "codeClassNode.name");
        modifierArray[6] = new ShadowedLocalModifier(string);
        string = codeClassNode.name;
        Intrinsics.checkNotNullExpressionValue(string, "codeClassNode.name");
        modifierArray[7] = new ShadowedFieldModifier(string, targetClassNode);
        this.modifiers = CollectionsKt.listOf(modifierArray);
    }

    @Override
    @NotNull
    public List<Modifier> getModifiers() {
        return this.modifiers;
    }
}

