/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.newsclub.net.unix.AFAddressFamily;

class AFInetAddress {
    private static final byte[] SERIALIZED_INET_ADDRESS_START = new byte[]{-84, -19, 0, 5, 115, 114, 0, 20, 106, 97, 118, 97, 46, 110, 101, 116, 46, 73, 110, 101, 116, 65, 100, 100, 114, 101, 115, 115, 45, -101, 87, -81, -97, -29, -21, -37, 3, 0, 3, 73, 0, 7, 97, 100, 100, 114, 101, 115, 115, 73, 0, 6, 102, 97, 109, 105, 108, 121, 76, 0, 8, 104, 111, 115, 116, 78, 97, 109, 101, 116, 0, 18, 76, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 59, 120, 112, 127, 0, 0, -81, 0, 0, 0, 1, 116, 0};
    private static final char PREFIX = '[';
    static final String INETADDR_SUFFIX = ".junixsocket";

    AFInetAddress() {
    }

    static final String createUnresolvedHostname(byte[] socketAddress, AFAddressFamily<?> af) {
        StringBuilder sb = new StringBuilder(1 + socketAddress.length + INETADDR_SUFFIX.length() + 8);
        sb.append('[');
        try {
            sb.append(URLEncoder.encode(new String(socketAddress, StandardCharsets.ISO_8859_1), StandardCharsets.ISO_8859_1.toString()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        sb.append('.');
        sb.append(af.getJuxString());
        sb.append(INETADDR_SUFFIX);
        return sb.toString();
    }

    static final InetAddress wrapAddress(byte[] socketAddress, AFAddressFamily<?> af) {
        InetAddress inetAddress;
        Objects.requireNonNull(af);
        if (socketAddress == null || socketAddress.length == 0) {
            return null;
        }
        byte[] bytes = AFInetAddress.createUnresolvedHostname(socketAddress, af).getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 255) {
            throw new IllegalStateException("Address too long");
        }
        byte[] serializedData = new byte[SERIALIZED_INET_ADDRESS_START.length + 1 + bytes.length + 1];
        System.arraycopy(SERIALIZED_INET_ADDRESS_START, 0, serializedData, 0, SERIALIZED_INET_ADDRESS_START.length);
        serializedData[AFInetAddress.SERIALIZED_INET_ADDRESS_START.length] = (byte)bytes.length;
        System.arraycopy(bytes, 0, serializedData, SERIALIZED_INET_ADDRESS_START.length + 1, bytes.length);
        serializedData[serializedData.length - 1] = 120;
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(serializedData));
        try {
            inetAddress = (InetAddress)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        ois.close();
        return inetAddress;
    }

    static final byte[] unwrapAddress(InetAddress addr, AFAddressFamily<?> af) throws SocketException {
        if (!AFInetAddress.isSupportedAddress(addr, af)) {
            throw new SocketException("Unsupported address");
        }
        String hostname = addr.getHostName();
        return AFInetAddress.unwrapAddress(hostname, af);
    }

    static final byte[] unwrapAddress(String hostname, AFAddressFamily<?> af) throws SocketException {
        String juxString;
        if (!hostname.endsWith(INETADDR_SUFFIX)) {
            throw new SocketException("Unsupported address");
        }
        int end = hostname.length() - INETADDR_SUFFIX.length();
        int domDot = -1;
        for (int i = end - 1; i >= 0; --i) {
            char c = hostname.charAt(i);
            if (c != '.') continue;
            domDot = i;
            break;
        }
        if (AFAddressFamily.getAddressFamily(juxString = hostname.substring(domDot + 1, end)) != af) {
            throw new SocketException("Incompatible address");
        }
        String encodedHostname = hostname.substring(1, domDot);
        try {
            return URLDecoder.decode(encodedHostname, StandardCharsets.ISO_8859_1.toString()).getBytes(StandardCharsets.ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static boolean isSupportedAddress(InetAddress addr, AFAddressFamily<?> af) {
        if (addr instanceof Inet4Address && addr.isLoopbackAddress()) {
            String hostname = addr.getHostName();
            return hostname.endsWith(af.getJuxInetAddressSuffix());
        }
        return false;
    }
}

