/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.utils.data.requests;

import codes.biscuit.skyblockaddons.SkyblockAddons;
import codes.biscuit.skyblockaddons.core.Language;
import codes.biscuit.skyblockaddons.utils.data.JSONResponseHandler;
import codes.biscuit.skyblockaddons.utils.data.RemoteFileRequest;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;

public class LocalizedStringsRequest
extends RemoteFileRequest<JsonObject> {
    public LocalizedStringsRequest(@NonNull Language language) {
        super(String.format("https://distributions.crowdin.net/d7578b29286a48bcaf7fec87zgb/content/main/src/main/resources/lang/%s.json", language.getPath()), new JSONResponseHandler((Type)((Object)JsonObject.class)), language != Language.ENGLISH && language != Language.RUSSIAN, true);
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
    }

    @Override
    public void load() throws InterruptedException, ExecutionException, RuntimeException {
        SkyblockAddons main = SkyblockAddons.getInstance();
        LocalizedStringsRequest.overwriteCommonJsonMembers(main.getConfigValues().getLanguageConfig(), (JsonObject)Objects.requireNonNull(this.getResult(), "No data received for get request to \"%s\""));
    }

    private static void overwriteCommonJsonMembers(JsonObject baseObject, JsonObject otherObject) {
        for (Map.Entry entry : otherObject.entrySet()) {
            String memberName = (String)entry.getKey();
            JsonElement otherElement = (JsonElement)entry.getValue();
            if (otherElement.isJsonObject()) {
                JsonObject baseElementObject;
                if (baseObject.has(memberName) && baseObject.get(memberName).isJsonObject()) {
                    baseElementObject = baseObject.getAsJsonObject(memberName);
                    LocalizedStringsRequest.overwriteCommonJsonMembers(baseElementObject, otherElement.getAsJsonObject());
                    continue;
                }
                baseElementObject = new JsonObject();
                baseObject.add(memberName, (JsonElement)baseElementObject);
                LocalizedStringsRequest.overwriteCommonJsonMembers(baseElementObject, otherElement.getAsJsonObject());
                continue;
            }
            if (!otherElement.isJsonPrimitive() || !otherElement.getAsJsonPrimitive().isString()) continue;
            baseObject.add(memberName, otherElement);
        }
    }
}

