/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.listeners;

import codes.biscuit.skyblockaddons.SkyblockAddons;
import codes.biscuit.skyblockaddons.core.Feature;
import codes.biscuit.skyblockaddons.events.SkyblockJoinedEvent;
import codes.biscuit.skyblockaddons.events.SkyblockLeftEvent;
import codes.biscuit.skyblockaddons.misc.scheduler.ScheduledTask;
import codes.biscuit.skyblockaddons.misc.scheduler.SkyblockRunnable;
import codes.biscuit.skyblockaddons.utils.data.DataUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.Logger;

public class NetworkListener {
    private static final Logger logger = SkyblockAddons.getLogger();
    private final SkyblockAddons main = SkyblockAddons.getInstance();
    private ScheduledTask updateHealth;

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        MinecraftForge.EVENT_BUS.post((Event)new SkyblockLeftEvent());
    }

    @SubscribeEvent
    public void onSkyblockJoined(SkyblockJoinedEvent event) {
        logger.info("Detected joining skyblock!");
        this.main.getUtils().setOnSkyblock(true);
        if (this.main.getConfigValues().isEnabled(Feature.DISCORD_RPC)) {
            this.main.getDiscordRPCManager().start();
        }
        this.updateHealth = this.main.getNewScheduler().scheduleRepeatingTask(new SkyblockRunnable(){

            @Override
            public void run() {
                NetworkListener.this.main.getPlayerListener().updateLastSecondHealth();
            }
        }, 0, 20);
        DataUtils.onSkyblockJoined();
    }

    @SubscribeEvent
    public void onSkyblockLeft(SkyblockLeftEvent event) {
        logger.info("Detected leaving skyblock!");
        this.main.getUtils().setOnSkyblock(false);
        this.main.getUtils().setProfileName("Unknown");
        if (this.main.getDiscordRPCManager().isActive()) {
            this.main.getDiscordRPCManager().stop();
        }
        if (this.updateHealth != null) {
            this.main.getNewScheduler().cancel(this.updateHealth);
            this.updateHealth = null;
        }
    }
}

