/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.toml;

import gg.skytils.vigilance.impl.nightconfig.core.UnmodifiableConfig;
import gg.skytils.vigilance.impl.nightconfig.core.io.CharacterOutput;
import gg.skytils.vigilance.impl.nightconfig.core.io.ConfigWriter;
import gg.skytils.vigilance.impl.nightconfig.core.io.IndentStyle;
import gg.skytils.vigilance.impl.nightconfig.core.io.NewlineStyle;
import gg.skytils.vigilance.impl.nightconfig.core.io.WriterOutput;
import gg.skytils.vigilance.impl.nightconfig.core.utils.StringUtils;
import gg.skytils.vigilance.impl.nightconfig.toml.StringWriter;
import gg.skytils.vigilance.impl.nightconfig.toml.TableWriter;
import gg.skytils.vigilance.impl.nightconfig.toml.Toml;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class TomlWriter
implements ConfigWriter {
    private boolean lenientBareKeys = false;
    private Predicate<UnmodifiableConfig> writeTableInlinePredicate = UnmodifiableConfig::isEmpty;
    private Predicate<String> writeStringLiteralPredicate = c -> false;
    private Predicate<List<?>> indentArrayElementsPredicate = c -> false;
    private char[] indent;
    private char[] newline;
    private int currentIndentLevel;

    public TomlWriter() {
        this.indent = IndentStyle.TABS.chars;
        this.newline = NewlineStyle.system().chars;
    }

    @Override
    public void write(UnmodifiableConfig config2, Writer writer) {
        this.currentIndentLevel = -1;
        WriterOutput output2 = new WriterOutput(writer);
        TableWriter.writeNormal(config2, new ArrayList<String>(), (CharacterOutput)output2, this);
    }

    public boolean isLenientWithBareKeys() {
        return this.lenientBareKeys;
    }

    public void setLenientWithBareKeys(boolean lenientBareKeys) {
        this.lenientBareKeys = lenientBareKeys;
    }

    public void setWriteTableInlinePredicate(Predicate<UnmodifiableConfig> writeTableInlinePredicate) {
        this.writeTableInlinePredicate = writeTableInlinePredicate;
    }

    public void setWriteStringLiteralPredicate(Predicate<String> writeStringLiteralPredicate) {
        this.writeStringLiteralPredicate = writeStringLiteralPredicate;
    }

    public void setIndentArrayElementsPredicate(Predicate<List<?>> indentArrayElementsPredicate) {
        this.indentArrayElementsPredicate = indentArrayElementsPredicate;
    }

    public void setIndent(IndentStyle indentStyle) {
        this.indent = indentStyle.chars;
    }

    public void setIndent(String indentString) {
        this.indent = indentString.toCharArray();
    }

    public void setNewline(NewlineStyle newlineStyle) {
        this.newline = newlineStyle.chars;
    }

    public void setNewline(String newlineString) {
        this.newline = newlineString.toCharArray();
    }

    void increaseIndentLevel() {
        ++this.currentIndentLevel;
    }

    void decreaseIndentLevel() {
        --this.currentIndentLevel;
    }

    void writeIndent(CharacterOutput output2) {
        for (int i = 0; i < this.currentIndentLevel; ++i) {
            output2.write(this.indent);
        }
    }

    void writeNewline(CharacterOutput output2) {
        output2.write(this.newline);
    }

    void writeComment(String commentString, CharacterOutput output2) {
        List<String> comments = StringUtils.splitLines(commentString);
        for (String comment : comments) {
            this.writeIndent(output2);
            output2.write('#');
            output2.write(comment);
            output2.write(this.newline);
        }
    }

    void writeKey(String key2, CharacterOutput output2) {
        if (Toml.isValidBareKey(key2, this.lenientBareKeys)) {
            output2.write(key2);
        } else if (this.writeStringLiteralPredicate.test(key2)) {
            StringWriter.writeLiteral(key2, output2);
        } else {
            StringWriter.writeBasic(key2, output2);
        }
    }

    boolean writesInline(UnmodifiableConfig config2) {
        return this.writeTableInlinePredicate.test(config2);
    }

    boolean writesLiteral(String string) {
        return this.writeStringLiteralPredicate.test(string);
    }

    boolean writesIndented(List<?> list) {
        return this.indentArrayElementsPredicate.test(list);
    }
}

