/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.toml;

import gg.skytils.vigilance.impl.nightconfig.core.UnmodifiableCommentedConfig;
import gg.skytils.vigilance.impl.nightconfig.core.UnmodifiableConfig;
import gg.skytils.vigilance.impl.nightconfig.core.io.CharacterOutput;
import gg.skytils.vigilance.impl.nightconfig.core.io.WritingException;
import gg.skytils.vigilance.impl.nightconfig.toml.ArrayWriter;
import gg.skytils.vigilance.impl.nightconfig.toml.TomlWriter;
import gg.skytils.vigilance.impl.nightconfig.toml.ValueWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class TableWriter {
    private static final char[] KEY_VALUE_SEPARATOR = new char[]{' ', '=', ' '};
    private static final char[] INLINE_ENTRY_SEPARATOR = ArrayWriter.ELEMENT_SEPARATOR;
    private static final char[] ARRAY_OF_TABLES_NAME_BEGIN = new char[]{'[', '['};
    private static final char[] ARRAY_OF_TABLES_NAME_END = new char[]{']', ']'};
    private static final char[] TABLE_NAME_BEGIN = new char[]{'['};
    private static final char[] TABLE_NAME_END = new char[]{']'};

    static void writeInline(UnmodifiableConfig config2, CharacterOutput output2, TomlWriter writer) {
        output2.write('{');
        for (Map.Entry<String, Object> entry : config2.valueMap().entrySet()) {
            String key2 = entry.getKey();
            Object value = entry.getValue();
            writer.writeKey(key2, output2);
            output2.write(KEY_VALUE_SEPARATOR);
            ValueWriter.write(value, output2, writer);
            output2.write(INLINE_ENTRY_SEPARATOR);
        }
        output2.write('}');
    }

    static void writeNormal(UnmodifiableConfig config2, List<String> configPath, CharacterOutput output2, TomlWriter writer) {
        UnmodifiableCommentedConfig commentedConfig = UnmodifiableCommentedConfig.fake(config2);
        TableWriter.writeNormal(commentedConfig, configPath, output2, writer);
    }

    private static void writeNormal(UnmodifiableCommentedConfig config2, List<String> configPath, CharacterOutput output2, TomlWriter writer) {
        ArrayList<UnmodifiableCommentedConfig.Entry> tablesEntries = new ArrayList<UnmodifiableCommentedConfig.Entry>();
        ArrayList<UnmodifiableCommentedConfig.Entry> tableArraysEntries = new ArrayList<UnmodifiableCommentedConfig.Entry>();
        writer.increaseIndentLevel();
        for (UnmodifiableCommentedConfig.Entry entry : config2.entrySet()) {
            List list;
            String key2 = entry.getKey();
            Object value = entry.getValue();
            String comment = entry.getComment();
            if (value instanceof UnmodifiableConfig && !writer.writesInline((UnmodifiableConfig)value)) {
                tablesEntries.add(entry);
                continue;
            }
            if (value instanceof List && !(list = (List)value).isEmpty() && list.get(0) instanceof UnmodifiableConfig) {
                tableArraysEntries.add(entry);
                continue;
            }
            writer.writeComment(comment, output2);
            writer.writeIndent(output2);
            writer.writeKey(key2, output2);
            output2.write(KEY_VALUE_SEPARATOR);
            ValueWriter.write(value, output2, writer);
            writer.writeNewline(output2);
        }
        writer.writeNewline(output2);
        for (UnmodifiableCommentedConfig.Entry entry : tablesEntries) {
            writer.writeComment(entry.getComment(), output2);
            configPath.add(entry.getKey());
            TableWriter.writeTableName(configPath, output2, writer);
            writer.writeNewline(output2);
            TableWriter.writeNormal((UnmodifiableConfig)entry.getValue(), configPath, output2, writer);
            configPath.remove(configPath.size() - 1);
        }
        for (UnmodifiableCommentedConfig.Entry entry : tableArraysEntries) {
            writer.writeComment(entry.getComment(), output2);
            configPath.add(entry.getKey());
            List tableArray = (List)entry.getValue();
            for (UnmodifiableConfig table : tableArray) {
                TableWriter.writeTableArrayName(configPath, output2, writer);
                writer.writeNewline(output2);
                TableWriter.writeNormal(table, configPath, output2, writer);
            }
            configPath.remove(configPath.size() - 1);
        }
        writer.decreaseIndentLevel();
    }

    private static void writeTableArrayName(List<String> name, CharacterOutput output2, TomlWriter writer) {
        TableWriter.writeTableName(name, output2, writer, ARRAY_OF_TABLES_NAME_BEGIN, ARRAY_OF_TABLES_NAME_END);
    }

    private static void writeTableName(List<String> name, CharacterOutput output2, TomlWriter writer) {
        TableWriter.writeTableName(name, output2, writer, TABLE_NAME_BEGIN, TABLE_NAME_END);
    }

    private static void writeTableName(List<String> name, CharacterOutput output2, TomlWriter writer, char[] begin, char[] end2) {
        if (name.isEmpty()) {
            throw new WritingException("Invalid empty table name.");
        }
        writer.writeIndent(output2);
        output2.write(begin);
        Iterator<String> it = name.iterator();
        writer.writeKey(it.next(), output2);
        while (it.hasNext()) {
            output2.write('.');
            writer.writeKey(it.next(), output2);
        }
        output2.write(end2);
    }

    private TableWriter() {
    }
}

