/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils;

import gg.skytils.skytilsmod.utils.ItemRarity;
import gg.skytils.skytilsmod.utils.StringUtilsKt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b-\u0010.J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\n\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0006J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0006J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00182\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0015\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001aJ%\u0010 \u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010!J\u001f\u0010#\u001a\u00020\u0002*\u00020\u00022\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00158\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u0014\u0010(\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b)\u0010&R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lgg/skytils/skytilsmod/utils/ItemUtil;", "", "Lnet/minecraft/item/ItemStack;", "item", "", "getDisplayName", "(Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", "Lnet/minecraft/nbt/NBTTagCompound;", "getExtraAttributes", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/nbt/NBTTagCompound;", "itemStack", "", "getItemLore", "(Lnet/minecraft/item/ItemStack;)Ljava/util/List;", "Lgg/skytils/skytilsmod/utils/ItemRarity;", "getRarity", "(Lnet/minecraft/item/ItemStack;)Lgg/skytils/skytilsmod/utils/ItemRarity;", "getSkullTexture", "getSkyBlockItemID", "extraAttributes", "(Lnet/minecraft/nbt/NBTTagCompound;)Ljava/lang/String;", "", "getStarCount", "(Lnet/minecraft/nbt/NBTTagCompound;)I", "", "hasRightClickAbility", "(Lnet/minecraft/item/ItemStack;)Z", "isPet", "stack", "isSalvageable", "texture", "SkullOwner", "setSkullTexture", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;Ljava/lang/String;)Lnet/minecraft/item/ItemStack;", "lines", "setLore", "(Lnet/minecraft/item/ItemStack;Ljava/util/List;)Lnet/minecraft/item/ItemStack;", "NBT_COMPOUND", "I", "NBT_INTEGER", "NBT_LIST", "NBT_STRING", "Lkotlin/text/Regex;", "PET_PATTERN", "Lkotlin/text/Regex;", "<init>", "()V", "SkytilsMod"})
public final class ItemUtil {
    @NotNull
    public static final ItemUtil INSTANCE = new ItemUtil();
    @NotNull
    private static final Regex PET_PATTERN = new Regex("(?:\u00a7e\u2b50 )?\u00a77\\[Lvl \\d+](?: \u00a78\\[.*])? (?<color>\u00a7[0-9a-fk-or]).+");
    public static final int NBT_INTEGER = 3;
    private static final int NBT_STRING = 8;
    private static final int NBT_LIST = 9;
    private static final int NBT_COMPOUND = 10;

    private ItemUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String getDisplayName(@NotNull ItemStack item) {
        NBTTagCompound nbtTagCompound;
        Intrinsics.checkNotNullParameter(item, "item");
        String s = item.func_77973_b().func_77653_i(item);
        if (item.func_77978_p() != null && item.func_77978_p().func_150297_b("display", 10) && (nbtTagCompound = item.func_77978_p().func_74775_l("display")).func_150297_b("Name", 8)) {
            s = nbtTagCompound.func_74779_i("Name");
        }
        String string = s;
        Intrinsics.checkNotNull(string);
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String getSkyBlockItemID(@Nullable ItemStack item) {
        if (item == null) {
            return null;
        }
        NBTTagCompound nBTTagCompound = ItemUtil.getExtraAttributes(item);
        if (nBTTagCompound == null) {
            return null;
        }
        NBTTagCompound extraAttributes = nBTTagCompound;
        return !extraAttributes.func_150297_b("id", 8) ? null : extraAttributes.func_74779_i("id");
    }

    @JvmStatic
    @Nullable
    public static final NBTTagCompound getExtraAttributes(@Nullable ItemStack item) {
        return item == null || !item.func_77942_o() ? null : item.func_179543_a("ExtraAttributes", false);
    }

    @JvmStatic
    @Nullable
    public static final String getSkyBlockItemID(@Nullable NBTTagCompound extraAttributes) {
        if (extraAttributes != null) {
            String itemId = extraAttributes.func_74779_i("id");
            Intrinsics.checkNotNull(itemId);
            if (((CharSequence)itemId).length() > 0) {
                return itemId;
            }
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final List<String> getItemLore(@NotNull ItemStack itemStack) {
        NBTTagCompound display;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("display", 10) && (display = itemStack.func_77978_p().func_74775_l("display")).func_150297_b("Lore", 9)) {
            NBTTagList lore = display.func_150295_c("Lore", 8);
            ArrayList<String> loreAsList = new ArrayList<String>(lore.func_74745_c());
            int n = lore.func_74745_c();
            for (int lineNumber = 0; lineNumber < n; ++lineNumber) {
                loreAsList.add(lore.func_150307_f(lineNumber));
            }
            List<String> list = Collections.unmodifiableList((List)loreAsList);
            Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(...)");
            return list;
        }
        return CollectionsKt.emptyList();
    }

    @JvmStatic
    public static final boolean hasRightClickAbility(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        for (String line : ItemUtil.getItemLore(itemStack)) {
            String stripped = StringUtilsKt.stripControlCodes(line);
            if (!StringsKt.startsWith$default(stripped, "Item Ability:", false, 2, null) || !StringsKt.endsWith$default(stripped, "RIGHT CLICK", false, 2, null)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final ItemRarity getRarity(@Nullable ItemStack item) {
        if (item == null || !item.func_77942_o()) {
            return ItemRarity.NONE;
        }
        NBTTagCompound display = item.func_179543_a("display", false);
        if (display == null || !display.func_74764_b("Lore")) {
            return ItemRarity.NONE;
        }
        NBTTagList lore = display.func_150295_c("Lore", 8);
        String name = display.func_74779_i("Name");
        for (int i = lore.func_74745_c() - 1; -1 < i; --i) {
            Object v2;
            block7: {
                Object object;
                String currentLine = lore.func_150307_f(i);
                Regex regex = ItemRarity.Companion.getRARITY_PATTERN();
                Intrinsics.checkNotNull(currentLine);
                MatchResult rarityMatcher = Regex.find$default(regex, currentLine, 0, 2, null);
                if (rarityMatcher == null || (object = RegexExtensionsJDK8Kt.get(rarityMatcher.getGroups(), "rarity")) == null || (object = ((MatchGroup)object).getValue()) == null) continue;
                Object rarity = object;
                Iterable iterable = ItemRarity.getEntries();
                for (Object t : iterable) {
                    ItemRarity it = (ItemRarity)((Object)t);
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getRarityName(), StringsKt.substringAfter$default(StringUtilsKt.stripControlCodes((String)rarity), "SHINY ", null, 2, null))) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            ItemRarity itemRarity = v2;
            if (itemRarity == null) continue;
            ItemRarity it = itemRarity;
            boolean bl = false;
            return it;
        }
        Intrinsics.checkNotNull(name);
        MatchResult petRarityMatcher = Regex.find$default(PET_PATTERN, name, 0, 2, null);
        if (petRarityMatcher != null) {
            String string = CollectionsKt.getOrNull(petRarityMatcher.getGroupValues(), 1);
            if (string == null) {
                return ItemRarity.NONE;
            }
            String color = string;
            ItemRarity itemRarity = ItemRarity.Companion.byBaseColor(color);
            if (itemRarity == null) {
                itemRarity = ItemRarity.NONE;
            }
            return itemRarity;
        }
        return ItemRarity.NONE;
    }

    public final boolean isPet(@Nullable ItemStack item) {
        if (item == null || !item.func_77942_o()) {
            return false;
        }
        NBTTagCompound display = item.func_179543_a("display", false);
        if (display == null || !display.func_74764_b("Lore")) {
            return false;
        }
        String name = display.func_74779_i("Name");
        Intrinsics.checkNotNull(name);
        return PET_PATTERN.matches(name);
    }

    @NotNull
    public final ItemStack setSkullTexture(@NotNull ItemStack item, @NotNull String texture, @NotNull String SkullOwner) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(texture, "texture");
        Intrinsics.checkNotNullParameter(SkullOwner, "SkullOwner");
        NBTTagCompound textureTagCompound = new NBTTagCompound();
        textureTagCompound.func_74778_a("Value", texture);
        NBTTagList textures = new NBTTagList();
        textures.func_74742_a((NBTBase)textureTagCompound);
        NBTTagCompound properties2 = new NBTTagCompound();
        properties2.func_74782_a("textures", (NBTBase)textures);
        NBTTagCompound skullOwner = new NBTTagCompound();
        skullOwner.func_74778_a("Id", SkullOwner);
        skullOwner.func_74782_a("Properties", (NBTBase)properties2);
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74782_a("SkullOwner", (NBTBase)skullOwner);
        item.func_77982_d(nbtTag);
        return item;
    }

    @Nullable
    public final String getSkullTexture(@Nullable ItemStack item) {
        ItemStack itemStack = item;
        if (!Intrinsics.areEqual(itemStack != null ? itemStack.func_77973_b() : null, Items.field_151144_bL)) {
            return null;
        }
        ItemStack itemStack2 = item;
        Object object = itemStack2 != null ? itemStack2.func_77978_p() : null;
        if (object == null) {
            return null;
        }
        NBTTagCompound nbt = object;
        if (!nbt.func_74764_b("SkullOwner")) {
            return null;
        }
        return nbt.func_74775_l("SkullOwner").func_74775_l("Properties").func_150295_c("textures", 10).func_150305_b(0).func_74779_i("Value");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ItemStack setLore(@NotNull ItemStack $this$setLore, @NotNull List<String> lines) {
        void $this$setLore_u24lambda_u243;
        NBTTagList nBTTagList;
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkNotNullParameter($this$setLore, "<this>");
        Intrinsics.checkNotNullParameter(lines, "lines");
        NBTTagCompound nBTTagCompound2 = nBTTagCompound = $this$setLore.func_179543_a("display", true);
        String string = "display";
        ItemStack itemStack = $this$setLore;
        boolean bl = false;
        NBTTagList nBTTagList2 = nBTTagList = new NBTTagList();
        String string2 = "Lore";
        void var9_11 = $this$setLore_u24lambda_u243;
        boolean bl2 = false;
        for (String line : lines) {
            void $this$setLore_u24lambda_u243_u24lambda_u242;
            $this$setLore_u24lambda_u243_u24lambda_u242.func_74742_a((NBTBase)new NBTTagString(line));
        }
        Unit unit = Unit.INSTANCE;
        var9_11.func_74782_a(string2, (NBTBase)nBTTagList);
        Unit unit2 = Unit.INSTANCE;
        itemStack.func_77983_a(string, (NBTBase)nBTTagCompound);
        return $this$setLore;
    }

    public final int getStarCount(@NotNull NBTTagCompound extraAttributes) {
        Intrinsics.checkNotNullParameter(extraAttributes, "extraAttributes");
        return Math.max(extraAttributes.func_74762_e("upgrade_level"), extraAttributes.func_74762_e("dungeon_item_level"));
    }

    public final boolean isSalvageable(@NotNull ItemStack stack2) {
        Intrinsics.checkNotNullParameter(stack2, "stack");
        NBTTagCompound extraAttr = ItemUtil.getExtraAttributes(stack2);
        String sbId = ItemUtil.getSkyBlockItemID(extraAttr);
        return extraAttr != null && extraAttr.func_74764_b("baseStatBoostPercentage") && this.getStarCount(extraAttr) == 0 && !Intrinsics.areEqual(sbId, "ICE_SPRAY_WAND");
    }
}

