/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.json.internal;

import gg.skytils.ktx-serialization.json.internal.CharArrayPool;
import gg.skytils.ktx-serialization.json.internal.InternalJsonWriter;
import gg.skytils.ktx-serialization.json.internal.StringOpsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b&\u0010\u0012J'\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b \u0010\u0017R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lgg/skytils/ktx-serialization/json/internal/JsonToStringWriter;", "Lgg/skytils/ktx-serialization/json/internal/InternalJsonWriter;", "", "firstEscapedChar", "currentSize", "", "string", "", "appendStringSlowPath", "(IILjava/lang/String;)V", "expected", "ensureAdditionalCapacity", "(I)V", "oldSize", "additional", "ensureTotalCapacity", "(II)I", "release", "()V", "toString", "()Ljava/lang/String;", "text", "write", "(Ljava/lang/String;)V", "", "char", "writeChar", "(C)V", "", "value", "writeLong", "(J)V", "writeQuoted", "", "array", "[C", "size", "I", "<init>", "kotlinx-serialization-json"})
public final class JsonToStringWriter
implements InternalJsonWriter {
    @NotNull
    private char[] array = CharArrayPool.INSTANCE.take();
    private int size;

    @Override
    public void writeLong(long value) {
        this.write(String.valueOf(value));
    }

    @Override
    public void writeChar(char c) {
        this.ensureAdditionalCapacity(1);
        int n = this.size;
        this.size = n + 1;
        this.array[n] = c;
    }

    @Override
    public void write(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        int length = text2.length();
        if (length == 0) {
            return;
        }
        this.ensureAdditionalCapacity(length);
        String string = text2;
        char[] cArray = this.array;
        int n = this.size;
        int n2 = 0;
        int n3 = text2.length();
        string.getChars(n2, n3, cArray, n);
        this.size += length;
    }

    @Override
    public void writeQuoted(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        this.ensureAdditionalCapacity(text2.length() + 2);
        char[] arr = this.array;
        int sz = this.size;
        arr[sz++] = 34;
        int length = text2.length();
        String string = text2;
        int n = 0;
        string.getChars(n, length, arr, sz);
        n = sz + length;
        for (int i = sz; i < n; ++i) {
            char ch = arr[i];
            if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            this.appendStringSlowPath(i - sz, i, text2);
            return;
        }
        sz += length;
        arr[sz++] = 34;
        this.size = sz;
    }

    private final void appendStringSlowPath(int firstEscapedChar, int currentSize, String string) {
        int sz = currentSize;
        int n = string.length();
        for (int i = firstEscapedChar; i < n; ++i) {
            sz = this.ensureTotalCapacity(sz, 2);
            char ch = string.charAt(i);
            if (ch < StringOpsKt.getESCAPE_MARKERS().length) {
                byte marker = StringOpsKt.getESCAPE_MARKERS()[ch];
                if (marker == 0) {
                    this.array[sz++] = ch;
                    continue;
                }
                if (marker == 1) {
                    String escapedString;
                    Intrinsics.checkNotNull(StringOpsKt.getESCAPE_STRINGS()[ch]);
                    sz = this.ensureTotalCapacity(sz, escapedString.length());
                    String string2 = escapedString;
                    char[] cArray = this.array;
                    int n2 = 0;
                    int n3 = escapedString.length();
                    string2.getChars(n2, n3, cArray, sz);
                    this.size = sz += escapedString.length();
                    continue;
                }
                this.array[sz] = 92;
                this.array[sz + 1] = (char)marker;
                this.size = sz += 2;
                continue;
            }
            this.array[sz++] = ch;
        }
        sz = this.ensureTotalCapacity(sz, 1);
        this.array[sz++] = 34;
        this.size = sz;
    }

    @Override
    public void release() {
        CharArrayPool.INSTANCE.release(this.array);
    }

    @NotNull
    public String toString() {
        return new String(this.array, 0, this.size);
    }

    private final void ensureAdditionalCapacity(int expected) {
        this.ensureTotalCapacity(this.size, expected);
    }

    private final int ensureTotalCapacity(int oldSize, int additional) {
        int newSize = oldSize + additional;
        if (this.array.length <= newSize) {
            char[] cArray = Arrays.copyOf(this.array, RangesKt.coerceAtLeast(newSize, oldSize * 2));
            Intrinsics.checkNotNullExpressionValue(cArray, "copyOf(...)");
            this.array = cArray;
        }
        return oldSize;
    }
}

