/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.util.date;

import gg.skytils.ktor.util.date.GMTDate;
import gg.skytils.ktor.util.date.GMTDateBuilder;
import gg.skytils.ktor.util.date.InvalidDateStringException;
import gg.skytils.ktor.util.date.Month;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\f\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lgg/skytils/ktor/util/date/GMTDateParser;", "", "", "dateString", "Lgg/skytils/ktor/util/date/GMTDate;", "parse", "(Ljava/lang/String;)Lgg/skytils/ktor/util/date/GMTDate;", "Lgg/skytils/ktor/util/date/GMTDateBuilder;", "", "type", "chunk", "", "handleToken", "(Lgg/skytils/ktor/util/date/GMTDateBuilder;CLjava/lang/String;)V", "pattern", "Ljava/lang/String;", "<init>", "(Ljava/lang/String;)V", "Companion", "ktor-utils"})
@SourceDebugExtension(value={"SMAP\nGMTDateParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GMTDateParser.kt\nio/ktor/util/date/GMTDateParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,128:1\n1#2:129\n1064#3,2:130\n*S KotlinDebug\n*F\n+ 1 GMTDateParser.kt\nio/ktor/util/date/GMTDateParser\n*L\n89#1:130,2\n*E\n"})
public final class GMTDateParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    public static final char SECONDS = 's';
    public static final char MINUTES = 'm';
    public static final char HOURS = 'h';
    public static final char DAY_OF_MONTH = 'd';
    public static final char MONTH = 'M';
    public static final char YEAR = 'Y';
    public static final char ZONE = 'z';
    public static final char ANY = '*';

    public GMTDateParser(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        this.pattern = pattern;
        if (!(((CharSequence)this.pattern).length() > 0)) {
            boolean bl = false;
            String string = "Date parser pattern shouldn't be empty.";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final GMTDate parse(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter(dateString, "dateString");
        GMTDateBuilder builder = new GMTDateBuilder();
        int start2 = 0;
        char current = this.pattern.charAt(start2);
        int chunkStart = 0;
        int index = 1;
        try {
            while (index < this.pattern.length()) {
                if (this.pattern.charAt(index) == current) {
                    ++index;
                    continue;
                }
                int chunkEnd = chunkStart + index - start2;
                String string = dateString.substring(chunkStart, chunkEnd);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                this.handleToken(builder, current, string);
                chunkStart = chunkEnd;
                start2 = index;
                current = this.pattern.charAt(index);
                ++index;
            }
            if (chunkStart < dateString.length()) {
                String string = dateString.substring(chunkStart);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                this.handleToken(builder, current, string);
            }
        }
        catch (Throwable _) {
            throw new InvalidDateStringException(dateString, chunkStart, this.pattern);
        }
        return builder.build();
    }

    private final void handleToken(GMTDateBuilder $this$handleToken, char type2, String chunk) {
        char c = type2;
        if (c == 's') {
            $this$handleToken.setSeconds(Integer.parseInt(chunk));
        } else if (c == 'm') {
            $this$handleToken.setMinutes(Integer.parseInt(chunk));
        } else if (c == 'h') {
            $this$handleToken.setHours(Integer.parseInt(chunk));
        } else if (c == 'd') {
            $this$handleToken.setDayOfMonth(Integer.parseInt(chunk));
        } else if (c == 'M') {
            $this$handleToken.setMonth(Month.Companion.from(chunk));
        } else if (c == 'Y') {
            $this$handleToken.setYear(Integer.parseInt(chunk));
        } else if (c == 'z') {
            if (!Intrinsics.areEqual(chunk, "GMT")) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        } else if (c != '*') {
            boolean bl;
            block18: {
                CharSequence $this$all$iv = chunk;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl2 = false;
                    if (it == type2) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
            if (!bl) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\f\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0014\u0010\u0007\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0004R\u0014\u0010\b\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0004R\u0014\u0010\t\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0004R\u0014\u0010\n\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0004R\u0014\u0010\u000b\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0004\u00a8\u0006\u000e"}, d2={"Lgg/skytils/ktor/util/date/GMTDateParser$Companion;", "", "", "ANY", "C", "DAY_OF_MONTH", "HOURS", "MINUTES", "MONTH", "SECONDS", "YEAR", "ZONE", "<init>", "()V", "ktor-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

