/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.util;

import gg.skytils.ktor.util.CharsetKt;
import gg.skytils.ktor.util.CryptoKt;
import gg.skytils.ktor.util.Digest;
import gg.skytils.ktor.util.InternalAPI;
import gg.skytils.ktor.utils.io.charsets.CharsetJVMKt;
import gg.skytils.ktor.utils.io.core.BytePacketBuilder;
import gg.skytils.ktor.utils.io.core.ByteReadPacket;
import gg.skytils.ktor.utils.io.core.Output;
import gg.skytils.ktor.utils.io.core.StringsKt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=5, xi=48, d1={"\u00002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0003\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\n\u001a\u001f\u0010\f\u001a\u00020\u0002*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0002H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a-\u0010\f\u001a\u00020\u0002*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00062\f\b\u0002\u0010\u0011\u001a\u00060\u000fj\u0002`\u0010H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\f\u0010\u0012\"\u0014\u0010\u0013\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\"\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"", "size", "", "generateNonce", "(I)[B", "bytes", "", "hex", "([B)Ljava/lang/String;", "s", "(Ljava/lang/String;)[B", "Lgg/skytils/ktor/util/Digest;", "build", "(Lio/ktor/util/Digest;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "string", "Ljava/nio/charset/Charset;", "Lgg/skytils/ktor/utils/io/charsets/Charset;", "charset", "(Lio/ktor/util/Digest;Ljava/lang/String;Ljava/nio/charset/Charset;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "NONCE_SIZE_IN_BYTES", "I", "", "digits", "[C", "ktor-utils"}, xs="gg/skytils/ktor/util/CryptoKt")
@SourceDebugExtension(value={"SMAP\nCrypto.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Crypto.kt\nio/ktor/util/CryptoKt__CryptoKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 Strings.kt\nio/ktor/utils/io/core/StringsKt\n*L\n1#1,112:1\n12#2,11:113\n8#3,3:124\n*S KotlinDebug\n*F\n+ 1 Crypto.kt\nio/ktor/util/CryptoKt__CryptoKt\n*L\n58#1:113,11\n109#1:124,3\n*E\n"})
final class CryptoKt__CryptoKt {
    @NotNull
    private static final char[] digits = CharsetKt.toCharArray("0123456789abcdef");

    @NotNull
    public static final String hex(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        char[] result2 = new char[bytes.length * 2];
        int resultIndex = 0;
        char[] digits = CryptoKt__CryptoKt.digits;
        int n = bytes.length;
        for (int index = 0; index < n; ++index) {
            int b = bytes[index] & 0xFF;
            result2[resultIndex++] = digits[b >> 4];
            result2[resultIndex++] = digits[b & 0xF];
        }
        return kotlin.text.StringsKt.concatToString(result2);
    }

    @NotNull
    public static final byte[] hex(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        byte[] result2 = new byte[s.length() / 2];
        int n = result2.length;
        for (int idx = 0; idx < n; ++idx) {
            int srcIdx = idx * 2;
            int high = Integer.parseInt(String.valueOf(s.charAt(srcIdx)), CharsKt.checkRadix(16)) << 4;
            int low = Integer.parseInt(String.valueOf(s.charAt(srcIdx + 1)), CharsKt.checkRadix(16));
            result2[idx] = (byte)(high | low);
        }
        return result2;
    }

    @NotNull
    public static final byte[] generateNonce(int size2) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$generateNonce_u24lambda_u240 = builder$iv;
            boolean bl = false;
            while ($this$generateNonce_u24lambda_u240.getSize() < size2) {
                StringsKt.writeText$default((Output)$this$generateNonce_u24lambda_u240, CryptoKt.generateNonce(), 0, 0, null, 14, null);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return StringsKt.readBytes(byteReadPacket, size2);
    }

    @InternalAPI
    @Nullable
    public static final Object build(@NotNull Digest $this$build, @NotNull byte[] bytes, @NotNull Continuation<? super byte[]> $completion) {
        $this$build.plusAssign(bytes);
        return $this$build.build($completion);
    }

    @InternalAPI
    @Nullable
    public static final Object build(@NotNull Digest $this$build, @NotNull String string, @NotNull Charset charset, @NotNull Continuation<? super byte[]> $completion) {
        byte[] byArray;
        String $this$toByteArray$iv = string;
        boolean $i$f$toByteArray = false;
        if (Intrinsics.areEqual(charset, Charsets.UTF_8)) {
            byArray = kotlin.text.StringsKt.encodeToByteArray($this$toByteArray$iv);
        } else {
            CharsetEncoder charsetEncoder = charset.newEncoder();
            Intrinsics.checkNotNullExpressionValue(charsetEncoder, "charset.newEncoder()");
            byArray = CharsetJVMKt.encodeToByteArray(charsetEncoder, $this$toByteArray$iv, 0, $this$toByteArray$iv.length());
        }
        $this$build.plusAssign(byArray);
        return $this$build.build($completion);
    }

    public static /* synthetic */ Object build$default(Digest digest, String string, Charset charset, Continuation continuation2, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return CryptoKt.build(digest, string, charset, continuation2);
    }
}

