/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.sessions;

import gg.skytils.ktor.server.sessions.CurrentSession;
import gg.skytils.ktor.server.sessions.SessionProviderData;
import gg.skytils.ktor.server.sessions.TooLateSessionSetException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0012\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ*\u0010\u000f\u001a\u00020\u00002\u0018\b\u0002\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0018\u001a\u00020\u00022\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ!\u0010 \u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0004\b \u0010!J1\u0010$\u001a\u00020\u0004\"\b\b\u0000\u0010\"*\u00020\u00112\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R'\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010*\u001a\u0004\b+\u0010\r\u00a8\u0006."}, d2={"Lgg/skytils/ktor/server/sessions/SessionData;", "Lgg/skytils/ktor/server/sessions/CurrentSession;", "", "name", "", "clear", "(Ljava/lang/String;)V", "commit$ktor_server_sessions", "()V", "commit", "", "Lgg/skytils/ktor/server/sessions/SessionProviderData;", "component1", "()Ljava/util/Map;", "providerData", "copy", "(Ljava/util/Map;)Lgg/skytils/ktor/server/sessions/SessionData;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lkotlin/reflect/KClass;", "type", "findName", "(Lkotlin/reflect/KClass;)Ljava/lang/String;", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "", "hashCode", "()I", "value", "set", "(Ljava/lang/String;Ljava/lang/Object;)V", "S", "data", "setTyped", "(Lgg/skytils/ktor/server/sessions/SessionProviderData;Ljava/lang/Object;)V", "toString", "()Ljava/lang/String;", "committed", "Z", "Ljava/util/Map;", "getProviderData", "<init>", "(Ljava/util/Map;)V", "ktor-server-sessions"})
@SourceDebugExtension(value={"SMAP\nSessionData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionData.kt\nio/ktor/server/sessions/SessionData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n288#2,2:186\n*S KotlinDebug\n*F\n+ 1 SessionData.kt\nio/ktor/server/sessions/SessionData\n*L\n99#1:186,2\n*E\n"})
public final class SessionData
implements CurrentSession {
    @NotNull
    private final Map<String, SessionProviderData<?>> providerData;
    private boolean committed;

    public SessionData(@NotNull Map<String, ? extends SessionProviderData<?>> providerData) {
        Intrinsics.checkNotNullParameter(providerData, "providerData");
        this.providerData = providerData;
    }

    @NotNull
    public final Map<String, SessionProviderData<?>> getProviderData() {
        return this.providerData;
    }

    public final void commit$ktor_server_sessions() {
        this.committed = true;
    }

    @Override
    @NotNull
    public String findName(@NotNull KClass<?> type2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(type2, "type");
            Iterable $this$firstOrNull$iv = this.providerData.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((SessionProviderData)it.getValue()).getProvider().getType(), type2)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry == null) {
            throw new IllegalArgumentException("Session data for type `" + type2 + "` was not registered");
        }
        Map.Entry entry2 = entry;
        return ((SessionProviderData)entry2.getValue()).getProvider().getName();
    }

    @Override
    public void set(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.committed) {
            throw new TooLateSessionSetException();
        }
        SessionProviderData<?> sessionProviderData = this.providerData.get(name);
        if (sessionProviderData == null) {
            throw new IllegalStateException("Session data for `" + name + "` was not registered");
        }
        SessionProviderData<?> providerData = sessionProviderData;
        this.setTyped(providerData, value);
    }

    private final <S> void setTyped(SessionProviderData<S> data2, Object value) {
        if (value != null) {
            data2.getProvider().getTracker().validate(value);
        }
        Intrinsics.checkNotNull(value, "null cannot be cast to non-null type S of io.ktor.server.sessions.SessionData.setTyped");
        data2.setNewValue(value);
    }

    @Override
    @Nullable
    public Object get(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        SessionProviderData<?> sessionProviderData = this.providerData.get(name);
        if (sessionProviderData == null) {
            throw new IllegalStateException("Session data for `" + name + "` was not registered");
        }
        SessionProviderData<?> providerData = sessionProviderData;
        Object obj = providerData.getNewValue();
        if (obj == null) {
            obj = providerData.getOldValue();
        }
        return obj;
    }

    @Override
    public void clear(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        SessionProviderData<?> sessionProviderData = this.providerData.get(name);
        if (sessionProviderData == null) {
            throw new IllegalStateException("Session data for `" + name + "` was not registered");
        }
        SessionProviderData<?> providerData = sessionProviderData;
        providerData.setOldValue(null);
        providerData.setNewValue(null);
    }

    @NotNull
    public final Map<String, SessionProviderData<?>> component1() {
        return this.providerData;
    }

    @NotNull
    public final SessionData copy(@NotNull Map<String, ? extends SessionProviderData<?>> providerData) {
        Intrinsics.checkNotNullParameter(providerData, "providerData");
        return new SessionData(providerData);
    }

    public static /* synthetic */ SessionData copy$default(SessionData sessionData, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = sessionData.providerData;
        }
        return sessionData.copy(map2);
    }

    @NotNull
    public String toString() {
        return "SessionData(providerData=" + this.providerData + ')';
    }

    public int hashCode() {
        return ((Object)this.providerData).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SessionData)) {
            return false;
        }
        SessionData sessionData = (SessionData)other;
        return Intrinsics.areEqual(this.providerData, sessionData.providerData);
    }
}

