/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.sessions;

import gg.skytils.ktor.server.sessions.CacheStorage;
import gg.skytils.ktor.server.sessions.DirectoryStorage;
import gg.skytils.ktor.server.sessions.SessionStorage;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u001f\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001c\u0010\t\u001a\u00020\b*\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0082\u0010\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0013\u0010\u000b\u001a\u00020\b*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ljava/io/File;", "rootDir", "", "cached", "Lgg/skytils/ktor/server/sessions/SessionStorage;", "directorySessionStorage", "(Ljava/io/File;Z)Lgg/skytils/ktor/server/sessions/SessionStorage;", "mostTop", "", "deleteParentsWhileEmpty", "(Ljava/io/File;Ljava/io/File;)V", "mkdirsOrFail", "(Ljava/io/File;)V", "ktor-server-sessions"})
public final class DirectoryStorageKt {
    @NotNull
    public static final SessionStorage directorySessionStorage(@NotNull File rootDir, boolean cached) {
        SessionStorage sessionStorage;
        Intrinsics.checkNotNullParameter(rootDir, "rootDir");
        boolean bl = cached;
        if (bl) {
            sessionStorage = new CacheStorage(new DirectoryStorage(rootDir), 60000L);
        } else if (!bl) {
            sessionStorage = new DirectoryStorage(rootDir);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sessionStorage;
    }

    public static /* synthetic */ SessionStorage directorySessionStorage$default(File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return DirectoryStorageKt.directorySessionStorage(file2, bl);
    }

    private static final void mkdirsOrFail(File $this$mkdirsOrFail) {
        if (!$this$mkdirsOrFail.mkdirs() && !$this$mkdirsOrFail.exists()) {
            throw new IOException("Couldn't create directory " + $this$mkdirsOrFail);
        }
        if (!$this$mkdirsOrFail.isDirectory()) {
            throw new IOException("Path is not a directory: " + $this$mkdirsOrFail);
        }
    }

    private static final void deleteParentsWhileEmpty(File $this$deleteParentsWhileEmpty, File mostTop) {
        Object object;
        while (!Intrinsics.areEqual($this$deleteParentsWhileEmpty, mostTop) && $this$deleteParentsWhileEmpty.isDirectory() && $this$deleteParentsWhileEmpty.exists() && ((object = $this$deleteParentsWhileEmpty.list()) == null || ((String[])object).length == 0)) {
            if (!$this$deleteParentsWhileEmpty.delete() && $this$deleteParentsWhileEmpty.exists()) {
                throw new IOException("Failed to delete dir " + $this$deleteParentsWhileEmpty);
            }
            File file2 = $this$deleteParentsWhileEmpty.getParentFile();
            Intrinsics.checkNotNullExpressionValue(file2, "parentFile");
            object = file2;
            File file3 = mostTop;
            $this$deleteParentsWhileEmpty = object;
            mostTop = file3;
        }
    }

    public static final /* synthetic */ void access$mkdirsOrFail(File $receiver) {
        DirectoryStorageKt.mkdirsOrFail($receiver);
    }

    public static final /* synthetic */ void access$deleteParentsWhileEmpty(File $receiver, File mostTop) {
        DirectoryStorageKt.deleteParentsWhileEmpty($receiver, mostTop);
    }
}

