/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.routing;

import gg.skytils.ktor.http.HeaderValue;
import gg.skytils.ktor.http.HttpHeaderValueParserKt;
import gg.skytils.ktor.server.routing.RouteSelector;
import gg.skytils.ktor.server.routing.RouteSelectorEvaluation;
import gg.skytils.ktor.server.routing.RoutingResolveContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J$\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0004R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0019\u001a\u0004\b\u001a\u0010\u0004R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0019\u001a\u0004\b\u001b\u0010\u0004\u00a8\u0006\u001e"}, d2={"Lgg/skytils/ktor/server/routing/HttpHeaderRouteSelector;", "Lgg/skytils/ktor/server/routing/RouteSelector;", "", "component1", "()Ljava/lang/String;", "component2", "name", "value", "copy", "(Ljava/lang/String;Ljava/lang/String;)Lgg/skytils/ktor/server/routing/HttpHeaderRouteSelector;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lgg/skytils/ktor/server/routing/RoutingResolveContext;", "context", "", "segmentIndex", "Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lgg/skytils/ktor/server/routing/RoutingResolveContext;I)Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation;", "hashCode", "()I", "toString", "Ljava/lang/String;", "getName", "getValue", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/HttpHeaderRouteSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,700:1\n288#2,2:701\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/HttpHeaderRouteSelector\n*L\n569#1:701,2\n*E\n"})
public final class HttpHeaderRouteSelector
extends RouteSelector {
    @NotNull
    private final String name;
    @NotNull
    private final String value;

    public HttpHeaderRouteSelector(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        this.name = name;
        this.value = value;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(context, "context");
            String headers2 = context.getCall().getRequest().getHeaders().get(this.name);
            List<HeaderValue> parsedHeaders = HttpHeaderValueParserKt.parseAndSortHeader(headers2);
            Iterable $this$firstOrNull$iv = parsedHeaders;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HeaderValue it = (HeaderValue)element$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getValue(), this.value, true)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        HeaderValue headerValue = v0;
        if (headerValue == null) {
            return RouteSelectorEvaluation.Companion.getFailedParameter();
        }
        HeaderValue header = headerValue;
        return new RouteSelectorEvaluation.Success(header.getQuality(), null, 0, 6, null);
    }

    @NotNull
    public String toString() {
        return "(header:" + this.name + " = " + this.value + ')';
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.value;
    }

    @NotNull
    public final HttpHeaderRouteSelector copy(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        return new HttpHeaderRouteSelector(name, value);
    }

    public static /* synthetic */ HttpHeaderRouteSelector copy$default(HttpHeaderRouteSelector httpHeaderRouteSelector, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = httpHeaderRouteSelector.name;
        }
        if ((n & 2) != 0) {
            string2 = httpHeaderRouteSelector.value;
        }
        return httpHeaderRouteSelector.copy(string, string2);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.value.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpHeaderRouteSelector)) {
            return false;
        }
        HttpHeaderRouteSelector httpHeaderRouteSelector = (HttpHeaderRouteSelector)other;
        if (!Intrinsics.areEqual(this.name, httpHeaderRouteSelector.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.value, httpHeaderRouteSelector.value);
    }
}

