/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.plugins.compression;

import gg.skytils.ktor.http.ContentType;
import gg.skytils.ktor.http.HttpHeaders;
import gg.skytils.ktor.http.content.OutgoingContent;
import gg.skytils.ktor.server.application.ApplicationCall;
import gg.skytils.ktor.server.plugins.compression.CompressionConfig;
import gg.skytils.ktor.server.plugins.compression.CompressionEncoderBuilder;
import gg.skytils.ktor.server.plugins.compression.ConditionsHolderBuilder;
import gg.skytils.ktor.server.plugins.compression.ConfigKt;
import gg.skytils.ktor.server.plugins.compression.DeflateEncoder;
import gg.skytils.ktor.server.plugins.compression.GzipEncoder;
import gg.skytils.ktor.server.plugins.compression.IdentityEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\u001a0\u0010\b\u001a\u00020\u0007*\u00020\u00002\u001d\u0010\u0006\u001a\u0019\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0013\u0010\n\u001a\u00020\u0007*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\n\u0010\u000b\u001a,\u0010\u0010\u001a\u00020\u0007*\u00020\f2\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a%\u0010\u0015\u001a\u00020\u0007*\u00020\u00002\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a,\u0010\u0017\u001a\u00020\u0007*\u00020\f2\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u0017\u0010\u0011\u001a,\u0010\u0018\u001a\u00020\u0007*\u00020\f2\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u0018\u0010\u0011\u001a%\u0010\u0019\u001a\u00020\u0007*\u00020\u00002\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013\u00a2\u0006\u0004\b\u0019\u0010\u0016\u001a\u0019\u0010\u001c\u001a\u00020\u0007*\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lgg/skytils/ktor/server/plugins/compression/ConditionsHolderBuilder;", "Lkotlin/Function2;", "Lgg/skytils/ktor/server/application/ApplicationCall;", "Lgg/skytils/ktor/http/content/OutgoingContent;", "", "Lkotlin/ExtensionFunctionType;", "predicate", "", "condition", "(Lgg/skytils/ktor/server/plugins/compression/ConditionsHolderBuilder;Lkotlin/jvm/functions/Function2;)V", "defaultConditions", "(Lgg/skytils/ktor/server/plugins/compression/ConditionsHolderBuilder;)V", "Lgg/skytils/ktor/server/plugins/compression/CompressionConfig;", "Lkotlin/Function1;", "Lgg/skytils/ktor/server/plugins/compression/CompressionEncoderBuilder;", "block", "deflate", "(Lgg/skytils/ktor/server/plugins/compression/CompressionConfig;Lkotlin/jvm/functions/Function1;)V", "", "Lgg/skytils/ktor/http/ContentType;", "mimeTypes", "excludeContentType", "(Lio/ktor/server/plugins/compression/ConditionsHolderBuilder;[Lio/ktor/http/ContentType;)V", "gzip", "identity", "matchContentType", "", "minSize", "minimumSize", "(Lgg/skytils/ktor/server/plugins/compression/ConditionsHolderBuilder;J)V", "ktor-server-compression"})
public final class ConfigKt {
    public static final void gzip(@NotNull CompressionConfig $this$gzip, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter($this$gzip, "<this>");
        Intrinsics.checkNotNullParameter(block2, "block");
        $this$gzip.encoder("gzip", GzipEncoder.INSTANCE, block2);
    }

    public static /* synthetic */ void gzip$default(CompressionConfig compressionConfig, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = gzip.1.INSTANCE;
        }
        ConfigKt.gzip(compressionConfig, function1);
    }

    public static final void deflate(@NotNull CompressionConfig $this$deflate, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter($this$deflate, "<this>");
        Intrinsics.checkNotNullParameter(block2, "block");
        $this$deflate.encoder("deflate", DeflateEncoder.INSTANCE, (Function1<? super CompressionEncoderBuilder, Unit>)new Function1<CompressionEncoderBuilder, Unit>(block2){
            final /* synthetic */ Function1<CompressionEncoderBuilder, Unit> $block;
            {
                this.$block = $block;
                super(1);
            }

            public final void invoke(@NotNull CompressionEncoderBuilder $this$encoder) {
                Intrinsics.checkNotNullParameter($this$encoder, "$this$encoder");
                $this$encoder.setPriority(0.9);
                this.$block.invoke($this$encoder);
            }
        });
    }

    public static /* synthetic */ void deflate$default(CompressionConfig compressionConfig, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = deflate.1.INSTANCE;
        }
        ConfigKt.deflate(compressionConfig, function1);
    }

    public static final void identity(@NotNull CompressionConfig $this$identity, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter($this$identity, "<this>");
        Intrinsics.checkNotNullParameter(block2, "block");
        $this$identity.encoder("identity", IdentityEncoder.INSTANCE, block2);
    }

    public static /* synthetic */ void identity$default(CompressionConfig compressionConfig, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = identity.1.INSTANCE;
        }
        ConfigKt.identity(compressionConfig, function1);
    }

    public static final void condition(@NotNull ConditionsHolderBuilder $this$condition, @NotNull Function2<? super ApplicationCall, ? super OutgoingContent, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$condition, "<this>");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        $this$condition.getConditions().add(predicate);
    }

    public static final void minimumSize(@NotNull ConditionsHolderBuilder $this$minimumSize, long minSize) {
        Intrinsics.checkNotNullParameter($this$minimumSize, "<this>");
        ConfigKt.condition($this$minimumSize, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)new Function2<ApplicationCall, OutgoingContent, Boolean>(minSize){
            final /* synthetic */ long $minSize;
            {
                this.$minSize = $minSize;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content2) {
                boolean bl;
                Intrinsics.checkNotNullParameter($this$condition, "$this$condition");
                Intrinsics.checkNotNullParameter(content2, "content");
                Long l = content2.getContentLength();
                if (l != null) {
                    Long l2 = l;
                    long l3 = this.$minSize;
                    long it = ((Number)l2).longValue();
                    boolean bl2 = false;
                    bl = it >= l3;
                } else {
                    bl = true;
                }
                return bl;
            }
        });
    }

    public static final void matchContentType(@NotNull ConditionsHolderBuilder $this$matchContentType, ContentType ... mimeTypes) {
        Intrinsics.checkNotNullParameter($this$matchContentType, "<this>");
        Intrinsics.checkNotNullParameter(mimeTypes, "mimeTypes");
        ConfigKt.condition($this$matchContentType, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)new Function2<ApplicationCall, OutgoingContent, Boolean>(mimeTypes){
            final /* synthetic */ ContentType[] $mimeTypes;
            {
                this.$mimeTypes = $mimeTypes;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content2) {
                boolean bl;
                block2: {
                    Intrinsics.checkNotNullParameter($this$condition, "$this$condition");
                    Intrinsics.checkNotNullParameter(content2, "content");
                    ContentType contentType2 = content2.getContentType();
                    if (contentType2 == null) {
                        return false;
                    }
                    ContentType contentType3 = contentType2;
                    ContentType[] $this$any$iv = this.$mimeTypes;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ContentType element$iv;
                        ContentType it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!contentType3.match(it)) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return bl;
            }
        });
    }

    public static final void excludeContentType(@NotNull ConditionsHolderBuilder $this$excludeContentType, ContentType ... mimeTypes) {
        Intrinsics.checkNotNullParameter($this$excludeContentType, "<this>");
        Intrinsics.checkNotNullParameter(mimeTypes, "mimeTypes");
        ConfigKt.condition($this$excludeContentType, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)new Function2<ApplicationCall, OutgoingContent, Boolean>(mimeTypes){
            final /* synthetic */ ContentType[] $mimeTypes;
            {
                this.$mimeTypes = $mimeTypes;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull ApplicationCall $this$condition, @NotNull OutgoingContent content2) {
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter($this$condition, "$this$condition");
                    Intrinsics.checkNotNullParameter(content2, "content");
                    ContentType contentType2 = content2.getContentType();
                    if (contentType2 == null) {
                        ContentType contentType3;
                        String string = $this$condition.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getContentType());
                        if (string != null) {
                            String it = string;
                            boolean bl2 = false;
                            contentType3 = ContentType.Companion.parse(it);
                        } else {
                            contentType3 = contentType2 = null;
                        }
                        if (contentType3 == null) {
                            return true;
                        }
                    }
                    ContentType contentType4 = contentType2;
                    ContentType[] $this$none$iv = this.$mimeTypes;
                    boolean $i$f$none = false;
                    int n = $this$none$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ContentType element$iv;
                        ContentType excludePattern = element$iv = $this$none$iv[i];
                        boolean bl3 = false;
                        if (!contentType4.match(excludePattern)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                return bl;
            }
        });
    }

    private static final void defaultConditions(ConditionsHolderBuilder $this$defaultConditions) {
        ContentType[] contentTypeArray = new ContentType[]{ContentType.Video.INSTANCE.getAny(), ContentType.Image.INSTANCE.getJPEG(), ContentType.Image.INSTANCE.getPNG(), ContentType.Audio.INSTANCE.getAny(), ContentType.MultiPart.INSTANCE.getAny(), ContentType.Text.INSTANCE.getEventStream()};
        ConfigKt.excludeContentType($this$defaultConditions, contentTypeArray);
        ConfigKt.minimumSize($this$defaultConditions, 200L);
    }

    public static final /* synthetic */ void access$defaultConditions(ConditionsHolderBuilder $receiver) {
        ConfigKt.defaultConditions($receiver);
    }
}

