/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.engine;

import gg.skytils.ktor.server.application.Application;
import gg.skytils.ktor.server.application.DefaultApplicationEventsKt;
import gg.skytils.ktor.server.engine.ApplicationEngine;
import gg.skytils.ktor.server.engine.ApplicationEngineEnvironment;
import gg.skytils.ktor.server.engine.BaseApplicationEngineKt;
import gg.skytils.ktor.server.engine.BaseApplicationResponse;
import gg.skytils.ktor.server.engine.DefaultEnginePipelineKt;
import gg.skytils.ktor.server.engine.DefaultTransformKt;
import gg.skytils.ktor.server.engine.EngineConnectorConfig;
import gg.skytils.ktor.server.engine.EnginePipeline;
import gg.skytils.ktor.server.engine.StartupInfo;
import gg.skytils.ktor.server.engine.internal.EngineUtilsJvmKt;
import gg.skytils.ktor.util.date.DateJvmKt;
import gg.skytils.ktx-coroutines.BuildersKt;
import gg.skytils.ktx-coroutines.CompletableDeferred;
import gg.skytils.ktx-coroutines.CompletableDeferredKt;
import gg.skytils.ktx-coroutines.CoroutineScope;
import gg.skytils.ktx-coroutines.CoroutineScopeKt;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0001\u0016B\u0019\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00108\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lgg/skytils/ktor/server/engine/BaseApplicationEngine;", "Lgg/skytils/ktor/server/engine/ApplicationEngine;", "", "Lgg/skytils/ktor/server/engine/EngineConnectorConfig;", "resolvedConnectors", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lgg/skytils/ktor/server/engine/ApplicationEngineEnvironment;", "environment", "Lgg/skytils/ktor/server/engine/ApplicationEngineEnvironment;", "getEnvironment", "()Lio/ktor/server/engine/ApplicationEngineEnvironment;", "Lgg/skytils/ktor/server/engine/EnginePipeline;", "pipeline", "Lgg/skytils/ktor/server/engine/EnginePipeline;", "getPipeline", "()Lio/ktor/server/engine/EnginePipeline;", "Lgg/skytils/ktx-coroutines/CompletableDeferred;", "Lgg/skytils/ktx-coroutines/CompletableDeferred;", "getResolvedConnectors", "()Lkotlinx/coroutines/CompletableDeferred;", "<init>", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lio/ktor/server/engine/EnginePipeline;)V", "Configuration", "ktor-server-host-common"})
public abstract class BaseApplicationEngine
implements ApplicationEngine {
    @NotNull
    private final ApplicationEngineEnvironment environment;
    @NotNull
    private final EnginePipeline pipeline;
    @NotNull
    private final CompletableDeferred<List<EngineConnectorConfig>> resolvedConnectors;

    public BaseApplicationEngine(@NotNull ApplicationEngineEnvironment environment2, @NotNull EnginePipeline pipeline) {
        Intrinsics.checkNotNullParameter(environment2, "environment");
        Intrinsics.checkNotNullParameter(pipeline, "pipeline");
        this.environment = environment2;
        this.pipeline = pipeline;
        this.resolvedConnectors = CompletableDeferredKt.CompletableDeferred$default(null, 1, null);
        final ApplicationEngineEnvironment environment3 = this.environment;
        final StartupInfo info = new StartupInfo();
        final EnginePipeline pipeline2 = this.pipeline;
        BaseApplicationResponse.Companion.setupSendPipeline(pipeline2.getSendPipeline());
        environment3.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarting(), (Function1)new Function1<Application, Unit>(){

            @Override
            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (!info.isFirstLoading()) {
                    info.setInitializedStartAt(DateJvmKt.getTimeMillis());
                }
                it.getReceivePipeline().merge(pipeline2.getReceivePipeline());
                it.getSendPipeline().merge(pipeline2.getSendPipeline());
                DefaultTransformKt.installDefaultTransformations(it.getReceivePipeline());
                DefaultTransformKt.installDefaultTransformations(it.getSendPipeline());
                BaseApplicationEngineKt.access$installDefaultInterceptors(it);
                BaseApplicationEngineKt.access$installDefaultTransformationChecker(it);
            }
        });
        environment3.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarted(), (Function1)new Function1<Application, Unit>(){

            @Override
            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter(it, "it");
                long finishedAt = DateJvmKt.getTimeMillis();
                double elapsedTimeInSeconds = (double)(finishedAt - info.getInitializedStartAt()) / 1000.0;
                if (info.isFirstLoading()) {
                    environment3.getLog().info("Application started in " + elapsedTimeInSeconds + " seconds.");
                    info.setFirstLoading(false);
                } else {
                    environment3.getLog().info("Application auto-reloaded in " + elapsedTimeInSeconds + " seconds.");
                }
            }
        });
        CompletableDeferred<List<EngineConnectorConfig>> connectors = this.resolvedConnectors;
        Logger log = environment3.getLog();
        BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(environment3.getApplication().getCoroutineContext()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connectors, log, null){
            int label;
            final /* synthetic */ CompletableDeferred<List<EngineConnectorConfig>> $connectors;
            final /* synthetic */ Logger $log;
            {
                this.$connectors = $connectors;
                this.$log = $log;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Override
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = this.$connectors.await(this);
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (Iterable)v0;
                        var3_4 = this.$log;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (EngineConnectorConfig)element$iv;
                            $i$a$-forEach-BaseApplicationEngine$3$1 = false;
                            host = EngineUtilsJvmKt.escapeHostname(it.getHost());
                            v1 = new StringBuilder().append("Responding at ");
                            v2 = it.getType().getName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(v2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                            var3_4.info(v1.append(v2).append("://").append(host).append(':').append(it.getPort()).toString());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Override
            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public /* synthetic */ BaseApplicationEngine(ApplicationEngineEnvironment applicationEngineEnvironment, EnginePipeline enginePipeline, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            enginePipeline = DefaultEnginePipelineKt.defaultEnginePipeline(applicationEngineEnvironment);
        }
        this(applicationEngineEnvironment, enginePipeline);
    }

    @Override
    @NotNull
    public final ApplicationEngineEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final EnginePipeline getPipeline() {
        return this.pipeline;
    }

    @NotNull
    protected final CompletableDeferred<List<EngineConnectorConfig>> getResolvedConnectors() {
        return this.resolvedConnectors;
    }

    @Override
    @Nullable
    public Object resolvedConnectors(@NotNull Continuation<? super List<? extends EngineConnectorConfig>> $completion) {
        return this.resolvedConnectors.await($completion);
    }

    @Override
    @NotNull
    public Application getApplication() {
        return ApplicationEngine.DefaultImpls.getApplication(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgg/skytils/ktor/server/engine/BaseApplicationEngine$Configuration;", "Lgg/skytils/ktor/server/engine/ApplicationEngine$Configuration;", "<init>", "()V", "ktor-server-host-common"})
    public static class Configuration
    extends ApplicationEngine.Configuration {
    }
}

