/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.asmhelper.dsl.code;

import gg.skytils.asmhelper.dsl.code.modifiers.Modifier;
import gg.skytils.asmhelper.printing.PrettyprintingKt;
import gg.skytils.asmhelper.printing.PrintingKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0003\u001a\u00020\u0002H\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lgg/skytils/asmhelper/dsl/code/CodeBuilder;", "", "Lorg/objectweb/asm/tree/MethodNode;", "getMethodNode", "()Lorg/objectweb/asm/tree/MethodNode;", "Lorg/objectweb/asm/tree/InsnList;", "transformToInstructions", "()Lorg/objectweb/asm/tree/InsnList;", "Lorg/objectweb/asm/tree/ClassNode;", "codeClassNode", "Lorg/objectweb/asm/tree/ClassNode;", "getCodeClassNode", "()Lorg/objectweb/asm/tree/ClassNode;", "", "Lgg/skytils/asmhelper/dsl/code/modifiers/Modifier;", "getModifiers", "()Ljava/util/List;", "modifiers", "<init>", "(Lorg/objectweb/asm/tree/ClassNode;)V", "AsmHelper1.8.9"})
public abstract class CodeBuilder {
    @NotNull
    private final ClassNode codeClassNode;

    public CodeBuilder(@NotNull ClassNode codeClassNode) {
        Intrinsics.checkNotNullParameter(codeClassNode, "codeClassNode");
        this.codeClassNode = codeClassNode;
    }

    @NotNull
    public final ClassNode getCodeClassNode() {
        return this.codeClassNode;
    }

    @NotNull
    public abstract List<Modifier> getModifiers();

    @NotNull
    protected final MethodNode getMethodNode() {
        Object v0;
        block1: {
            Iterable iterable = this.codeClassNode.methods;
            Intrinsics.checkNotNullExpressionValue(iterable, "codeClassNode.methods");
            iterable = iterable;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object e : iterable2) {
                MethodNode it = (MethodNode)e;
                boolean bl3 = false;
                if (!(Intrinsics.areEqual(it.name, "invoke") && Intrinsics.areEqual(it.desc, "()V"))) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    @NotNull
    public final InsnList transformToInstructions() {
        InsnList instructions = this.getMethodNode().instructions;
        PrintingKt.verbose(Intrinsics.stringPlus("Transforming code class ", this.codeClassNode.name));
        PrintingKt.verbose("Initial instruction list:");
        Intrinsics.checkNotNullExpressionValue(instructions, "instructions");
        PrintingKt.verbose(Intrinsics.stringPlus("\n", PrettyprintingKt.prettyString(instructions)));
        PrintingKt.verbose("-----------------");
        Iterable $this$forEach$iv = this.getModifiers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Modifier it = (Modifier)element$iv;
            boolean bl = false;
            PrintingKt.verbose(Intrinsics.stringPlus("Running cycle ", it));
            PrintingKt.verbose("-----------------");
            it.modify(instructions);
            PrintingKt.verbose("-----------------");
            PrintingKt.verbose(Intrinsics.stringPlus("After cycle ", it));
            PrintingKt.verbose(Intrinsics.stringPlus("\n", PrettyprintingKt.prettyString(instructions)));
        }
        return instructions;
    }
}

