/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.builders.ListBuilderKt;
import kotlin.collections.builders.SerializedCollection;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010+\n\u0002\b\u0015\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0000\u0018\u0000 i*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\u00060\u0003j\u0002`\u00042\b\u0012\u0004\u0012\u00028\u00000\u00052\u00060\u0006j\u0002`\u0007:\u0002ijB\t\b\u0016\u00a2\u0006\u0004\bf\u0010\u001eB\u0011\b\u0016\u0012\u0006\u0010g\u001a\u00020\f\u00a2\u0006\u0004\bf\u0010&BO\b\u0002\u0012\f\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u00000N\u0012\u0006\u0010b\u001a\u00020\f\u0012\u0006\u0010`\u001a\u00020\f\u0012\u0006\u0010^\u001a\u00020\t\u0012\u000e\u0010[\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000\u0012\u000e\u0010c\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000\u00a2\u0006\u0004\bf\u0010hJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\n\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000fJ%\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0012\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0014J-\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0016\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u000fJ\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u000f\u0010 \u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b \u0010\u001eJ\u001b\u0010\"\u001a\u00020\t2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b'\u0010&J\u001a\u0010)\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010(H\u0096\u0002\u00a2\u0006\u0004\b)\u0010\u000bJ\u0018\u0010*\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010.\u001a\u00020\f2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b.\u0010/J\u001f\u00100\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b2\u00103J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00028\u000004H\u0096\u0002\u00a2\u0006\u0004\b5\u00106J\u0017\u00107\u001a\u00020\f2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b7\u0010/J\u0015\u00109\u001a\b\u0012\u0004\u0012\u00028\u000008H\u0016\u00a2\u0006\u0004\b9\u0010:J\u001d\u00109\u001a\b\u0012\u0004\u0012\u00028\u0000082\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b9\u0010;J\u000f\u0010<\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b<\u0010\u001eJ\u0017\u0010=\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b=\u0010\u000bJ\u001d\u0010>\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016\u00a2\u0006\u0004\b>\u0010\u0014J\u0017\u0010?\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b?\u0010+J\u0017\u0010@\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b@\u0010+J\u001f\u0010C\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bC\u00101J\u001d\u0010D\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016\u00a2\u0006\u0004\bD\u0010\u0014J5\u0010F\u001a\u00020\f2\u0006\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010E\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bF\u0010GJ \u0010H\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\bH\u0010IJ%\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010J\u001a\u00020\f2\u0006\u0010K\u001a\u00020\fH\u0016\u00a2\u0006\u0004\bL\u0010MJ\u0017\u0010O\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0NH\u0016\u00a2\u0006\u0004\bO\u0010PJ)\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00010N\"\u0004\b\u0001\u0010Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00028\u00010NH\u0016\u00a2\u0006\u0004\bO\u0010SJ\u000f\u0010U\u001a\u00020TH\u0016\u00a2\u0006\u0004\bU\u0010VJ\u000f\u0010W\u001a\u00020(H\u0002\u00a2\u0006\u0004\bW\u0010XR\u001c\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u00000N8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bY\u0010ZR\u001c\u0010[\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b[\u0010\\R\u0014\u0010]\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u00103R\u0016\u0010^\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010_R\u0016\u0010`\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u0016\u0010b\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bb\u0010aR\u001c\u0010c\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bc\u0010\\R\u0014\u0010e\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010-\u00a8\u0006k"}, d2={"Lkotlin/collections/builders/ListBuilder;", "E", "", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "Lkotlin/collections/AbstractMutableList;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "element", "", "add", "(Ljava/lang/Object;)Z", "", "index", "", "(ILjava/lang/Object;)V", "", "elements", "addAll", "(ILjava/util/Collection;)Z", "(Ljava/util/Collection;)Z", "i", "n", "addAllInternal", "(ILjava/util/Collection;I)V", "addAtInternal", "", "build", "()Ljava/util/List;", "checkForComodification", "()V", "checkIsMutable", "clear", "other", "contentEquals", "(Ljava/util/List;)Z", "minCapacity", "ensureCapacityInternal", "(I)V", "ensureExtraCapacity", "", "equals", "get", "(I)Ljava/lang/Object;", "hashCode", "()I", "indexOf", "(Ljava/lang/Object;)I", "insertAtInternal", "(II)V", "isEmpty", "()Z", "", "iterator", "()Ljava/util/Iterator;", "lastIndexOf", "", "listIterator", "()Ljava/util/ListIterator;", "(I)Ljava/util/ListIterator;", "registerModification", "remove", "removeAll", "removeAt", "removeAtInternal", "rangeOffset", "rangeLength", "removeRangeInternal", "retainAll", "retain", "retainOrRemoveAllInternal", "(IILjava/util/Collection;Z)I", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "fromIndex", "toIndex", "subList", "(II)Ljava/util/List;", "", "toArray", "()[Ljava/lang/Object;", "T", "destination", "([Ljava/lang/Object;)[Ljava/lang/Object;", "", "toString", "()Ljava/lang/String;", "writeReplace", "()Ljava/lang/Object;", "array", "[Ljava/lang/Object;", "backing", "Lkotlin/collections/builders/ListBuilder;", "isEffectivelyReadOnly", "isReadOnly", "Z", "length", "I", "offset", "root", "getSize", "size", "<init>", "initialCapacity", "([Ljava/lang/Object;IIZLkotlin/collections/builders/ListBuilder;Lkotlin/collections/builders/ListBuilder;)V", "Companion", "Itr", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nListBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListBuilder.kt\nkotlin/collections/builders/ListBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,487:1\n1#2:488\n*E\n"})
public final class ListBuilder<E>
extends AbstractMutableList<E>
implements List<E>,
RandomAccess,
Serializable,
KMutableList {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private E[] array;
    private int offset;
    private int length;
    private boolean isReadOnly;
    @Nullable
    private final ListBuilder<E> backing;
    @Nullable
    private final ListBuilder<E> root;
    @NotNull
    private static final ListBuilder Empty;

    private ListBuilder(E[] array, int offset, int length, boolean isReadOnly, ListBuilder<E> backing, ListBuilder<E> root) {
        this.array = array;
        this.offset = offset;
        this.length = length;
        this.isReadOnly = isReadOnly;
        this.backing = backing;
        this.root = root;
        if (this.backing != null) {
            this.modCount = this.backing.modCount;
        }
    }

    public ListBuilder() {
        this(10);
    }

    public ListBuilder(int initialCapacity) {
        this(ListBuilderKt.arrayOfUninitializedElements(initialCapacity), 0, 0, false, null, null);
    }

    @NotNull
    public final List<E> build() {
        if (this.backing != null) {
            throw new IllegalStateException();
        }
        this.checkIsMutable();
        this.isReadOnly = true;
        return this.length > 0 ? (List)this : (List)Empty;
    }

    private final Object writeReplace() {
        if (!this.isEffectivelyReadOnly()) {
            throw new NotSerializableException("The list cannot be serialized while it is being built.");
        }
        return new SerializedCollection(this, 0);
    }

    @Override
    public int getSize() {
        this.checkForComodification();
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        this.checkForComodification();
        return this.length == 0;
    }

    @Override
    public E get(int index) {
        this.checkForComodification();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        return this.array[this.offset + index];
    }

    @Override
    public E set(int index, E element) {
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        E old = this.array[this.offset + index];
        this.array[this.offset + index] = element;
        return old;
    }

    @Override
    public int indexOf(Object element) {
        this.checkForComodification();
        for (int i = 0; i < this.length; ++i) {
            if (!Intrinsics.areEqual(this.array[this.offset + i], element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        this.checkForComodification();
        for (int i = this.length - 1; i >= 0; --i) {
            if (!Intrinsics.areEqual(this.array[this.offset + i], element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        this.checkForComodification();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        return new Itr(this, index);
    }

    @Override
    public boolean add(E element) {
        this.checkIsMutable();
        this.checkForComodification();
        this.addAtInternal(this.offset + this.length, element);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        this.addAtInternal(this.offset + index, element);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        this.checkForComodification();
        int n = elements.size();
        this.addAllInternal(this.offset + this.length, elements, n);
        return n > 0;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        int n = elements.size();
        this.addAllInternal(this.offset + index, elements, n);
        return n > 0;
    }

    @Override
    public void clear() {
        this.checkIsMutable();
        this.checkForComodification();
        this.removeRangeInternal(this.offset, this.length);
    }

    @Override
    public E removeAt(int index) {
        this.checkIsMutable();
        this.checkForComodification();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        return this.removeAtInternal(this.offset + index);
    }

    @Override
    public boolean remove(Object element) {
        this.checkIsMutable();
        this.checkForComodification();
        int i = this.indexOf(element);
        if (i >= 0) {
            this.remove(i);
        }
        return i >= 0;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        this.checkForComodification();
        return this.retainOrRemoveAllInternal(this.offset, this.length, elements, false) > 0;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        this.checkForComodification();
        return this.retainOrRemoveAllInternal(this.offset, this.length, elements, true) > 0;
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(fromIndex, toIndex, this.length);
        ListBuilder listBuilder = this.root;
        if (listBuilder == null) {
            listBuilder = this;
        }
        return new ListBuilder<E>(this.array, this.offset + fromIndex, toIndex - fromIndex, this.isReadOnly, this, listBuilder);
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        this.checkForComodification();
        if (destination.length < this.length) {
            T[] TArray = Arrays.copyOfRange(this.array, this.offset, this.offset + this.length, destination.getClass());
            Intrinsics.checkNotNullExpressionValue(TArray, "copyOfRange(...)");
            return TArray;
        }
        ArraysKt.copyInto(this.array, destination, 0, this.offset, this.offset + this.length);
        return CollectionsKt.terminateCollectionToArray(this.length, destination);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        this.checkForComodification();
        E[] EArray = this.array;
        int n = this.offset;
        int n2 = this.offset + this.length;
        return ArraysKt.copyOfRange(EArray, n, n2);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        this.checkForComodification();
        return other == this || other instanceof List && this.contentEquals((List)other);
    }

    @Override
    public int hashCode() {
        this.checkForComodification();
        return ListBuilderKt.access$subarrayContentHashCode(this.array, this.offset, this.length);
    }

    @Override
    @NotNull
    public String toString() {
        this.checkForComodification();
        return ListBuilderKt.access$subarrayContentToString(this.array, this.offset, this.length, this);
    }

    private final void registerModification() {
        ++this.modCount;
    }

    private final void checkForComodification() {
        if (this.root != null && this.root.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private final void checkIsMutable() {
        if (this.isEffectivelyReadOnly()) {
            throw new UnsupportedOperationException();
        }
    }

    private final boolean isEffectivelyReadOnly() {
        return this.isReadOnly || this.root != null && this.root.isReadOnly;
    }

    private final void ensureExtraCapacity(int n) {
        this.ensureCapacityInternal(this.length + n);
    }

    private final void ensureCapacityInternal(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        if (minCapacity > this.array.length) {
            int newSize = AbstractList.Companion.newCapacity$kotlin_stdlib(this.array.length, minCapacity);
            this.array = ListBuilderKt.copyOfUninitializedElements(this.array, newSize);
        }
    }

    private final boolean contentEquals(List<?> other) {
        return ListBuilderKt.access$subarrayContentEquals(this.array, this.offset, this.length, other);
    }

    private final void insertAtInternal(int i, int n) {
        this.ensureExtraCapacity(n);
        E[] EArray = this.array;
        E[] EArray2 = this.array;
        int n2 = this.offset + this.length;
        int n3 = i + n;
        ArraysKt.copyInto(EArray, EArray2, n3, i, n2);
        this.length += n;
    }

    private final void addAtInternal(int i, E element) {
        this.registerModification();
        if (this.backing != null) {
            super.addAtInternal(i, element);
            this.array = this.backing.array;
            int n = this.length;
            this.length = n + 1;
        } else {
            this.insertAtInternal(i, 1);
            this.array[i] = element;
        }
    }

    private final void addAllInternal(int i, Collection<? extends E> elements, int n) {
        this.registerModification();
        if (this.backing != null) {
            super.addAllInternal(i, elements, n);
            this.array = this.backing.array;
            this.length += n;
        } else {
            this.insertAtInternal(i, n);
            Iterator<E> it = elements.iterator();
            for (int j = 0; j < n; ++j) {
                this.array[i + j] = it.next();
            }
        }
    }

    private final E removeAtInternal(int i) {
        this.registerModification();
        if (this.backing != null) {
            E old = super.removeAtInternal(i);
            int n = this.length;
            this.length = n + -1;
            return old;
        }
        E old = this.array[i];
        E[] EArray = this.array;
        E[] EArray2 = this.array;
        int n = i + 1;
        int n2 = this.offset + this.length;
        ArraysKt.copyInto(EArray, EArray2, i, n, n2);
        ListBuilderKt.resetAt(this.array, this.offset + this.length - 1);
        int n3 = this.length;
        this.length = n3 + -1;
        return old;
    }

    private final void removeRangeInternal(int rangeOffset, int rangeLength) {
        if (rangeLength > 0) {
            this.registerModification();
        }
        if (this.backing != null) {
            super.removeRangeInternal(rangeOffset, rangeLength);
        } else {
            E[] EArray = this.array;
            E[] EArray2 = this.array;
            int n = rangeOffset + rangeLength;
            int n2 = this.length;
            ArraysKt.copyInto(EArray, EArray2, rangeOffset, n, n2);
            ListBuilderKt.resetRange(this.array, this.length - rangeLength, this.length);
        }
        this.length -= rangeLength;
    }

    private final int retainOrRemoveAllInternal(int rangeOffset, int rangeLength, Collection<? extends E> elements, boolean retain) {
        int removed;
        int n;
        if (this.backing != null) {
            n = super.retainOrRemoveAllInternal(rangeOffset, rangeLength, elements, retain);
        } else {
            int i = 0;
            int j = 0;
            while (i < rangeLength) {
                if (elements.contains(this.array[rangeOffset + i]) == retain) {
                    this.array[rangeOffset + j++] = this.array[rangeOffset + i++];
                    continue;
                }
                ++i;
            }
            int removed2 = rangeLength - j;
            E[] EArray = this.array;
            E[] EArray2 = this.array;
            int n2 = rangeOffset + rangeLength;
            int n3 = this.length;
            int n4 = rangeOffset + j;
            ArraysKt.copyInto(EArray, EArray2, n4, n2, n3);
            ListBuilderKt.resetRange(this.array, this.length - removed2, this.length);
            n = removed = removed2;
        }
        if (removed > 0) {
            this.registerModification();
        }
        this.length -= removed;
        return removed;
    }

    static {
        ListBuilder listBuilder;
        Companion = new Companion(null);
        ListBuilder it = listBuilder = new ListBuilder(0);
        boolean bl = false;
        it.isReadOnly = true;
        Empty = listBuilder;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Lkotlin/collections/builders/ListBuilder$Companion;", "", "Lkotlin/collections/builders/ListBuilder;", "", "Empty", "Lkotlin/collections/builders/ListBuilder;", "<init>", "()V", "kotlin-stdlib"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u001f\b\u0016\u0012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u001a\u0012\u0006\u0010\u0018\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0010\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u000f\u0010\u0013\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\bJ\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0006R\u0016\u0010\u0016\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lkotlin/collections/builders/ListBuilder$Itr;", "E", "", "element", "", "add", "(Ljava/lang/Object;)V", "checkForComodification", "()V", "", "hasNext", "()Z", "hasPrevious", "next", "()Ljava/lang/Object;", "", "nextIndex", "()I", "previous", "previousIndex", "remove", "set", "expectedModCount", "I", "index", "lastIndex", "Lkotlin/collections/builders/ListBuilder;", "list", "Lkotlin/collections/builders/ListBuilder;", "<init>", "(Lkotlin/collections/builders/ListBuilder;I)V", "kotlin-stdlib"})
    @SourceDebugExtension(value={"SMAP\nListBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListBuilder.kt\nkotlin/collections/builders/ListBuilder$Itr\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,487:1\n1#2:488\n*E\n"})
    private static final class Itr<E>
    implements ListIterator<E>,
    KMutableListIterator {
        @NotNull
        private final ListBuilder<E> list;
        private int index;
        private int lastIndex;
        private int expectedModCount;

        public Itr(@NotNull ListBuilder<E> list, int index) {
            Intrinsics.checkNotNullParameter(list, "list");
            this.list = list;
            this.index = index;
            this.lastIndex = -1;
            this.expectedModCount = ((ListBuilder)list).modCount;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < ((ListBuilder)this.list).length;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            this.index += -1;
            this.lastIndex = this.index;
            return (E)((ListBuilder)this.list).array[((ListBuilder)this.list).offset + this.lastIndex];
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (this.index >= ((ListBuilder)this.list).length) {
                throw new NoSuchElementException();
            }
            int n = this.index;
            this.index = n + 1;
            this.lastIndex = n;
            return (E)((ListBuilder)this.list).array[((ListBuilder)this.list).offset + this.lastIndex];
        }

        @Override
        public void set(E element) {
            boolean bl;
            this.checkForComodification();
            boolean bl2 = bl = this.lastIndex != -1;
            if (!bl) {
                boolean bl3 = false;
                String string = "Call next() or previous() before replacing element from the iterator.";
                throw new IllegalStateException(string.toString());
            }
            this.list.set(this.lastIndex, element);
        }

        @Override
        public void add(E element) {
            this.checkForComodification();
            int n = this.index;
            this.index = n + 1;
            this.list.add(n, element);
            this.lastIndex = -1;
            this.expectedModCount = ((ListBuilder)this.list).modCount;
        }

        @Override
        public void remove() {
            boolean bl;
            this.checkForComodification();
            boolean bl2 = bl = this.lastIndex != -1;
            if (!bl) {
                boolean bl3 = false;
                String string = "Call next() or previous() before removing element from the iterator.";
                throw new IllegalStateException(string.toString());
            }
            this.list.remove(this.lastIndex);
            this.index = this.lastIndex;
            this.lastIndex = -1;
            this.expectedModCount = ((ListBuilder)this.list).modCount;
        }

        private final void checkForComodification() {
            if (((ListBuilder)this.list).modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

