/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.toml;

import gg.skytils.vigilance.impl.nightconfig.core.io.CharacterInput;
import gg.skytils.vigilance.impl.nightconfig.core.io.CharsWrapper;
import gg.skytils.vigilance.impl.nightconfig.core.io.Utils;
import java.util.List;

final class Toml {
    private static final char[] WHITESPACE_OR_NEWLINE = new char[]{'\t', ' ', '\n', '\r'};
    private static final char[] WHITESPACE = new char[]{'\t', ' '};
    private static final char[] NEWLINE = new char[]{'\n'};
    private static final char[] FORBIDDEN_IN_ALL_BARE_KEYS = new char[]{'.', '[', ']', '#', '='};

    static char readUsefulChar(CharacterInput input2) {
        char next = input2.readCharAndSkip(WHITESPACE_OR_NEWLINE);
        while (next == '#') {
            input2.readCharsUntil(NEWLINE);
            next = input2.readCharAndSkip(WHITESPACE_OR_NEWLINE);
        }
        return next;
    }

    static int readUseful(CharacterInput input2, List<CharsWrapper> commentsList) {
        int next = input2.readAndSkip(WHITESPACE_OR_NEWLINE);
        while (next == 35) {
            CharsWrapper comment = Toml.readLine(input2);
            commentsList.add(comment);
            next = input2.readAndSkip(WHITESPACE_OR_NEWLINE);
        }
        return next;
    }

    static char readNonSpaceChar(CharacterInput input2, boolean skipNewlines) {
        return skipNewlines ? input2.readCharAndSkip(WHITESPACE_OR_NEWLINE) : input2.readCharAndSkip(WHITESPACE);
    }

    static int readNonSpace(CharacterInput input2, boolean skipNewlines) {
        return skipNewlines ? input2.readAndSkip(WHITESPACE_OR_NEWLINE) : input2.readAndSkip(WHITESPACE);
    }

    static CharsWrapper readLine(CharacterInput input2) {
        CharsWrapper chars = input2.readUntil(NEWLINE);
        int lastIndex = chars.length() - 1;
        if (lastIndex >= 0 && chars.get(lastIndex) == '\r') {
            return chars.subView(0, lastIndex);
        }
        return chars;
    }

    static boolean isValidInBareKey(char c, boolean lenient) {
        if (lenient) {
            return c > ' ' && !Utils.arrayContains(FORBIDDEN_IN_ALL_BARE_KEYS, c);
        }
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_';
    }

    static boolean isValidBareKey(CharSequence csq, boolean lenient) {
        for (int i = 0; i < csq.length(); ++i) {
            if (Toml.isValidInBareKey(csq.charAt(i), lenient)) continue;
            return false;
        }
        return true;
    }

    static boolean isKeyValueSeparator(char c, boolean lenient) {
        return c == '=' || lenient && c == ':';
    }

    private Toml() {
    }
}

