/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.toml;

import gg.skytils.vigilance.impl.nightconfig.core.io.CharacterOutput;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;

final class TemporalWriter {
    static void write(Temporal temporal, CharacterOutput output2) {
        if (temporal.isSupported(ChronoField.YEAR)) {
            TemporalWriter.writeDate(temporal, output2);
            if (temporal.isSupported(ChronoField.HOUR_OF_DAY)) {
                output2.write('T');
                TemporalWriter.writeHour(temporal, output2);
                if (temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
                    int offsetSeconds = temporal.get(ChronoField.OFFSET_SECONDS);
                    ZoneOffset offset = ZoneOffset.ofTotalSeconds(offsetSeconds);
                    output2.write(offset.getId());
                }
            }
        } else if (temporal.isSupported(ChronoField.HOUR_OF_DAY)) {
            TemporalWriter.writeHour(temporal, output2);
        }
    }

    private static void writeDate(Temporal temporal, CharacterOutput output2) {
        int year2 = temporal.get(ChronoField.YEAR);
        int month = temporal.get(ChronoField.MONTH_OF_YEAR);
        int day2 = temporal.get(ChronoField.DAY_OF_MONTH);
        TemporalWriter.writePadded(year2, 4, output2);
        output2.write('-');
        TemporalWriter.writePadded(month, 2, output2);
        output2.write('-');
        TemporalWriter.writePadded(day2, 2, output2);
    }

    private static void writeHour(Temporal temporal, CharacterOutput output2) {
        int millis;
        int hours = temporal.get(ChronoField.HOUR_OF_DAY);
        int minutes = temporal.get(ChronoField.MINUTE_OF_HOUR);
        int seconds = temporal.get(ChronoField.SECOND_OF_MINUTE);
        TemporalWriter.writePadded(hours, 2, output2);
        output2.write(':');
        TemporalWriter.writePadded(minutes, 2, output2);
        output2.write(':');
        TemporalWriter.writePadded(seconds, 2, output2);
        if (temporal.isSupported(ChronoField.NANO_OF_SECOND)) {
            int nanos = temporal.get(ChronoField.NANO_OF_SECOND);
            if (nanos != 0) {
                output2.write('.');
                TemporalWriter.writePaddedAndTrimmed(nanos, 9, output2);
            }
        } else if (temporal.isSupported(ChronoField.MILLI_OF_SECOND) && (millis = temporal.get(ChronoField.MILLI_OF_SECOND)) != 0) {
            output2.write('.');
            TemporalWriter.writePaddedAndTrimmed(millis, 6, output2);
        }
    }

    private static void writePadded(int value, int numberOfDigits, CharacterOutput output2) {
        String str2 = Integer.toString(value);
        for (int i = str2.length(); i < numberOfDigits; ++i) {
            output2.write('0');
        }
        output2.write(str2);
    }

    private static void writePaddedAndTrimmed(int value, int numberOfDigits, CharacterOutput output2) {
        int length;
        int i;
        String str2 = Integer.toString(value);
        for (i = length = str2.length(); i < numberOfDigits; ++i) {
            output2.write('0');
        }
        for (i = length - 1; i >= 1; --i) {
            if (str2.charAt(i) != '0') continue;
            --length;
        }
        output2.write(str2, 0, length);
    }

    private TemporalWriter() {
    }
}

