/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.core.file;

import gg.skytils.vigilance.impl.nightconfig.core.Config;
import gg.skytils.vigilance.impl.nightconfig.core.ConfigFormat;
import gg.skytils.vigilance.impl.nightconfig.core.file.CheckedFileConfig;
import gg.skytils.vigilance.impl.nightconfig.core.file.FileConfigBuilder;
import gg.skytils.vigilance.impl.nightconfig.core.file.FormatDetector;
import gg.skytils.vigilance.impl.nightconfig.core.file.NoFormatFoundException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public interface FileConfig
extends Config,
AutoCloseable {
    public File getFile();

    public Path getNioPath();

    public void save();

    public void load();

    @Override
    public void close();

    @Override
    default public FileConfig checked() {
        return new CheckedFileConfig(this);
    }

    public static FileConfig of(File file2) {
        return FileConfig.of(file2.toPath());
    }

    public static FileConfig of(File file2, ConfigFormat<? extends Config> format) {
        return FileConfig.of(file2.toPath(), format);
    }

    public static FileConfig of(Path file2) {
        ConfigFormat<?> format = FormatDetector.detect(file2);
        if (format == null) {
            throw new NoFormatFoundException("No suitable format for " + file2.getFileName());
        }
        return FileConfig.of(file2, format);
    }

    public static FileConfig of(Path file2, ConfigFormat<? extends Config> format) {
        return FileConfig.builder(file2, format).build();
    }

    public static FileConfig of(String filePath) {
        return FileConfig.of(Paths.get(filePath, new String[0]));
    }

    public static FileConfig of(String filePath, ConfigFormat<?> format) {
        return FileConfig.of(Paths.get(filePath, new String[0]), format);
    }

    public static FileConfig ofConcurrent(File file2) {
        return FileConfig.ofConcurrent(file2.toPath());
    }

    public static FileConfig ofConcurrent(File file2, ConfigFormat<?> format) {
        return FileConfig.ofConcurrent(file2.toPath(), format);
    }

    public static FileConfig ofConcurrent(Path file2) {
        return FileConfig.builder(file2).concurrent().build();
    }

    public static FileConfig ofConcurrent(Path file2, ConfigFormat<?> format) {
        return FileConfig.builder(file2, format).concurrent().build();
    }

    public static FileConfig ofConcurrent(String filePath) {
        return FileConfig.ofConcurrent(Paths.get(filePath, new String[0]));
    }

    public static FileConfig ofConcurrent(String filePath, ConfigFormat<?> format) {
        return FileConfig.ofConcurrent(Paths.get(filePath, new String[0]), format);
    }

    public static FileConfigBuilder builder(File file2) {
        return FileConfig.builder(file2.toPath());
    }

    public static FileConfigBuilder builder(File file2, ConfigFormat<?> format) {
        return FileConfig.builder(file2.toPath(), format);
    }

    public static FileConfigBuilder builder(Path file2) {
        ConfigFormat<?> format = FormatDetector.detect(file2);
        if (format == null) {
            throw new NoFormatFoundException("No suitable format for " + file2.getFileName());
        }
        return FileConfig.builder(file2, format);
    }

    public static FileConfigBuilder builder(Path file2, ConfigFormat<?> format) {
        return new FileConfigBuilder(file2, (ConfigFormat<? extends Config>)format);
    }

    public static FileConfigBuilder builder(String filePath) {
        return FileConfig.builder(Paths.get(filePath, new String[0]));
    }

    public static FileConfigBuilder builder(String filePath, ConfigFormat<?> format) {
        return FileConfig.builder(Paths.get(filePath, new String[0]), format);
    }
}

