/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.mixins.transformers.entity;

import gg.skytils.mixinextras.injector.v2.WrapWithCondition;
import gg.skytils.skytilsmod.mixins.extensions.ExtensionEntityLivingBase;
import gg.skytils.skytilsmod.mixins.hooks.entity.EntityLivingBaseHook;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityLivingBase.class})
public abstract class MixinEntityLivingBase
extends Entity
implements ExtensionEntityLivingBase {
    @Unique
    private final EntityLivingBaseHook hook = new EntityLivingBaseHook((EntityLivingBase)this);

    public MixinEntityLivingBase(World worldIn) {
        super(worldIn);
    }

    @Inject(method={"isPotionActive(Lnet/minecraft/potion/Potion;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyPotionActive(Potion potion, CallbackInfoReturnable<Boolean> cir) {
        this.hook.modifyPotionActive(potion.field_76415_H, cir);
    }

    @Inject(method={"isPotionActive(I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyPotionActive(int potionId, CallbackInfoReturnable<Boolean> cir) {
        this.hook.modifyPotionActive(potionId, cir);
    }

    @WrapWithCondition(method={"onDeathUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnParticle(Lnet/minecraft/util/EnumParticleTypes;DDDDDD[I)V")})
    private boolean spawnParticle(World world, EnumParticleTypes particleType, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, int[] p_175688_14_) {
        return this.hook.removeDeathParticle(world, particleType, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset, p_175688_14_);
    }

    @Inject(method={"isChild"}, at={@At(value="HEAD")}, cancellable=true)
    private void setChildState(CallbackInfoReturnable<Boolean> cir) {
        this.hook.isChild(cir);
    }

    @Override
    @NotNull
    public EntityLivingBaseHook getSkytilsHook() {
        return this.hook;
    }
}

