/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.features.impl.dungeons.solvers;

import gg.skytils.skytilsmod.Skytils;
import gg.skytils.skytilsmod.core.TickKt;
import gg.skytils.skytilsmod.events.impl.skyblock.DungeonEvent;
import gg.skytils.skytilsmod.utils.RenderUtil;
import gg.skytils.skytilsmod.utils.SuperSecretSettings;
import gg.skytils.skytilsmod.utils.Utils;
import gg.skytils.skytilsmod.utils.tictactoe.AlphaBetaAdvanced;
import gg.skytils.skytilsmod.utils.tictactoe.Board;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b;\u0010%J\u0015\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010\"\u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a2\u0006\u0004\b\"\u0010#J\r\u0010$\u001a\u00020\u0015\u00a2\u0006\u0004\b$\u0010%J\u001c\u0010'\u001a\u00020\b*\u00020\f2\u0006\u0010&\u001a\u00020\bH\u0082\u0002\u00a2\u0006\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b+\u0010*R\u0014\u0010,\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b,\u0010*R\u0018\u0010.\u001a\u0004\u0018\u00010-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0018\u00101\u001a\u0004\u0018\u0001008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R2\u00105\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000303j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003`48\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0018\u00108\u001a\u0004\u0018\u0001078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0018\u0010:\u001a\u0004\u0018\u00010-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010/\u00a8\u0006<"}, d2={"Lgg/skytils/skytilsmod/features/impl/dungeons/solvers/TicTacToeSolver;", "", "", "Lnet/minecraft/entity/item/EntityItemFrame;", "getBoardFrames", "()Ljava/util/List;", "frame", "Lkotlin/Pair;", "", "getBoardPosition", "(Lnet/minecraft/entity/item/EntityItemFrame;)Lkotlin/Pair;", "entity", "Lnet/minecraft/world/storage/MapData;", "kotlin.jvm.PlatformType", "getMapData", "(Lnet/minecraft/entity/item/EntityItemFrame;)Lnet/minecraft/world/storage/MapData;", "Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;", "getSpotOwner", "(Lnet/minecraft/entity/item/EntityItemFrame;)Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;", "Lgg/skytils/skytilsmod/events/impl/skyblock/DungeonEvent$PuzzleEvent$Discovered;", "event", "", "onPuzzleDiscovered", "(Lgg/skytils/skytilsmod/events/impl/skyblock/DungeonEvent$PuzzleEvent$Discovered;)V", "Lgg/skytils/skytilsmod/events/impl/skyblock/DungeonEvent$PuzzleEvent$Reset;", "onPuzzleReset", "(Lgg/skytils/skytilsmod/events/impl/skyblock/DungeonEvent$PuzzleEvent$Reset;)V", "Lnet/minecraftforge/client/event/RenderWorldLastEvent;", "onRenderWorld", "(Lnet/minecraftforge/client/event/RenderWorldLastEvent;)V", "Lnet/minecraftforge/event/world/WorldEvent$Unload;", "onWorldLoad", "(Lnet/minecraftforge/event/world/WorldEvent$Unload;)V", "frames", "parseInitialState", "(Ljava/util/List;)V", "updatePuzzleState", "()V", "index", "get", "(Lnet/minecraft/world/storage/MapData;I)I", "COLOR_INT_O", "I", "COLOR_INT_X", "MAP_COLOR_INDEX", "Lnet/minecraft/util/BlockPos;", "bestMove", "Lnet/minecraft/util/BlockPos;", "Lgg/skytils/skytilsmod/utils/tictactoe/Board;", "board", "Lgg/skytils/skytilsmod/utils/tictactoe/Board;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "mappedPositions", "Ljava/util/HashMap;", "Lnet/minecraft/util/EnumFacing;", "roomFacing", "Lnet/minecraft/util/EnumFacing;", "topLeft", "<init>", "SkytilsMod"})
@SourceDebugExtension(value={"SMAP\nTicTacToeSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TicTacToeSolver.kt\ngg/skytils/skytilsmod/features/impl/dungeons/solvers/TicTacToeSolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n766#2:192\n857#2:193\n858#2:195\n1#3:194\n*S KotlinDebug\n*F\n+ 1 TicTacToeSolver.kt\ngg/skytils/skytilsmod/features/impl/dungeons/solvers/TicTacToeSolver\n*L\n136#1:192\n136#1:193\n136#1:195\n*E\n"})
public final class TicTacToeSolver {
    @NotNull
    public static final TicTacToeSolver INSTANCE = new TicTacToeSolver();
    private static final int MAP_COLOR_INDEX = 8256;
    private static final int COLOR_INT_X = 114;
    private static final int COLOR_INT_O = 33;
    @Nullable
    private static BlockPos topLeft;
    @Nullable
    private static EnumFacing roomFacing;
    @Nullable
    private static Board board;
    @NotNull
    private static HashMap<Integer, EntityItemFrame> mappedPositions;
    @Nullable
    private static BlockPos bestMove;

    private TicTacToeSolver() {
    }

    @SubscribeEvent
    public final void onPuzzleDiscovered(@NotNull DungeonEvent.PuzzleEvent.Discovered event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (Intrinsics.areEqual(event.getPuzzle(), "Tic Tac Toe")) {
            this.updatePuzzleState();
        }
    }

    public final void updatePuzzleState() throws IllegalStateException {
        List<EntityItemFrame> frames2 = this.getBoardFrames();
        if (topLeft == null || roomFacing == null || board == null) {
            this.parseInitialState(frames2);
        } else {
            Board board = TicTacToeSolver.board;
            Intrinsics.checkNotNull(board);
            if (!board.isGameOver()) {
                Board board2 = TicTacToeSolver.board;
                Intrinsics.checkNotNull(board2);
                board2.setTurn(frames2.size() % 2 == 0 ? Board.State.X : Board.State.O);
                Board board3 = TicTacToeSolver.board;
                Intrinsics.checkNotNull(board3);
                if (board3.getTurn() == Board.State.O) {
                    int move;
                    int n;
                    for (EntityItemFrame frame : frames2) {
                        if (mappedPositions.values().contains(frame)) continue;
                        Pair<Integer, Integer> pair = this.getBoardPosition(frame);
                        int row = ((Number)pair.component1()).intValue();
                        int column = ((Number)pair.component2()).intValue();
                        Board board4 = TicTacToeSolver.board;
                        Intrinsics.checkNotNull(board4);
                        board4.place(column, row, this.getSpotOwner(frame));
                        ((Map)mappedPositions).put(row * 3 + column, frame);
                    }
                    Board board5 = TicTacToeSolver.board;
                    Intrinsics.checkNotNull(board5);
                    AlphaBetaAdvanced.run$default(AlphaBetaAdvanced.INSTANCE, board5, 0.0, 2, null);
                    if (!SuperSecretSettings.bennettArthur) {
                        Board board6 = TicTacToeSolver.board;
                        Intrinsics.checkNotNull(board6);
                        n = board6.getAlgorithmBestMove();
                    } else {
                        Board board7 = TicTacToeSolver.board;
                        Intrinsics.checkNotNull(board7);
                        Integer n2 = (Integer)CollectionsKt.randomOrNull((Collection)board7.getAvailableMoves(), Random.Default);
                        n = move = n2 != null ? n2 : -1;
                    }
                    if (move != -1) {
                        int column = move % 3;
                        int row = move / 3;
                        BlockPos blockPos2 = topLeft;
                        Intrinsics.checkNotNull(blockPos2);
                        BlockPos blockPos3 = blockPos2.func_177979_c(row);
                        EnumFacing enumFacing = roomFacing;
                        Intrinsics.checkNotNull(enumFacing);
                        bestMove = blockPos3.func_177967_a(enumFacing.func_176746_e(), column);
                    }
                } else {
                    bestMove = null;
                }
            } else {
                bestMove = null;
            }
        }
    }

    @SubscribeEvent
    public final void onWorldLoad(@NotNull WorldEvent.Unload event) {
        Intrinsics.checkNotNullParameter(event, "event");
        topLeft = null;
        roomFacing = null;
        board = null;
        bestMove = null;
        mappedPositions.clear();
    }

    @SubscribeEvent
    public final void onPuzzleReset(@NotNull DungeonEvent.PuzzleEvent.Reset event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (Intrinsics.areEqual(event.getPuzzle(), "Tic Tac Toe")) {
            board = null;
            bestMove = null;
            mappedPositions.clear();
        }
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull RenderWorldLastEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!Utils.INSTANCE.getInDungeons() || !Skytils.Companion.getConfig().getTicTacToeSolver()) {
            return;
        }
        if (bestMove != null) {
            BlockPos blockPos2 = bestMove;
            Intrinsics.checkNotNull(blockPos2);
            RenderUtil.drawOutlinedBoundingBox(new AxisAlignedBB(bestMove, blockPos2.func_177982_a(1, 1, 1)), Skytils.Companion.getConfig().getTicTacToeSolverColor(), 3.0f, event.partialTicks);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final List<EntityItemFrame> getBoardFrames() {
        v0 = Skytils.Companion.getMc().field_71441_e.field_72996_f;
        Intrinsics.checkNotNullExpressionValue(v0, "loadedEntityList");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block8: {
                block7: {
                    it = (Entity)element$iv$iv;
                    $i$a$-filter-TicTacToeSolver$getBoardFrames$1 = false;
                    if (!(it instanceof EntityItemFrame) || ((EntityItemFrame)it).func_82333_j() != 0) ** GOTO lbl-1000
                    realPos = ((EntityItemFrame)it).func_180425_c().func_177977_b();
                    $i$a$-let-TicTacToeSolver$getBoardFrames$1$1 = false;
                    var12_12 = realPos.func_177956_o();
                    v1 = 70 <= var12_12 ? var12_12 < 73 : false;
                    if (!v1) ** GOTO lbl-1000
                    v2 = var13_14 = ((EntityItemFrame)it).func_82335_i();
                    if (v2 == null) break block7;
                    Intrinsics.checkNotNull(v2);
                    item = var13_14;
                    $i$a$-let-TicTacToeSolver$getBoardFrames$1$2 = false;
                    if (!Intrinsics.areEqual(item.func_77973_b(), Items.field_151098_aY)) ** GOTO lbl-1000
                    v3 = var15_16 = Items.field_151098_aY.func_77873_a(item, (World)Skytils.Companion.getMc().field_71441_e);
                    if (v3 != null) {
                        Intrinsics.checkNotNull(v3);
                        mapData = var15_16;
                        $i$a$-let-TicTacToeSolver$getBoardFrames$1$2$1 = false;
                        colorInt = TicTacToeSolver.INSTANCE.get(mapData, 8256);
                        $i$a$-let-TicTacToeSolver$getBoardFrames$1$2$1$1 = false;
                        v4 = colorInt == 114 || colorInt == 33;
                    } else {
                        v4 = false;
                    }
                    if (v4) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    break block8;
                }
                v5 = false;
            }
            if (v5 && Intrinsics.areEqual(Skytils.Companion.getMc().field_71441_e.func_180495_p(((EntityItemFrame)it).func_180425_c().func_177977_b().func_177967_a(((EntityItemFrame)it).field_174860_b.func_176734_d(), 1)).func_177230_c(), Blocks.field_150339_S)) {
                v6 = true;
            } else lbl-1000:
            // 3 sources

            {
                v6 = false;
            }
            if (!v6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void parseInitialState(List<? extends EntityItemFrame> frames2) {
        for (EntityItemFrame entityItemFrame : frames2) {
            Pair<Integer, Integer> pair = this.getBoardPosition(entityItemFrame);
            int row = ((Number)pair.component1()).intValue();
            int column = ((Number)pair.component2()).intValue();
            if (board == null) {
                topLeft = entityItemFrame.func_180425_c().func_177981_b(row - 1).func_177967_a(entityItemFrame.field_174860_b.func_176746_e(), column);
                roomFacing = entityItemFrame.field_174860_b.func_176734_d();
                board = new Board();
            }
            Board board = TicTacToeSolver.board;
            Intrinsics.checkNotNull(board);
            board.place(column, row, this.getSpotOwner(entityItemFrame));
            ((Map)mappedPositions).put(row * 3 + column, entityItemFrame);
        }
        if (board != null) {
            Board board = TicTacToeSolver.board;
            Intrinsics.checkNotNull(board);
            board.setTurn(frames2.size() % 2 == 0 ? Board.State.X : Board.State.O);
        }
    }

    private final int get(MapData $this$get, int index) {
        Intrinsics.checkNotNullParameter($this$get, "<this>");
        return (byte)($this$get.field_76198_e[index] & 0xFFFFFFFF);
    }

    private final MapData getMapData(EntityItemFrame entity) {
        return Items.field_151098_aY.func_77873_a(entity.func_82335_i(), (World)Skytils.Companion.getMc().field_71441_e);
    }

    private final Pair<Integer, Integer> getBoardPosition(EntityItemFrame frame) {
        BlockPos realPos = frame.func_180425_c().func_177977_b();
        BlockPos blockBehind = realPos.func_177972_a(frame.field_174860_b.func_176734_d());
        int row = 72 - realPos.func_177956_o();
        int column = !Intrinsics.areEqual(Skytils.Companion.getMc().field_71441_e.func_180495_p(blockBehind.func_177972_a(frame.field_174860_b.func_176735_f())).func_177230_c(), Blocks.field_150339_S) ? 2 : (!Intrinsics.areEqual(Skytils.Companion.getMc().field_71441_e.func_180495_p(blockBehind.func_177972_a(frame.field_174860_b.func_176746_e())).func_177230_c(), Blocks.field_150339_S) ? 0 : 1);
        return TuplesKt.to(row, column);
    }

    private final Board.State getSpotOwner(EntityItemFrame frame) {
        MapData mapData = this.getMapData(frame);
        if (mapData == null) {
            throw new IllegalStateException("Non map checked".toString());
        }
        MapData mapData2 = mapData;
        return this.get(mapData2, 8256) == 114 ? Board.State.X : Board.State.O;
    }

    static {
        mappedPositions = new HashMap();
        TickKt.tickTimer$default(20, true, false, 1.INSTANCE, 4, null);
    }
}

