/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.sugar.impl.ref;

import gg.skytils.mixinextras.lib.apache.commons.StringUtils;
import gg.skytils.mixinextras.service.MixinExtrasService;
import gg.skytils.mixinextras.sugar.impl.ref.LocalRefClassGenerator;
import gg.skytils.mixinextras.sugar.ref.LocalBooleanRef;
import gg.skytils.mixinextras.sugar.ref.LocalByteRef;
import gg.skytils.mixinextras.sugar.ref.LocalCharRef;
import gg.skytils.mixinextras.sugar.ref.LocalDoubleRef;
import gg.skytils.mixinextras.sugar.ref.LocalFloatRef;
import gg.skytils.mixinextras.sugar.ref.LocalIntRef;
import gg.skytils.mixinextras.sugar.ref.LocalLongRef;
import gg.skytils.mixinextras.sugar.ref.LocalRef;
import gg.skytils.mixinextras.sugar.ref.LocalShortRef;
import gg.skytils.mixinextras.utils.ASMUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class LocalRefUtils {
    public static Class<?> getInterfaceFor(Type type2) {
        if (!ASMUtils.isPrimitive(type2)) {
            return LocalRef.class;
        }
        switch (type2.getDescriptor().charAt(0)) {
            case 'Z': {
                return LocalBooleanRef.class;
            }
            case 'B': {
                return LocalByteRef.class;
            }
            case 'C': {
                return LocalCharRef.class;
            }
            case 'S': {
                return LocalShortRef.class;
            }
            case 'I': {
                return LocalIntRef.class;
            }
            case 'J': {
                return LocalLongRef.class;
            }
            case 'F': {
                return LocalFloatRef.class;
            }
            case 'D': {
                return LocalDoubleRef.class;
            }
        }
        throw new IllegalStateException("Illegal descriptor " + type2.getDescriptor());
    }

    public static Type getTargetType(Type type2, Type generic) {
        if (type2.getSort() != 10 || !MixinExtrasService.getInstance().isClassOwned(type2.getClassName())) {
            return type2;
        }
        switch (StringUtils.substringAfterLast(type2.getInternalName(), "/")) {
            case "LocalBooleanRef": {
                return Type.BOOLEAN_TYPE;
            }
            case "LocalByteRef": {
                return Type.BYTE_TYPE;
            }
            case "LocalCharRef": {
                return Type.CHAR_TYPE;
            }
            case "LocalDoubleRef": {
                return Type.DOUBLE_TYPE;
            }
            case "LocalFloatRef": {
                return Type.FLOAT_TYPE;
            }
            case "LocalIntRef": {
                return Type.INT_TYPE;
            }
            case "LocalLongRef": {
                return Type.LONG_TYPE;
            }
            case "LocalShortRef": {
                return Type.SHORT_TYPE;
            }
            case "LocalRef": {
                if (generic == null) {
                    throw new IllegalStateException("LocalRef must have a concrete type argument!");
                }
                return generic;
            }
        }
        return type2;
    }

    public static void generateNew(InsnList insns, Type innerType) {
        String refImpl = LocalRefClassGenerator.getForType(innerType);
        insns.add((AbstractInsnNode)new TypeInsnNode(187, refImpl));
        insns.add((AbstractInsnNode)new InsnNode(89));
        insns.add((AbstractInsnNode)new MethodInsnNode(183, refImpl, "<init>", "()V", false));
    }

    public static void generateInitialization(InsnList insns, Type innerType) {
        String refImpl = LocalRefClassGenerator.getForType(innerType);
        insns.add((AbstractInsnNode)new MethodInsnNode(182, refImpl, "init", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{LocalRefUtils.getErasedType(innerType)}), false));
    }

    public static void generateDisposal(InsnList insns, Type innerType) {
        String refImpl = LocalRefClassGenerator.getForType(innerType);
        insns.add((AbstractInsnNode)new MethodInsnNode(182, refImpl, "dispose", Type.getMethodDescriptor((Type)LocalRefUtils.getErasedType(innerType), (Type[])new Type[0]), false));
        if (!ASMUtils.isPrimitive(innerType)) {
            insns.add((AbstractInsnNode)new TypeInsnNode(192, innerType.getInternalName()));
        }
    }

    public static void generateUnwrapping(InsnList insns, Type innerType, Runnable load2) {
        String refInterface = Type.getInternalName(LocalRefUtils.getInterfaceFor(innerType));
        load2.run();
        insns.add((AbstractInsnNode)new MethodInsnNode(185, refInterface, "get", Type.getMethodDescriptor((Type)LocalRefUtils.getErasedType(innerType), (Type[])new Type[0]), true));
        if (!ASMUtils.isPrimitive(innerType)) {
            insns.add((AbstractInsnNode)new TypeInsnNode(192, innerType.getInternalName()));
        }
    }

    private static Type getErasedType(Type actual) {
        return ASMUtils.isPrimitive(actual) ? actual : ASMUtils.OBJECT_TYPE;
    }
}

