/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.expression.impl.flow.expansion;

import gg.skytils.mixinextras.expression.impl.flow.FlowValue;
import gg.skytils.mixinextras.expression.impl.flow.expansion.InsnExpander;
import gg.skytils.mixinextras.expression.impl.flow.postprocessing.FlowPostProcessor;
import gg.skytils.mixinextras.expression.impl.utils.ExpressionASMUtils;
import gg.skytils.mixinextras.lib.apache.commons.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class StringConcatFactoryExpander
extends InsnExpander {
    private static final String STRING_CONCAT_FACTORY = "java/lang/invoke/StringConcatFactory";
    private static final Type STRING_BUILDER = Type.getType(StringBuilder.class);
    private static final Type STRING = Type.getType(String.class);

    @Override
    public void process(FlowValue node, FlowPostProcessor.OutputSink sink) {
        AbstractInsnNode indy = node.getInsn();
        List<ConcatPart> parts = this.parseConcat(indy);
        if (parts == null) {
            return;
        }
        FlowValue current = new FlowValue(STRING_BUILDER, this.makeNewBuilder(), new FlowValue[0]);
        this.registerComponent(current, Component.NEW_BUILDER, indy);
        FlowValue initCall = new FlowValue(Type.VOID_TYPE, this.makeBuilderInit(), current);
        this.registerComponent(initCall, Component.BUILDER_INIT, indy);
        sink.registerFlow(current, initCall);
        int nextArgument = 0;
        int finishedParts = 0;
        for (ConcatPart part2 : parts) {
            FlowValue component;
            if (part2 instanceof ConcatPart.Argument) {
                component = node.getInput(nextArgument++);
            } else {
                Object cst = part2 instanceof ConcatPart.PooledConstant ? ((ConcatPart.PooledConstant)part2).value : ((ConcatPart.TemplateString)part2).value;
                LdcInsnNode componentInsn = new LdcInsnNode(cst);
                component = new FlowValue(ExpressionASMUtils.getNewType((AbstractInsnNode)componentInsn), (AbstractInsnNode)componentInsn, new FlowValue[0]);
                this.registerComponent(component, part2, indy);
                sink.registerFlow(component);
            }
            current = new FlowValue(STRING_BUILDER, this.makeAppendCall(component.getType()), current, component);
            this.registerComponent(current, new PartialResult(finishedParts++), indy);
            sink.registerFlow(current);
        }
        node.setInsn(this.makeToStringCall());
        node.setParents(current);
        this.registerComponent(node, Component.TO_STRING, indy);
    }

    @Override
    public void expand(Target target, InjectionNodes.InjectionNode node, InsnExpander.Expansion expansion) {
        InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)node.getCurrentTarget();
        Set<InsnExpander.InsnComponent> interests = expansion.registeredInterests();
        if (interests.size() == 1 && interests.iterator().next() == Component.TO_STRING) {
            expansion.registerInsn(Component.TO_STRING, node.getCurrentTarget());
            return;
        }
        ArrayList<Object> insns = new ArrayList<Object>();
        Type[] argTypes = Type.getArgumentTypes((String)indy.desc);
        int[] argMap = this.storeArgs(target, argTypes, insns::add);
        insns.add(expansion.registerInsn(Component.NEW_BUILDER, this.makeNewBuilder()));
        insns.add(new InsnNode(89));
        target.method.maxStack += 2;
        insns.add(expansion.registerInsn(Component.BUILDER_INIT, this.makeBuilderInit()));
        int nextArgument = 0;
        int finishedParts = 0;
        for (ConcatPart part2 : this.parseConcat((AbstractInsnNode)indy)) {
            Type partType;
            if (part2 instanceof ConcatPart.Argument) {
                int arg = nextArgument++;
                partType = argTypes[arg];
                insns.add(new VarInsnNode(partType.getOpcode(21), argMap[arg]));
            } else {
                Object cst = part2 instanceof ConcatPart.PooledConstant ? ((ConcatPart.PooledConstant)part2).value : ((ConcatPart.TemplateString)part2).value;
                AbstractInsnNode componentInsn = expansion.registerInsn(part2, (AbstractInsnNode)new LdcInsnNode(cst));
                partType = ExpressionASMUtils.getNewType(componentInsn);
                target.method.maxStack += partType.getSize();
                insns.add(componentInsn);
            }
            insns.add(expansion.registerInsn(new PartialResult(finishedParts++), this.makeAppendCall(partType)));
        }
        insns.add(expansion.registerInsn(Component.TO_STRING, this.makeToStringCall()));
        this.expandInsn(target, node, insns.toArray(new AbstractInsnNode[0]));
    }

    private List<ConcatPart> parseConcat(AbstractInsnNode insn) {
        if (!(insn instanceof InvokeDynamicInsnNode)) {
            return null;
        }
        InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
        if (!indy.bsm.getOwner().equals(STRING_CONCAT_FACTORY)) {
            return null;
        }
        if (indy.bsm.getName().equals("makeConcat")) {
            int inputCount = Type.getArgumentTypes((String)indy.desc).length;
            return this.parseConcatWithConstants(new Object[]{StringUtils.repeat('\u0001', inputCount)});
        }
        if (indy.bsm.getName().equals("makeConcatWithConstants")) {
            return this.parseConcatWithConstants(indy.bsmArgs);
        }
        return null;
    }

    private AbstractInsnNode makeNewBuilder() {
        return new TypeInsnNode(187, STRING_BUILDER.getInternalName());
    }

    private AbstractInsnNode makeBuilderInit() {
        return new MethodInsnNode(183, STRING_BUILDER.getInternalName(), "<init>", "()V", false);
    }

    private AbstractInsnNode makeAppendCall(Type type2) {
        if (type2.getSort() == 10) {
            type2 = ExpressionASMUtils.OBJECT_TYPE;
        }
        return new MethodInsnNode(182, STRING_BUILDER.getInternalName(), "append", Type.getMethodDescriptor((Type)STRING_BUILDER, (Type[])new Type[]{type2}), false);
    }

    private AbstractInsnNode makeToStringCall() {
        return new MethodInsnNode(182, STRING_BUILDER.getInternalName(), "toString", Type.getMethodDescriptor((Type)STRING, (Type[])new Type[0]), false);
    }

    private List<ConcatPart> parseConcatWithConstants(Object[] bsmArgs) {
        String template = (String)bsmArgs[0];
        ArrayList<ConcatPart> result2 = new ArrayList<ConcatPart>();
        int id = 0;
        int nextCst = 1;
        StringBuilder currentString = null;
        block4: for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if ((c == '\u0001' || c == '\u0002') && currentString != null) {
                result2.add(new ConcatPart.TemplateString(id++, currentString.toString()));
                currentString = null;
            }
            switch (c) {
                case '\u0001': {
                    result2.add(new ConcatPart.Argument(id++));
                    continue block4;
                }
                case '\u0002': {
                    result2.add(new ConcatPart.PooledConstant(id++, bsmArgs[nextCst++]));
                    continue block4;
                }
                default: {
                    if (currentString == null) {
                        currentString = new StringBuilder();
                    }
                    currentString.append(c);
                }
            }
        }
        if (currentString != null) {
            result2.add(new ConcatPart.TemplateString(id, currentString.toString()));
        }
        return result2;
    }

    private int[] storeArgs(Target target, Type[] args2, Consumer<AbstractInsnNode> add) {
        int[] map2 = new int[args2.length];
        for (int i = args2.length - 1; i >= 0; --i) {
            Type type2 = args2[i];
            int index = target.allocateLocals(type2.getSize());
            target.addLocalVariable(index, "concatTemp" + index, type2.getDescriptor());
            map2[i] = index;
            add.accept((AbstractInsnNode)new VarInsnNode(type2.getOpcode(54), index));
        }
        return map2;
    }

    private static enum Component implements InsnExpander.InsnComponent
    {
        NEW_BUILDER,
        BUILDER_INIT,
        TO_STRING;

    }

    private static abstract class ConcatPart
    implements InsnExpander.InsnComponent {
        private final int id;

        private ConcatPart(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcatPart that = (ConcatPart)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        public static class TemplateString
        extends ConcatPart {
            public final String value;

            public TemplateString(int id, String value) {
                super(id);
                this.value = value;
            }
        }

        public static class PooledConstant
        extends ConcatPart {
            public final Object value;

            public PooledConstant(int id, Object value) {
                super(id);
                this.value = value;
            }
        }

        public static class Argument
        extends ConcatPart {
            public Argument(int id) {
                super(id);
            }
        }
    }

    private static class PartialResult
    implements InsnExpander.InsnComponent {
        public final int finishedParts;

        private PartialResult(int finishedParts) {
            this.finishedParts = finishedParts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartialResult that = (PartialResult)o;
            return this.finishedParts == that.finishedParts;
        }

        public int hashCode() {
            return Objects.hashCode(this.finishedParts);
        }
    }
}

