/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.json.internal;

import gg.skytils.ktx-serialization.descriptors.ContextAwareKt;
import gg.skytils.ktx-serialization.descriptors.PolymorphicKind;
import gg.skytils.ktx-serialization.descriptors.PrimitiveKind;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptor;
import gg.skytils.ktx-serialization.descriptors.SerialKind;
import gg.skytils.ktx-serialization.descriptors.StructureKind;
import gg.skytils.ktx-serialization.json.Json;
import gg.skytils.ktx-serialization.json.internal.JsonExceptionsKt;
import gg.skytils.ktx-serialization.json.internal.WriteMode;
import gg.skytils.ktx-serialization.modules.SerializersModule;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001b\u0010\u0003\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001aU\u0010\r\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u0005\"\b\b\u0001\u0010\u0006*\u00028\u0000\"\b\b\u0002\u0010\u0007*\u00028\u0000*\u00020\b2\u0006\u0010\t\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\nH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u001b\u0010\u0011\u001a\u00020\u0010*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "Lgg/skytils/ktx-serialization/modules/SerializersModule;", "module", "carrierDescriptor", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;Lgg/skytils/ktx-serialization/modules/SerializersModule;)Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "T", "R1", "R2", "Lgg/skytils/ktx-serialization/json/Json;", "mapDescriptor", "Lkotlin/Function0;", "ifMap", "ifList", "selectMapMode", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "desc", "Lgg/skytils/ktx-serialization/json/internal/WriteMode;", "switchMode", "(Lgg/skytils/ktx-serialization/json/Json;Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;)Lgg/skytils/ktx-serialization/json/internal/WriteMode;", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nWriteMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteMode.kt\nkotlinx/serialization/json/internal/WriteModeKt\n*L\n1#1,53:1\n36#1,9:54\n*S KotlinDebug\n*F\n+ 1 WriteMode.kt\nkotlinx/serialization/json/internal/WriteModeKt\n*L\n26#1:54,9\n*E\n"})
public final class WriteModeKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final WriteMode switchMode(@NotNull Json $this$switchMode, @NotNull SerialDescriptor desc) {
        WriteMode writeMode;
        Intrinsics.checkNotNullParameter($this$switchMode, "<this>");
        Intrinsics.checkNotNullParameter(desc, "desc");
        SerialKind serialKind = desc.getKind();
        if (serialKind instanceof PolymorphicKind) {
            writeMode = WriteMode.POLY_OBJ;
            return writeMode;
        } else if (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE)) {
            writeMode = WriteMode.LIST;
            return writeMode;
        } else if (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE)) {
            Json $this$selectMapMode$iv = $this$switchMode;
            boolean $i$f$selectMapMode = false;
            SerialDescriptor keyDescriptor$iv = WriteModeKt.carrierDescriptor(desc.getElementDescriptor(0), $this$selectMapMode$iv.getSerializersModule());
            SerialKind keyKind$iv = keyDescriptor$iv.getKind();
            if (keyKind$iv instanceof PrimitiveKind || Intrinsics.areEqual(keyKind$iv, SerialKind.ENUM.INSTANCE)) {
                boolean bl = false;
                writeMode = WriteMode.MAP;
                return writeMode;
            } else {
                if (!$this$selectMapMode$iv.getConfiguration().getAllowStructuredMapKeys()) throw JsonExceptionsKt.InvalidKeyKindException(keyDescriptor$iv);
                boolean bl = false;
                writeMode = WriteMode.LIST;
            }
            return writeMode;
        } else {
            writeMode = WriteMode.OBJ;
        }
        return writeMode;
    }

    public static final <T, R1 extends T, R2 extends T> T selectMapMode(@NotNull Json $this$selectMapMode, @NotNull SerialDescriptor mapDescriptor, @NotNull Function0<? extends R1> ifMap, @NotNull Function0<? extends R2> ifList) {
        Object object;
        Intrinsics.checkNotNullParameter($this$selectMapMode, "<this>");
        Intrinsics.checkNotNullParameter(mapDescriptor, "mapDescriptor");
        Intrinsics.checkNotNullParameter(ifMap, "ifMap");
        Intrinsics.checkNotNullParameter(ifList, "ifList");
        boolean $i$f$selectMapMode = false;
        SerialDescriptor keyDescriptor = WriteModeKt.carrierDescriptor(mapDescriptor.getElementDescriptor(0), $this$selectMapMode.getSerializersModule());
        SerialKind keyKind = keyDescriptor.getKind();
        if (keyKind instanceof PrimitiveKind || Intrinsics.areEqual(keyKind, SerialKind.ENUM.INSTANCE)) {
            object = ifMap.invoke();
        } else if ($this$selectMapMode.getConfiguration().getAllowStructuredMapKeys()) {
            object = ifList.invoke();
        } else {
            throw JsonExceptionsKt.InvalidKeyKindException(keyDescriptor);
        }
        return (T)object;
    }

    @NotNull
    public static final SerialDescriptor carrierDescriptor(@NotNull SerialDescriptor $this$carrierDescriptor, @NotNull SerializersModule module) {
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter($this$carrierDescriptor, "<this>");
        Intrinsics.checkNotNullParameter(module, "module");
        if (Intrinsics.areEqual($this$carrierDescriptor.getKind(), SerialKind.CONTEXTUAL.INSTANCE)) {
            serialDescriptor = ContextAwareKt.getContextualDescriptor(module, $this$carrierDescriptor);
            if (serialDescriptor == null || (serialDescriptor = WriteModeKt.carrierDescriptor(serialDescriptor, module)) == null) {
                serialDescriptor = $this$carrierDescriptor;
            }
        } else {
            serialDescriptor = $this$carrierDescriptor.isInline() ? WriteModeKt.carrierDescriptor($this$carrierDescriptor.getElementDescriptor(0), module) : $this$carrierDescriptor;
        }
        return serialDescriptor;
    }
}

