/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.json.internal;

import gg.skytils.ktx-serialization.DeserializationStrategy;
import gg.skytils.ktx-serialization.json.Json;
import gg.skytils.ktx-serialization.json.internal.AbstractJsonLexer;
import gg.skytils.ktx-serialization.json.internal.ReaderJsonLexer;
import gg.skytils.ktx-serialization.json.internal.StreamingJsonDecoder;
import gg.skytils.ktx-serialization.json.internal.WriteMode;
import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B%\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0004\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\fR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lgg/skytils/ktx-serialization/json/internal/JsonIteratorArrayWrapped;", "T", "", "", "hasNext", "()Z", "next", "()Ljava/lang/Object;", "Lgg/skytils/ktx-serialization/DeserializationStrategy;", "deserializer", "Lgg/skytils/ktx-serialization/DeserializationStrategy;", "finished", "Z", "first", "Lgg/skytils/ktx-serialization/json/Json;", "json", "Lgg/skytils/ktx-serialization/json/Json;", "Lgg/skytils/ktx-serialization/json/internal/ReaderJsonLexer;", "lexer", "Lgg/skytils/ktx-serialization/json/internal/ReaderJsonLexer;", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/ReaderJsonLexer;Lkotlinx/serialization/DeserializationStrategy;)V", "kotlinx-serialization-json"})
final class JsonIteratorArrayWrapped<T>
implements Iterator<T>,
KMappedMarker {
    @NotNull
    private final Json json;
    @NotNull
    private final ReaderJsonLexer lexer;
    @NotNull
    private final DeserializationStrategy<T> deserializer;
    private boolean first;
    private boolean finished;

    public JsonIteratorArrayWrapped(@NotNull Json json2, @NotNull ReaderJsonLexer lexer, @NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(json2, "json");
        Intrinsics.checkNotNullParameter(lexer, "lexer");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        this.json = json2;
        this.lexer = lexer;
        this.deserializer = deserializer;
        this.first = true;
    }

    @Override
    public T next() {
        if (this.first) {
            this.first = false;
        } else {
            this.lexer.consumeNextToken(',');
        }
        StreamingJsonDecoder input2 = new StreamingJsonDecoder(this.json, WriteMode.OBJ, this.lexer, this.deserializer.getDescriptor(), null);
        return input2.decodeSerializableValue(this.deserializer);
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.lexer.peekNextToken() == 9) {
            this.finished = true;
            this.lexer.consumeNextToken((byte)9);
            if (this.lexer.isNotEof()) {
                if (this.lexer.peekNextToken() == 8) {
                    AbstractJsonLexer.fail$default(this.lexer, "There is a start of the new array after the one parsed to sequence. ARRAY_WRAPPED mode doesn't merge consecutive arrays.\nIf you need to parse a stream of arrays, please use WHITESPACE_SEPARATED mode instead.", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                this.lexer.expectEof();
            }
            return false;
        }
        if (!this.lexer.isNotEof() && !this.finished) {
            AbstractJsonLexer.fail$kotlinx_serialization_json$default(this.lexer, (byte)9, false, 2, null);
            throw new KotlinNothingValueException();
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

