/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.websocket;

import gg.skytils.ktor.utils.io.charsets.EncodingKt;
import gg.skytils.ktor.utils.io.core.BytePacketBuilder;
import gg.skytils.ktor.utils.io.core.ByteReadPacket;
import gg.skytils.ktor.utils.io.core.Input;
import gg.skytils.ktor.utils.io.core.InputPrimitivesKt;
import gg.skytils.ktor.utils.io.core.Output;
import gg.skytils.ktor.utils.io.core.OutputKt;
import gg.skytils.ktor.websocket.CloseReason;
import gg.skytils.ktor.websocket.Frame;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0011\u0010\n\u001a\u00020\t*\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgg/skytils/ktor/websocket/Frame;", "", "readBytes", "(Lgg/skytils/ktor/websocket/Frame;)[B", "Lgg/skytils/ktor/websocket/Frame$Close;", "Lgg/skytils/ktor/websocket/CloseReason;", "readReason", "(Lgg/skytils/ktor/websocket/Frame$Close;)Lgg/skytils/ktor/websocket/CloseReason;", "Lgg/skytils/ktor/websocket/Frame$Text;", "", "readText", "(Lgg/skytils/ktor/websocket/Frame$Text;)Ljava/lang/String;", "ktor-websockets"})
@SourceDebugExtension(value={"SMAP\nFrameCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameCommon.kt\nio/ktor/websocket/FrameCommonKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n*L\n1#1,173:1\n1#2:174\n12#3,11:175\n12#3,11:186\n*S KotlinDebug\n*F\n+ 1 FrameCommon.kt\nio/ktor/websocket/FrameCommonKt\n*L\n142#1:175,11\n161#1:186,11\n*E\n"})
public final class FrameCommonKt {
    @NotNull
    public static final String readText(@NotNull Frame.Text $this$readText) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$readText, "<this>");
        if (!$this$readText.getFin()) {
            boolean $i$a$-require-FrameCommonKt$readText$22 = false;
            String $i$a$-require-FrameCommonKt$readText$22 = "Text could be only extracted from non-fragmented frame";
            throw new IllegalArgumentException($i$a$-require-FrameCommonKt$readText$22.toString());
        }
        CharsetDecoder charsetDecoder = Charsets.UTF_8.newDecoder();
        Intrinsics.checkNotNullExpressionValue(charsetDecoder, "UTF_8.newDecoder()");
        CharsetDecoder charsetDecoder2 = charsetDecoder;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$readText_u24lambda_u241 = builder$iv;
            boolean bl = false;
            OutputKt.writeFully$default((Output)$this$readText_u24lambda_u241, $this$readText.getData(), 0, 0, 6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return EncodingKt.decode$default(charsetDecoder2, byteReadPacket, 0, 2, null);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Frame $this$readBytes) {
        Intrinsics.checkNotNullParameter($this$readBytes, "<this>");
        byte[] byArray = $this$readBytes.getData();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(this, size)");
        return byArray2;
    }

    @Nullable
    public static final CloseReason readReason(@NotNull Frame.Close $this$readReason) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$readReason, "<this>");
        if ($this$readReason.getData().length < 2) {
            return null;
        }
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$readReason_u24lambda_u242 = builder$iv;
            boolean bl = false;
            OutputKt.writeFully$default((Output)$this$readReason_u24lambda_u242, $this$readReason.getData(), 0, 0, 6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet2 = byteReadPacket;
        short code = InputPrimitivesKt.readShort(packet2);
        String message = Input.readText$default(packet2, 0, 0, 3, null);
        return new CloseReason(code, message);
    }
}

