/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.routing;

import gg.skytils.ktor.http.Parameters;
import gg.skytils.ktor.http.ParametersBuilder;
import gg.skytils.ktor.http.ParametersKt;
import gg.skytils.ktor.server.routing.IgnoreTrailingSlashKt;
import gg.skytils.ktor.server.routing.RouteSelector;
import gg.skytils.ktor.server.routing.RouteSelectorEvaluation;
import gg.skytils.ktor.server.routing.RoutingResolveContext;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lgg/skytils/ktor/server/routing/PathSegmentRegexRouteSelector;", "Lgg/skytils/ktor/server/routing/RouteSelector;", "Lkotlin/text/MatchResult;", "result", "", "lastSlashPosition", "", "prefix", "countSegments", "(Lkotlin/text/MatchResult;ILjava/lang/String;)I", "Lgg/skytils/ktor/server/routing/RoutingResolveContext;", "context", "segmentIndex", "Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lgg/skytils/ktor/server/routing/RoutingResolveContext;I)Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation;", "toString", "()Ljava/lang/String;", "Lkotlin/text/Regex;", "regex", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "Companion", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRegexRouting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexRouting.kt\nio/ktor/server/routing/PathSegmentRegexRouteSelector\n+ 2 Parameters.kt\nio/ktor/http/Parameters$Companion\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,285:1\n24#2:286\n1295#3,2:287\n1099#4,3:289\n*S KotlinDebug\n*F\n+ 1 RegexRouting.kt\nio/ktor/server/routing/PathSegmentRegexRouteSelector\n*L\n259#1:286\n260#1:287,2\n275#1:289,3\n*E\n"})
public final class PathSegmentRegexRouteSelector
extends RouteSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex regex;
    @NotNull
    private static final Regex GROUP_NAME_MATCHER = new Regex("(^|[^\\\\])\\(\\?<(\\p{Alpha}\\p{Alnum}*)>(.*?[^\\\\])?\\)");

    public PathSegmentRegexRouteSelector(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter(regex, "regex");
        this.regex = regex;
    }

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        ParametersBuilder parametersBuilder;
        int n;
        Intrinsics.checkNotNullParameter(context, "context");
        String prefix2 = StringsKt.startsWith$default((CharSequence)this.regex.getPattern(), '/', false, 2, null) || StringsKt.startsWith$default(this.regex.getPattern(), "\\/", false, 2, null) ? "/" : "";
        String postfix = StringsKt.endsWith$default((CharSequence)this.regex.getPattern(), '/', false, 2, null) && IgnoreTrailingSlashKt.getIgnoreTrailingSlash(context.getCall()) ? "/" : "";
        String pathSegments = CollectionsKt.joinToString$default(CollectionsKt.drop((Iterable)context.getSegments(), segmentIndex), "/", prefix2, postfix, 0, null, null, 56, null);
        MatchResult matchResult = Regex.find$default(this.regex, pathSegments, 0, 2, null);
        if (matchResult == null) {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        MatchResult result2 = matchResult;
        int consumedLength = result2.getValue().length();
        boolean bl = false;
        if (pathSegments.length() == consumedLength) {
            n = context.getSegments().size() - segmentIndex;
        } else if (pathSegments.charAt(consumedLength) == '/') {
            n = this.countSegments(result2, consumedLength, prefix2);
        } else if (consumedLength >= 1 && pathSegments.charAt(consumedLength - 1) == '/') {
            n = this.countSegments(result2, consumedLength - 1, prefix2);
        } else {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        int segmentIncrement = n;
        MatchGroupCollection matchGroupCollection = result2.getGroups();
        Intrinsics.checkNotNull(matchGroupCollection, "null cannot be cast to non-null type kotlin.text.MatchNamedGroupCollection");
        MatchNamedGroupCollection groups2 = (MatchNamedGroupCollection)matchGroupCollection;
        Parameters.Companion this_$iv = Parameters.Companion;
        boolean $i$f$build = false;
        ParametersBuilder $this$evaluate_u24lambda_u242 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        boolean bl2 = false;
        Sequence $this$forEach$iv = Regex.findAll$default(GROUP_NAME_MATCHER, this.regex.getPattern(), 0, 2, null);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            MatchResult matchResult2 = (MatchResult)element$iv;
            boolean bl3 = false;
            String name = matchResult2.getDestructured().getMatch().getGroupValues().get(2);
            Object object = groups2.get(name);
            if (object == null || (object = ((MatchGroup)object).getValue()) == null) {
                object = "";
            }
            Object value = object;
            $this$evaluate_u24lambda_u242.append(name, (String)value);
        }
        Parameters parameters2 = parametersBuilder.build();
        return new RouteSelectorEvaluation.Success(1.0, parameters2, segmentIncrement);
    }

    private final int countSegments(MatchResult result2, int lastSlashPosition, String prefix2) {
        String string = result2.getValue().substring(0, lastSlashPosition);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        String segments2 = string;
        CharSequence $this$count$iv = segments2;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv;
        }
        int count2 = count$iv;
        return Intrinsics.areEqual(prefix2, "/") ? count2 : count2 + 1;
    }

    @NotNull
    public String toString() {
        return "Regex(" + this.regex.getPattern() + ')';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lgg/skytils/ktor/server/routing/PathSegmentRegexRouteSelector$Companion;", "", "Lkotlin/text/Regex;", "GROUP_NAME_MATCHER", "Lkotlin/text/Regex;", "<init>", "()V", "ktor-server-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

