/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.auth;

import gg.skytils.ktor.server.auth.UserIdPrincipal;
import gg.skytils.ktor.server.auth.UserPasswordCredential;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R#\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR#\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lgg/skytils/ktor/server/auth/UserHashedTableAuth;", "", "Lgg/skytils/ktor/server/auth/UserPasswordCredential;", "credential", "Lgg/skytils/ktor/server/auth/UserIdPrincipal;", "authenticate", "(Lgg/skytils/ktor/server/auth/UserPasswordCredential;)Lgg/skytils/ktor/server/auth/UserIdPrincipal;", "Lkotlin/Function1;", "", "", "digester", "Lkotlin/jvm/functions/Function1;", "getDigester", "()Lkotlin/jvm/functions/Function1;", "", "table", "Ljava/util/Map;", "getTable", "()Ljava/util/Map;", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/Map;)V", "ktor-server-auth"})
public final class UserHashedTableAuth {
    @NotNull
    private final Function1<String, byte[]> digester;
    @NotNull
    private final Map<String, byte[]> table;

    public UserHashedTableAuth(@NotNull Function1<? super String, byte[]> digester, @NotNull Map<String, byte[]> table) {
        Intrinsics.checkNotNullParameter(digester, "digester");
        Intrinsics.checkNotNullParameter(table, "table");
        this.digester = digester;
        this.table = table;
        if (this.table.isEmpty()) {
            // empty if block
        }
    }

    @NotNull
    public final Function1<String, byte[]> getDigester() {
        return this.digester;
    }

    @NotNull
    public final Map<String, byte[]> getTable() {
        return this.table;
    }

    @Nullable
    public final UserIdPrincipal authenticate(@NotNull UserPasswordCredential credential) {
        Intrinsics.checkNotNullParameter(credential, "credential");
        byte[] userPasswordHash = this.table.get(credential.getName());
        if (userPasswordHash != null && Arrays.equals(this.digester.invoke(credential.getPassword()), userPasswordHash)) {
            return new UserIdPrincipal(credential.getName());
        }
        return null;
    }
}

