/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.network.tls.cipher;

import gg.skytils.ktor.network.tls.cipher.CipherKt;
import gg.skytils.ktor.network.tls.cipher.CipherUtilsKt;
import gg.skytils.ktor.network.util.PoolsKt;
import gg.skytils.ktor.utils.io.core.ByteBuffersKt;
import gg.skytils.ktor.utils.io.core.BytePacketBuilder;
import gg.skytils.ktor.utils.io.core.ByteReadPacket;
import gg.skytils.ktor.utils.io.core.Output;
import gg.skytils.ktor.utils.io.core.OutputArraysJVMKt;
import gg.skytils.ktor.utils.io.core.OutputKt;
import gg.skytils.ktor.utils.io.pool.ByteBufferPool;
import gg.skytils.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a6\u0010\b\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0019\b\u0002\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0000\u00a2\u0006\u0004\b\b\u0010\t\" \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lgg/skytils/ktor/utils/io/core/ByteReadPacket;", "Ljavax/crypto/Cipher;", "cipher", "Lkotlin/Function1;", "Lgg/skytils/ktor/utils/io/core/BytePacketBuilder;", "", "Lkotlin/ExtensionFunctionType;", "header", "cipherLoop", "(Lgg/skytils/ktor/utils/io/core/ByteReadPacket;Ljavax/crypto/Cipher;Lkotlin/jvm/functions/Function1;)Lgg/skytils/ktor/utils/io/core/ByteReadPacket;", "Lgg/skytils/ktor/utils/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "CryptoBufferPool", "Lgg/skytils/ktor/utils/io/pool/ObjectPool;", "getCryptoBufferPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nCipherUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CipherUtils.kt\nio/ktor/network/tls/cipher/CipherUtilsKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 Packet.kt\nio/ktor/utils/io/core/PacketKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n12#2,7:76\n19#2,4:85\n39#3:83\n1#4:84\n*S KotlinDebug\n*F\n+ 1 CipherUtils.kt\nio/ktor/network/tls/cipher/CipherUtilsKt\n*L\n21#1:76,7\n21#1:85,4\n29#1:83\n*E\n"})
public final class CipherUtilsKt {
    @NotNull
    private static final ObjectPool<ByteBuffer> CryptoBufferPool = new ByteBufferPool(128, 65536);

    @NotNull
    public static final ObjectPool<ByteBuffer> getCryptoBufferPool() {
        return CryptoBufferPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ByteReadPacket cipherLoop(@NotNull ByteReadPacket $this$cipherLoop, @NotNull Cipher cipher2, @NotNull Function1<? super BytePacketBuilder, Unit> header) {
        Intrinsics.checkNotNullParameter($this$cipherLoop, "<this>");
        Intrinsics.checkNotNullParameter(cipher2, "cipher");
        Intrinsics.checkNotNullParameter(header, "header");
        ByteBuffer srcBuffer = PoolsKt.getDefaultByteBufferPool().borrow();
        ByteBuffer dstBuffer = null;
        dstBuffer = CryptoBufferPool.borrow();
        boolean dstBufferFromPool = false;
        dstBufferFromPool = true;
        try {
            ByteReadPacket byteReadPacket;
            boolean $i$f$buildPacket = false;
            BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
            try {
                int rc2;
                BytePacketBuilder $this$cipherLoop_u24lambda_u242 = builder$iv;
                boolean bl = false;
                srcBuffer.clear();
                header.invoke($this$cipherLoop_u24lambda_u242);
                while (true) {
                    rc2 = srcBuffer.hasRemaining() ? ByteBuffersKt.readAvailable($this$cipherLoop, srcBuffer) : 0;
                    srcBuffer.flip();
                    if (!srcBuffer.hasRemaining()) {
                        if (rc2 == -1) break;
                        ByteReadPacket $this$isEmpty$iv = $this$cipherLoop;
                        boolean $i$f$isEmpty = false;
                        if ($this$isEmpty$iv.getEndOfInput()) break;
                    }
                    dstBuffer.clear();
                    if (cipher2.getOutputSize(srcBuffer.remaining()) > dstBuffer.remaining()) {
                        if (dstBufferFromPool) {
                            CryptoBufferPool.recycle(dstBuffer);
                        }
                        Intrinsics.checkNotNullExpressionValue(ByteBuffer.allocate(cipher2.getOutputSize(srcBuffer.remaining())), "allocate(cipher.getOutpu\u2026e(srcBuffer.remaining()))");
                        dstBufferFromPool = false;
                    }
                    cipher2.update(srcBuffer, dstBuffer);
                    dstBuffer.flip();
                    OutputArraysJVMKt.writeFully($this$cipherLoop_u24lambda_u242, dstBuffer);
                    srcBuffer.compact();
                }
                int n = rc2 = !srcBuffer.hasRemaining() ? 1 : 0;
                if (_Assertions.ENABLED && rc2 == 0) {
                    boolean $i$a$-assert-CipherUtilsKt$cipherLoop$2$32 = false;
                    String $i$a$-assert-CipherUtilsKt$cipherLoop$2$32 = "Cipher loop completed too early: there are unprocessed bytes";
                    throw new AssertionError((Object)$i$a$-assert-CipherUtilsKt$cipherLoop$2$32);
                }
                int n2 = rc2 = !dstBuffer.hasRemaining() ? 1 : 0;
                if (_Assertions.ENABLED && rc2 == 0) {
                    boolean bl2 = false;
                    String string = "Not all bytes were appended to the packet";
                    throw new AssertionError((Object)string);
                }
                int requiredBufferSize = cipher2.getOutputSize(0);
                if (requiredBufferSize != 0) {
                    if (requiredBufferSize > dstBuffer.capacity()) {
                        Output output2 = $this$cipherLoop_u24lambda_u242;
                        byte[] byArray = cipher2.doFinal();
                        Intrinsics.checkNotNullExpressionValue(byArray, "cipher.doFinal()");
                        OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
                    } else {
                        dstBuffer.clear();
                        cipher2.doFinal(CipherKt.getEmptyByteBuffer(), dstBuffer);
                        dstBuffer.flip();
                        if (!dstBuffer.hasRemaining()) {
                            Output output3 = $this$cipherLoop_u24lambda_u242;
                            byte[] byArray = cipher2.doFinal();
                            Intrinsics.checkNotNullExpressionValue(byArray, "cipher.doFinal()");
                            OutputKt.writeFully$default(output3, byArray, 0, 0, 6, null);
                        } else {
                            OutputArraysJVMKt.writeFully($this$cipherLoop_u24lambda_u242, dstBuffer);
                        }
                    }
                }
                byteReadPacket = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            ByteReadPacket byteReadPacket2 = byteReadPacket;
            return byteReadPacket2;
        }
        finally {
            PoolsKt.getDefaultByteBufferPool().recycle(srcBuffer);
            if (dstBufferFromPool) {
                CryptoBufferPool.recycle(dstBuffer);
            }
        }
    }

    public static /* synthetic */ ByteReadPacket cipherLoop$default(ByteReadPacket byteReadPacket, Cipher cipher2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = cipherLoop.1.INSTANCE;
        }
        return CipherUtilsKt.cipherLoop(byteReadPacket, cipher2, function1);
    }
}

