/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.utils;

import codes.biscuit.skyblockaddons.SkyblockAddons;
import codes.biscuit.skyblockaddons.core.Attribute;
import codes.biscuit.skyblockaddons.core.CrimsonArmorAbilityStack;
import codes.biscuit.skyblockaddons.core.Feature;
import codes.biscuit.skyblockaddons.core.SkillType;
import codes.biscuit.skyblockaddons.core.Translations;
import codes.biscuit.skyblockaddons.utils.TextUtils;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class ActionBarParser {
    private static final Pattern COLLECTIONS_CHAT_PATTERN = Pattern.compile("\\+(?<gained>[0-9,.]+) (?<skillName>[A-Za-z]+) (?<progress>\\((((?<current>[0-9.,kM]+)/(?<total>[0-9.,kM]+))|((?<percent>[0-9.,]+)%))\\))");
    private static final Pattern SKILL_GAIN_PATTERN_S = Pattern.compile("\\+(?<gained>[0-9,.]+) (?<skillName>[A-Za-z]+) (?<progress>\\((((?<current>[0-9.,]+)/(?<total>[0-9.,]+))|((?<percent>[0-9.]+)%))\\))");
    private static final Pattern MANA_PATTERN_S = Pattern.compile("(?<num>[0-9,.]+)/(?<den>[0-9,.]+)\u270e(| Mana| (?<overflow>-?[0-9,.]+)\u02ac)");
    private static final Pattern DEFENSE_PATTERN_S = Pattern.compile("(?<defense>[0-9,.]+)\u2748 Defense(?<other>( (?<align>\\|\\|\\|))?( {2}(?<tether>T[0-9,.]+!?))?.*)?");
    private static final Pattern HEALTH_PATTERN_S = Pattern.compile("(?<health>[0-9,.]+)/(?<maxHealth>[0-9,.]+)\u2764(?<wand>\\+(?<wandHeal>[0-9,.]+)[\u2586\u2585\u2584\u2583\u2582\u2581])?");
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final Logger logger = SkyblockAddons.getLogger();
    private int tickers = -1;
    private int maxTickers = 0;
    private float lastSecondHealth = -1.0f;
    private Float healthUpdate;
    private long lastHealthUpdate;
    private float currentSkillXP;
    private int totalSkillXP;
    private float percent;
    private boolean healthLock;
    private String otherDefense;
    private String lastParsedSkillSection = "";
    private String lastSkillProgressString;
    private SkillType lastSkillType;
    private final LinkedList<String> stringsToRemove = new LinkedList();

    public String parseActionBar(String actionBar) {
        String[] splitMessage = actionBar.split(" {3,}");
        LinkedList<String> unusedSections = new LinkedList<String>();
        this.stringsToRemove.clear();
        main.getRenderListener().setPredictMana(true);
        main.getRenderListener().setPredictHealth(true);
        this.tickers = -1;
        if (actionBar.contains("\u2764") && !actionBar.contains("\u2748") && splitMessage.length == 2) {
            this.setAttribute(Attribute.DEFENCE, 0.0f);
        }
        for (String section : splitMessage) {
            try {
                String sectionReturn = this.parseSection(section);
                if (sectionReturn != null) {
                    unusedSections.add(sectionReturn);
                    continue;
                }
                this.stringsToRemove.add(section);
            }
            catch (Exception ex) {
                unusedSections.add(section);
            }
        }
        return String.join((CharSequence)StringUtils.repeat((String)" ", (int)5), unusedSections);
    }

    private String parseSection(String section) {
        String stripColoring = TextUtils.stripColor(section);
        try {
            String convertMag = TextUtils.convertMagnitudes(stripColoring);
            if (section.contains("\u02ac")) {
                convertMag = convertMag.split(" ")[0];
            }
            String numbersOnly = TextUtils.getNumbersOnly(convertMag).trim();
            String[] splitStats = numbersOnly.split("/");
            if (section.contains("\u2764")) {
                if ((section = this.parseCrimsonArmorAbilityStack(section)).endsWith("\u0ca0") && section.contains("Glare Damage")) {
                    section = section.split(Pattern.quote("\u00a76 "))[0];
                }
                return this.parseHealth(section);
            }
            if (section.contains("\u2748")) {
                return this.parseDefense(section);
            }
            if (section.endsWith("\u00a7f\u2742 True Defense")) {
                return this.parseTrueDefence(section);
            }
            if (section.contains("\u270e")) {
                return this.parseMana(section);
            }
            if (section.contains("(")) {
                return this.parseSkill(convertMag);
            }
            if (section.contains("\u24c4") || section.contains("\u24e9")) {
                return this.parseTickers(section);
            }
            if (section.contains("Drill")) {
                return this.parseDrill(section, splitStats);
            }
        }
        catch (ParseException e) {
            logger.error("The section \"" + section + "\" will be skipped due to an error during number parsing.");
            logger.error("Failed to parse number at offset " + e.getErrorOffset() + " in string \"" + e.getMessage() + "\".", (Throwable)e);
            return section;
        }
        return section;
    }

    private String parseTrueDefence(String section) {
        return main.getConfigValues().isEnabled(Feature.HIDE_TRUE_DEFENSE) ? null : section;
    }

    private String parseCrimsonArmorAbilityStack(String section) {
        for (CrimsonArmorAbilityStack crimsonArmorAbilityStack : CrimsonArmorAbilityStack.values()) {
            crimsonArmorAbilityStack.setCurrentValue(0);
        }
        int runs = 0;
        block1: while (section.contains("  ") && ++runs != 5) {
            if (section.endsWith("\u00a7r")) {
                section = section.substring(0, section.length() - 2);
            }
            for (CrimsonArmorAbilityStack crimsonArmorAbilityStack : CrimsonArmorAbilityStack.values()) {
                String stackSymbol = crimsonArmorAbilityStack.getSymbol();
                if (!section.endsWith(stackSymbol)) continue;
                String[] split = section.split("\u00a76");
                String stack = split[split.length - 1];
                String remove = "\u00a76" + stack;
                if (stack.contains("\u00a7l")) {
                    stack = stack.substring(2);
                    if (Feature.CRIMSON_ARMOR_ABILITY_STACKS.isEnabled()) {
                        String realRemove = remove + "\u00a7r";
                        this.stringsToRemove.add(realRemove);
                    }
                } else if (Feature.CRIMSON_ARMOR_ABILITY_STACKS.isEnabled()) {
                    this.stringsToRemove.add(remove);
                }
                stack = stack.substring(0, stack.length() - 1);
                section = section.substring(0, section.length() - remove.length());
                section = section.trim();
                crimsonArmorAbilityStack.setCurrentValue(Integer.parseInt(stack));
                continue block1;
            }
        }
        return section;
    }

    private String parseHealth(String healthSection) {
        boolean separateDisplay = main.getConfigValues().isEnabled(Feature.HEALTH_BAR) || main.getConfigValues().isEnabled(Feature.HEALTH_TEXT);
        String returnString = healthSection;
        String stripped = TextUtils.stripColor(healthSection);
        Matcher m = HEALTH_PATTERN_S.matcher(stripped);
        if (separateDisplay && m.matches()) {
            float newHealth = this.parseFloat(m.group("health"));
            float maxHealth = this.parseFloat(m.group("maxHealth"));
            if (m.group("wand") != null) {
                returnString = "";
                this.stringsToRemove.add(stripped.substring(0, m.start("wand")));
            } else {
                this.stringsToRemove.add(healthSection);
                returnString = "";
            }
            this.healthLock = false;
            boolean postSetLock = main.getUtils().getAttributes().get((Object)Attribute.MAX_HEALTH).getValue().floatValue() != maxHealth || (double)(Math.abs(main.getUtils().getAttributes().get((Object)Attribute.HEALTH).getValue().floatValue() - newHealth) / maxHealth) > 0.05;
            this.setAttribute(Attribute.HEALTH, newHealth);
            this.setAttribute(Attribute.MAX_HEALTH, maxHealth);
            this.healthLock = postSetLock;
        }
        return returnString;
    }

    private String parseMana(String manaSection) {
        Matcher m = MANA_PATTERN_S.matcher(TextUtils.stripColor(manaSection).trim());
        if (m.matches()) {
            this.setAttribute(Attribute.MANA, this.parseFloat(m.group("num")));
            this.setAttribute(Attribute.MAX_MANA, this.parseFloat(m.group("den")));
            float overflowMana = 0.0f;
            if (m.group("overflow") != null) {
                overflowMana = this.parseFloat(m.group("overflow"));
            }
            this.setAttribute(Attribute.OVERFLOW_MANA, overflowMana);
            main.getRenderListener().setPredictMana(false);
            if (main.getConfigValues().isEnabled(Feature.MANA_BAR) || main.getConfigValues().isEnabled(Feature.MANA_TEXT)) {
                return null;
            }
        }
        return manaSection;
    }

    private String parseDefense(String defenseSection) {
        String stripped = TextUtils.stripColor(defenseSection);
        Matcher m = DEFENSE_PATTERN_S.matcher(stripped);
        if (m.matches()) {
            float defense = this.parseFloat(m.group("defense"));
            this.setAttribute(Attribute.DEFENCE, defense);
            this.otherDefense = TextUtils.getFormattedString(defenseSection, m.group("other").trim());
            if (main.getConfigValues().isEnabled(Feature.DEFENCE_TEXT) || main.getConfigValues().isEnabled(Feature.DEFENCE_PERCENTAGE)) {
                return null;
            }
        }
        return defenseSection;
    }

    private String parseSkill(String skillSection) throws ParseException {
        if (main.getConfigValues().isEnabled(Feature.SKILL_DISPLAY) || main.getConfigValues().isEnabled(Feature.SKILL_PROGRESS_BAR)) {
            Matcher matcher = SKILL_GAIN_PATTERN_S.matcher(TextUtils.stripColor(skillSection));
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            StringBuilder skillTextBuilder = new StringBuilder();
            SkillType skillType = null;
            nf.setMaximumFractionDigits(2);
            if (this.lastParsedSkillSection.equals(skillSection)) {
                skillTextBuilder.append(this.lastSkillProgressString);
                skillType = this.lastSkillType;
            } else if (matcher.matches()) {
                if (main.getConfigValues().isEnabled(Feature.SHOW_SKILL_XP_GAINED)) {
                    skillTextBuilder.append("+").append(matcher.group("gained"));
                }
                skillType = SkillType.getFromString(matcher.group("skillName"));
                boolean skillPercent = matcher.group("percent") != null;
                boolean parseCurrAndTotal = true;
                if (skillPercent) {
                    this.percent = nf.parse(matcher.group("percent")).floatValue();
                    int skillLevel = main.getSkillXpManager().getSkillLevel(skillType);
                    if (skillLevel != -1) {
                        this.totalSkillXP = main.getSkillXpManager().getSkillXpForNextLevel(skillType, skillLevel);
                        this.currentSkillXP = (float)this.totalSkillXP * this.percent / 100.0f;
                    } else {
                        parseCurrAndTotal = false;
                    }
                } else {
                    this.currentSkillXP = nf.parse(matcher.group("current")).floatValue();
                    this.totalSkillXP = nf.parse(matcher.group("total")).intValue();
                    this.percent = this.totalSkillXP == 0 ? 100.0f : 100.0f * this.currentSkillXP / (float)this.totalSkillXP;
                }
                this.percent = Math.min(100.0f, this.percent);
                if (!parseCurrAndTotal || main.getConfigValues().isEnabled(Feature.SHOW_SKILL_PERCENTAGE_INSTEAD_OF_XP)) {
                    skillTextBuilder.append(" (").append(String.format("%.2f", Float.valueOf(this.percent))).append("%)");
                } else {
                    skillTextBuilder.append(" (").append(nf.format(this.currentSkillXP));
                    if (this.totalSkillXP != 0) {
                        skillTextBuilder.append("/");
                        if (main.getConfigValues().isEnabled(Feature.ABBREVIATE_SKILL_XP_DENOMINATOR)) {
                            skillTextBuilder.append(TextUtils.abbreviate(this.totalSkillXP));
                        } else {
                            skillTextBuilder.append(nf.format(this.totalSkillXP));
                        }
                    }
                    skillTextBuilder.append(")");
                }
                if (parseCurrAndTotal && main.getConfigValues().isEnabled(Feature.SKILL_ACTIONS_LEFT_UNTIL_NEXT_LEVEL)) {
                    float gained = nf.parse(matcher.group("gained")).floatValue();
                    skillTextBuilder.append(" - ");
                    if (this.percent != 100.0f) {
                        if (gained != 0.0f) {
                            skillTextBuilder.append(Translations.getMessage("messages.actionsLeft", (int)Math.ceil(((float)this.totalSkillXP - this.currentSkillXP) / gained)));
                        } else {
                            skillTextBuilder.append(Translations.getMessage("messages.actionsLeft", "\u221e"));
                        }
                    }
                }
                this.lastParsedSkillSection = skillSection;
                this.lastSkillProgressString = skillTextBuilder.toString();
                this.lastSkillType = skillType;
            }
            if (skillTextBuilder.length() != 0) {
                main.getRenderListener().setSkillText(skillTextBuilder.toString());
                main.getRenderListener().setSkill(skillType);
                main.getRenderListener().setSkillFadeOutTime(System.currentTimeMillis() + 4000L);
                if (main.getConfigValues().isEnabled(Feature.SKILL_DISPLAY)) {
                    return null;
                }
            }
        }
        return skillSection;
    }

    private String parseTickers(String tickerSection) {
        this.tickers = 0;
        this.maxTickers = 0;
        boolean hitUnusables = false;
        for (char character : tickerSection.toCharArray()) {
            if (!(hitUnusables || character != '7' && character != '2' && character != '6')) {
                hitUnusables = true;
                continue;
            }
            if (character != '\u24c4' && character != '\u24e9') continue;
            if (!hitUnusables) {
                ++this.tickers;
            }
            ++this.maxTickers;
        }
        if (main.getConfigValues().isEnabled(Feature.TICKER_CHARGES_DISPLAY)) {
            return null;
        }
        return tickerSection;
    }

    private String parseDrill(String drillSection, String[] splitStats) {
        int fuel = Math.max(0, Integer.parseInt(splitStats[0]));
        int maxFuel = Math.max(1, Integer.parseInt(splitStats[1]));
        this.setAttribute(Attribute.FUEL, fuel);
        this.setAttribute(Attribute.MAX_FUEL, maxFuel);
        if (main.getConfigValues().isEnabled(Feature.DRILL_FUEL_BAR) || main.getConfigValues().isEnabled(Feature.DRILL_FUEL_TEXT)) {
            return null;
        }
        return drillSection;
    }

    private float parseFloat(String string) {
        try {
            return TextUtils.NUMBER_FORMAT.parse(string).floatValue();
        }
        catch (ParseException e) {
            return -1.0f;
        }
    }

    private void setAttribute(Attribute attribute, float value) {
        if (attribute == Attribute.HEALTH && this.healthLock) {
            return;
        }
        main.getUtils().getAttributes().get((Object)attribute).setValue(value);
    }

    public int getTickers() {
        return this.tickers;
    }

    public int getMaxTickers() {
        return this.maxTickers;
    }

    public float getLastSecondHealth() {
        return this.lastSecondHealth;
    }

    public Float getHealthUpdate() {
        return this.healthUpdate;
    }

    public long getLastHealthUpdate() {
        return this.lastHealthUpdate;
    }

    public float getCurrentSkillXP() {
        return this.currentSkillXP;
    }

    public int getTotalSkillXP() {
        return this.totalSkillXP;
    }

    public float getPercent() {
        return this.percent;
    }

    public boolean isHealthLock() {
        return this.healthLock;
    }

    public String getOtherDefense() {
        return this.otherDefense;
    }

    public String getLastParsedSkillSection() {
        return this.lastParsedSkillSection;
    }

    public String getLastSkillProgressString() {
        return this.lastSkillProgressString;
    }

    public SkillType getLastSkillType() {
        return this.lastSkillType;
    }

    public LinkedList<String> getStringsToRemove() {
        return this.stringsToRemove;
    }

    public void setLastSecondHealth(float lastSecondHealth) {
        this.lastSecondHealth = lastSecondHealth;
    }

    public void setHealthUpdate(Float healthUpdate) {
        this.healthUpdate = healthUpdate;
    }

    public void setLastHealthUpdate(long lastHealthUpdate) {
        this.lastHealthUpdate = lastHealthUpdate;
    }
}

