/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.listeners;

import codes.biscuit.skyblockaddons.SkyblockAddons;
import codes.biscuit.skyblockaddons.asm.hooks.GuiChestHook;
import codes.biscuit.skyblockaddons.core.Feature;
import codes.biscuit.skyblockaddons.core.InventoryType;
import codes.biscuit.skyblockaddons.core.Translations;
import codes.biscuit.skyblockaddons.events.InventoryLoadingDoneEvent;
import codes.biscuit.skyblockaddons.features.backpacks.ContainerPreviewManager;
import codes.biscuit.skyblockaddons.features.dungeonmap.DungeonMapManager;
import codes.biscuit.skyblockaddons.gui.LocationEditGui;
import codes.biscuit.skyblockaddons.listeners.InventoryChangeListener;
import codes.biscuit.skyblockaddons.misc.scheduler.ScheduledTask;
import codes.biscuit.skyblockaddons.misc.scheduler.SkyblockRunnable;
import codes.biscuit.skyblockaddons.utils.ColorCode;
import codes.biscuit.skyblockaddons.utils.DevUtils;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiScreenListener {
    private final SkyblockAddons main = SkyblockAddons.getInstance();
    private InventoryChangeListener inventoryChangeListener;
    private InventoryBasic listenedInventory;
    private ScheduledTask inventoryChangeTimeCheckTask;
    private long lastContainerCloseMs = -1L;
    private long lastBackpackOpenMs = -1L;
    private long lastInventoryChangeMs = -1L;

    @SubscribeEvent
    public void beforeInit(GuiScreenEvent.InitGuiEvent.Pre e) {
        if (!this.main.getUtils().isOnSkyblock()) {
            return;
        }
        GuiScreen guiScreen = e.gui;
        if (guiScreen instanceof GuiChest) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiChest guiChest = (GuiChest)guiScreen;
            InventoryType inventoryType = SkyblockAddons.getInstance().getInventoryUtils().updateInventoryType(guiChest);
            InventoryBasic chestInventory = (InventoryBasic)guiChest.field_147015_w;
            this.addInventoryChangeListener(chestInventory);
            if (this.main.getConfigValues().isEnabled(Feature.BACKPACK_OPENING_SOUND) && chestInventory.func_145818_k_() && chestInventory.func_145748_c_().func_150260_c().contains("Backpack")) {
                this.lastBackpackOpenMs = System.currentTimeMillis();
                if (ThreadLocalRandom.current().nextInt(0, 2) == 0) {
                    mc.field_71439_g.func_85030_a("mob.horse.armor", 0.5f, 1.0f);
                } else {
                    mc.field_71439_g.func_85030_a("mob.horse.leather", 0.5f, 1.0f);
                }
            }
            if (this.main.getConfigValues().isEnabled(Feature.SHOW_BACKPACK_PREVIEW) && (inventoryType == InventoryType.STORAGE_BACKPACK || inventoryType == InventoryType.ENDER_CHEST)) {
                ContainerPreviewManager.onContainerOpen(chestInventory);
            }
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent e) {
        if (!this.main.getUtils().isOnSkyblock()) {
            return;
        }
        GuiScreen guiScreen = e.gui;
        GuiScreen oldGuiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen == null && oldGuiScreen instanceof GuiContainer) {
            this.lastContainerCloseMs = System.currentTimeMillis();
        }
        if (oldGuiScreen instanceof GuiChest) {
            if (this.inventoryChangeListener != null) {
                this.removeInventoryChangeListener(this.listenedInventory);
            }
            ContainerPreviewManager.onContainerClose();
            GuiChestHook.onGuiClosed();
        }
    }

    @SubscribeEvent
    public void onKeyInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        Slot currentSlot;
        GuiScreen currentScreen;
        int eventKey = Keyboard.getEventKey();
        if (this.main.getConfigValues().isEnabled(Feature.DEVELOPER_MODE) && eventKey == this.main.getDeveloperCopyNBTKey().getKeyCode() && Keyboard.getEventKeyState() && GuiContainer.class.isAssignableFrom((currentScreen = event.gui).getClass()) && (currentSlot = ((GuiContainer)currentScreen).getSlotUnderMouse()) != null && currentSlot.func_75216_d()) {
            DevUtils.copyNBTTagToClipboard((NBTBase)currentSlot.func_75211_c().serializeNBT(), (Object)((Object)ColorCode.GREEN) + "Item data was copied to clipboard!");
        }
        if (this.main.getConfigValues().isEnabled(Feature.DUNGEONS_MAP_DISPLAY) && this.main.getConfigValues().isEnabled(Feature.CHANGE_DUNGEON_MAP_ZOOM_WITH_KEYBOARD) && Minecraft.func_71410_x().field_71462_r instanceof LocationEditGui) {
            if (Keyboard.isKeyDown((int)this.main.getKeyBindings().get(5).getKeyCode()) && Keyboard.getEventKeyState()) {
                DungeonMapManager.decreaseZoomByStep();
            } else if (Keyboard.isKeyDown((int)this.main.getKeyBindings().get(4).getKeyCode()) && Keyboard.getEventKeyState()) {
                DungeonMapManager.increaseZoomByStep();
            }
        }
    }

    @SubscribeEvent
    public void onInventoryLoadingDone(InventoryLoadingDoneEvent e) {
        this.removeInventoryChangeListener(this.listenedInventory);
        this.lastInventoryChangeMs = -1L;
    }

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!this.main.getUtils().isOnSkyblock()) {
            return;
        }
        int eventButton = Mouse.getEventButton();
        if (!Mouse.getEventButtonState()) {
            return;
        }
        if (this.main.getConfigValues().isEnabled(Feature.LOCK_SLOTS) && event.gui instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)event.gui;
            if (eventButton >= 0) {
                for (int i = 0; i < 9; ++i) {
                    if (eventButton - 100 != Minecraft.func_71410_x().field_71474_y.field_151456_ac[i].func_151463_i()) continue;
                    Slot slot = guiContainer.getSlotUnderMouse();
                    Slot hotbarSlot = guiContainer.field_147002_h.func_75139_a(guiContainer.field_147002_h.field_75151_b.size() - (9 - i));
                    if (slot == null || hotbarSlot == null) {
                        return;
                    }
                    if (!this.main.getConfigValues().getLockedSlots().contains(i + 36)) continue;
                    if (!slot.func_75216_d() && !hotbarSlot.func_75216_d()) {
                        return;
                    }
                    this.main.getUtils().playLoudSound("note.bass", 0.5);
                    this.main.getUtils().sendMessage((Object)((Object)this.main.getConfigValues().getRestrictedColor(Feature.DROP_CONFIRMATION)) + Translations.getMessage("messages.slotLocked", new Object[0]));
                    event.setCanceled(true);
                }
            }
        }
    }

    void onInventoryChanged(InventoryBasic inventory) {
        long currentTimeMs = System.currentTimeMillis();
        if (inventory.func_70301_a(inventory.func_70302_i_() - 1) != null) {
            MinecraftForge.EVENT_BUS.post((Event)new InventoryLoadingDoneEvent());
        } else {
            this.lastInventoryChangeMs = currentTimeMs;
        }
    }

    private void addInventoryChangeListener(InventoryBasic inventory) {
        if (inventory == null) {
            throw new NullPointerException("Tried to add listener to null inventory.");
        }
        this.lastInventoryChangeMs = System.currentTimeMillis();
        this.inventoryChangeListener = new InventoryChangeListener(this);
        inventory.func_110134_a((IInvBasic)this.inventoryChangeListener);
        this.listenedInventory = inventory;
        this.inventoryChangeTimeCheckTask = this.main.getNewScheduler().scheduleRepeatingTask(new SkyblockRunnable(){

            @Override
            public void run() {
                GuiScreenListener.this.checkLastInventoryChangeTime();
            }
        }, 20, 5);
    }

    private void checkLastInventoryChangeTime() {
        if (this.listenedInventory != null && this.lastInventoryChangeMs > -1L && System.currentTimeMillis() - this.lastInventoryChangeMs > 1000L) {
            MinecraftForge.EVENT_BUS.post((Event)new InventoryLoadingDoneEvent());
        }
    }

    private void removeInventoryChangeListener(InventoryBasic inventory) {
        if (inventory == null) {
            throw new NullPointerException("Tried to remove listener from null inventory.");
        }
        if (this.inventoryChangeListener != null) {
            try {
                inventory.func_110132_b((IInvBasic)this.inventoryChangeListener);
            }
            catch (NullPointerException e) {
                SkyblockAddons.getInstance().getUtils().sendErrorMessage("Tried to remove an inventory listener from a container that has no listeners.");
            }
            if (this.inventoryChangeTimeCheckTask != null && !this.inventoryChangeTimeCheckTask.isCanceled()) {
                this.inventoryChangeTimeCheckTask.cancel();
            }
            this.inventoryChangeListener = null;
            this.listenedInventory = null;
            this.inventoryChangeTimeCheckTask = null;
        }
    }

    public long getLastContainerCloseMs() {
        return this.lastContainerCloseMs;
    }

    public long getLastBackpackOpenMs() {
        return this.lastBackpackOpenMs;
    }
}

