/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.features.discordrpc;

import codes.biscuit.skyblockaddons.SkyblockAddons;
import codes.biscuit.skyblockaddons.core.Attribute;
import codes.biscuit.skyblockaddons.core.Location;
import codes.biscuit.skyblockaddons.core.SkyblockDate;
import codes.biscuit.skyblockaddons.core.Translations;
import codes.biscuit.skyblockaddons.gui.buttons.ButtonSelect;
import codes.biscuit.skyblockaddons.utils.EnumUtils;
import codes.biscuit.skyblockaddons.utils.TextUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;

public enum DiscordStatus implements ButtonSelect.SelectItem
{
    NONE("discordStatus.titleNone", "discordStatus.descriptionNone", () -> null),
    LOCATION("discordStatus.titleLocation", "discordStatus.descriptionLocation", () -> {
        Location location = SkyblockAddons.getInstance().getUtils().getLocation();
        if (location == Location.ISLAND) {
            return "Private Island";
        }
        return location.getScoreboardName();
    }),
    PURSE("discordStatus.titlePurse", "discordStatus.descriptionPurse", () -> {
        double coins = SkyblockAddons.getInstance().getUtils().getPurse();
        String coinString = " Coin";
        if (coins == 1.0) {
            return TextUtils.formatDouble(coins) + coinString;
        }
        return TextUtils.formatDouble(coins) + coinString + 's';
    }),
    BITS("discordStatus.titleBits", "discordStatus.descriptionBits", () -> {
        double bits = SkyblockAddons.getInstance().getUtils().getBits();
        String bitString = " Bit";
        if (bits == 1.0) {
            return TextUtils.formatDouble(bits) + bitString;
        }
        return TextUtils.formatDouble(bits) + bitString + 's';
    }),
    STATS("discordStatus.titleStats", "discordStatus.descriptionStats", () -> {
        float health = SkyblockAddons.getInstance().getUtils().getAttributes().get((Object)Attribute.HEALTH).getValue().floatValue();
        float defense = SkyblockAddons.getInstance().getUtils().getAttributes().get((Object)Attribute.DEFENCE).getValue().floatValue();
        float mana = SkyblockAddons.getInstance().getUtils().getAttributes().get((Object)Attribute.MANA).getValue().floatValue();
        return String.format("%.2f H - %.2f D - %.2f M", Float.valueOf(health), Float.valueOf(defense), Float.valueOf(mana));
    }),
    ZEALOTS("discordStatus.titleZealots", "discordStatus.descriptionZealots", () -> String.format("%d Zealots killed", SkyblockAddons.getInstance().getPersistentValuesManager().getPersistentValues().getKills())),
    ITEM("discordStatus.titleItem", "discordStatus.descriptionItem", () -> {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_70694_bm() != null) {
            return String.format("Holding %s", TextUtils.stripColor(player.func_70694_bm().func_82833_r()));
        }
        return "No item in hand";
    }),
    TIME("discordStatus.titleTime", "discordStatus.descriptionTime", () -> {
        SkyblockDate date = SkyblockAddons.getInstance().getUtils().getCurrentDate();
        return date != null ? date.toString() : "";
    }),
    PROFILE("discordStatus.titleProfile", "discordStatus.descriptionProfile", () -> {
        String profile = SkyblockAddons.getInstance().getUtils().getProfileName();
        return String.format("Profile: %s", profile == null ? "None" : profile);
    }),
    CUSTOM("discordStatus.titleCustom", "discordStatus.descriptionCustom", () -> {
        SkyblockAddons main = SkyblockAddons.getInstance();
        String text = main.getConfigValues().getCustomStatus(main.getDiscordRPCManager().getCurrentEntry());
        return text.substring(0, Math.min(text.length(), 100));
    }),
    AUTO_STATUS("discordStatus.titleAuto", "discordStatus.descriptionAuto", () -> {
        SkyblockAddons main = SkyblockAddons.getInstance();
        Location location = main.getUtils().getLocation();
        if (location == Location.THE_END || location == Location.DRAGONS_NEST) {
            return DiscordStatus.ZEALOTS.displayMessageSupplier.get();
        }
        EnumUtils.SlayerQuest slayerQuest = main.getUtils().getSlayerQuest();
        if (slayerQuest != null) {
            if (slayerQuest == EnumUtils.SlayerQuest.REVENANT_HORROR) {
                return DiscordStatus.valueOf((String)"REVENANT").displayMessageSupplier.get();
            }
            if (slayerQuest == EnumUtils.SlayerQuest.SVEN_PACKMASTER) {
                return DiscordStatus.valueOf((String)"SVEN").displayMessageSupplier.get();
            }
            if (slayerQuest == EnumUtils.SlayerQuest.TARANTULA_BROODFATHER) {
                return DiscordStatus.valueOf((String)"TARANTULA").displayMessageSupplier.get();
            }
        }
        if ("AUTO_STATUS".equals(main.getConfigValues().getDiscordAutoDefault().name())) {
            main.getConfigValues().setDiscordAutoDefault(NONE);
        }
        return main.getConfigValues().getDiscordAutoDefault().displayMessageSupplier.get();
    }),
    REVENANT("discordStatus.titleRevenants", "discordStatus.descriptionRevenants", () -> {
        SkyblockAddons main = SkyblockAddons.getInstance();
        boolean bossAlive = main.getUtils().isSlayerBossAlive();
        if (bossAlive) {
            return "Slaying a Revenant Horror " + main.getUtils().getSlayerQuestLevel() + " boss.";
        }
        return "Doing a Revenant Horror " + main.getUtils().getSlayerQuestLevel() + " quest.";
    }),
    SVEN("discordStatus.titleSvens", "discordStatus.descriptionSvens", () -> {
        SkyblockAddons main = SkyblockAddons.getInstance();
        boolean bossAlive = main.getUtils().isSlayerBossAlive();
        if (bossAlive) {
            return "Slaying a Sven Packmaster " + main.getUtils().getSlayerQuestLevel() + " boss.";
        }
        return "Doing a Sven Packmaster " + main.getUtils().getSlayerQuestLevel() + " quest.";
    }),
    TARANTULA("discordStatus.titleTarantula", "discordStatus.descriptionTarantula", () -> {
        SkyblockAddons main = SkyblockAddons.getInstance();
        boolean bossAlive = main.getUtils().isSlayerBossAlive();
        if (bossAlive) {
            return "Slaying a Tarantula Broodfather  " + main.getUtils().getSlayerQuestLevel() + " boss.";
        }
        return "Doing a Tarantula Broodfather " + main.getUtils().getSlayerQuestLevel() + " quest.";
    }),
    VOIDGLOOM("discordStatus.titleVoidgloom", "discordStatus.descriptionVoidgloom", () -> {
        SkyblockAddons main = SkyblockAddons.getInstance();
        boolean bossAlive = main.getUtils().isSlayerBossAlive();
        if (bossAlive) {
            return "Slaying a Voidgloom Seraph  " + main.getUtils().getSlayerQuestLevel() + " boss.";
        }
        return "Doing a Voidgloom Seraph " + main.getUtils().getSlayerQuestLevel() + " quest.";
    }),
    INFERNO("discordStatus.titleInferno", "discordStatus.descriptionInferno", () -> {
        SkyblockAddons main = SkyblockAddons.getInstance();
        boolean bossAlive = main.getUtils().isSlayerBossAlive();
        if (bossAlive) {
            return "Slaying a Inferno Demonlord  " + main.getUtils().getSlayerQuestLevel() + " boss.";
        }
        return "Doing a Inferno Demonlord " + main.getUtils().getSlayerQuestLevel() + " quest.";
    });

    private final String title;
    private final String description;
    private final Supplier<String> displayMessageSupplier;

    private DiscordStatus(String titleTranslationKey, String descriptionTranslationKey, Supplier<String> displayMessageSupplier) {
        this.title = Translations.getMessage(titleTranslationKey, new Object[0]);
        this.description = Translations.getMessage(descriptionTranslationKey, new Object[0]);
        this.displayMessageSupplier = displayMessageSupplier;
    }

    public String getDisplayString(EnumUtils.DiscordStatusEntry currentEntry) {
        SkyblockAddons.getInstance().getDiscordRPCManager().setCurrentEntry(currentEntry);
        return this.displayMessageSupplier.get();
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

