/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.exceptions;

import com.google.common.base.Throwables;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;

public class LoadingException
extends CustomModLoadingErrorDisplayException {
    private final boolean DRAW_ROOT_CAUSE;
    private String rootCauseString;
    private int maxWidth;
    private int xCenter;
    private int yStart;

    public LoadingException(String message, Throwable cause, boolean drawRootCause) {
        super(message, cause);
        this.DRAW_ROOT_CAUSE = drawRootCause;
        if (this.DRAW_ROOT_CAUSE) {
            this.rootCauseString = Throwables.getRootCause((Throwable)((Object)this)).toString();
        }
    }

    public LoadingException(String message, Throwable cause) {
        this(message, cause, false);
    }

    public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
        this.maxWidth = errorScreen.field_146294_l - 80;
        this.yStart = 50;
        this.xCenter = errorScreen.field_146294_l / 2;
    }

    public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
        int yPos = this.yStart;
        errorScreen.func_73732_a(fontRenderer, String.format("%sSkyblockAddons%s has encountered an error while loading.", EnumChatFormatting.AQUA, EnumChatFormatting.RESET), this.xCenter, yPos, 0xFFFFFF);
        yPos += 20;
        if (this.getMessage() != null) {
            for (String errorLine : fontRenderer.func_78271_c(this.getMessage(), this.maxWidth)) {
                errorScreen.func_73732_a(fontRenderer, errorLine, this.xCenter, yPos, 0xFFFFFF);
                yPos += 10;
            }
        }
        if (this.DRAW_ROOT_CAUSE) {
            errorScreen.func_73732_a(fontRenderer, "Cause:", this.xCenter, yPos += 10, 0xFFFFFF);
            errorScreen.func_73732_a(fontRenderer, this.rootCauseString, this.xCenter, yPos += 10, 0xFFFFFF);
        }
        errorScreen.func_73732_a(fontRenderer, "Please restart your game.", this.xCenter, yPos += 30, 0xFFFFFF);
        yPos += 10;
        List errorPersistString = fontRenderer.func_78271_c(String.format("If error persists after restarting, please report it at %shttps://discord.gg/zWyr3f5GXz.%s", EnumChatFormatting.BOLD, EnumChatFormatting.RESET), this.maxWidth);
        for (String line : errorPersistString) {
            errorScreen.func_73732_a(fontRenderer, line, this.xCenter, yPos, 0xFFFFFF);
            yPos += 10;
        }
    }
}

