/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.core.seacreatures;

import codes.biscuit.skyblockaddons.core.ItemRarity;
import codes.biscuit.skyblockaddons.core.seacreatures.SeaCreature;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SeaCreatureManager {
    private static final SeaCreatureManager INSTANCE = new SeaCreatureManager();
    private final Set<String> allSeaCreatureSpawnMessages = new HashSet<String>();
    private final Set<String> legendarySeaCreatureSpawnMessages = new HashSet<String>();

    public void setSeaCreatures(Map<String, SeaCreature> seaCreatures) {
        this.allSeaCreatureSpawnMessages.clear();
        this.legendarySeaCreatureSpawnMessages.clear();
        for (SeaCreature sc : seaCreatures.values()) {
            this.allSeaCreatureSpawnMessages.add(sc.getSpawnMessage());
            if (sc.getRarity().compareTo(ItemRarity.LEGENDARY) < 0) continue;
            this.legendarySeaCreatureSpawnMessages.add(sc.getSpawnMessage());
        }
    }

    public static SeaCreatureManager getInstance() {
        return INSTANCE;
    }

    public Set<String> getAllSeaCreatureSpawnMessages() {
        return this.allSeaCreatureSpawnMessages;
    }

    public Set<String> getLegendarySeaCreatureSpawnMessages() {
        return this.legendarySeaCreatureSpawnMessages;
    }
}

