/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.minecraft.item.ItemStack;

public class SkytilsCompat {
    public static boolean isSkytilsFullyLoaded() {
        return Holder.isSkytilsFullyPresent;
    }

    public static boolean isSkytilsPresent() {
        return Holder.isSkytilsPresent;
    }

    public static void renderSkytilsRarity(ItemStack stack, int x, int y) {
        SkytilsCompat.renderSkytilsRarity(stack, x, y, false);
    }

    public static void renderSkytilsRarity(ItemStack stack, int x, int y, boolean force) {
        if (Holder.isSkytilsFullyPresent) {
            try {
                if (force || ((Boolean)Holder.skytilsGetShowItemRarity.invoke(Holder.skytilsConfigObject, new Object[0])).booleanValue()) {
                    Holder.renderRarityMethod.invoke(null, stack, x, y);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static class Holder {
        static boolean isSkytilsPresent = false;
        static boolean isSkytilsFullyPresent = false;
        static Class<?> skytilsClass = null;
        static Method renderRarityMethod = null;
        static Class<?> renderUtilClass = null;
        static Object skytilsCompanionObject = null;
        static Class<?> skytilsConfigClass = null;
        static Object skytilsConfigObject = null;
        static Method skytilsGetShowItemRarity = null;

        private Holder() {
        }

        static {
            Throwable exception = null;
            for (String packageStart : Arrays.asList("gg.skytils", "skytils")) {
                isSkytilsPresent = false;
                try {
                    skytilsClass = Class.forName(packageStart + ".skytilsmod.Skytils");
                    isSkytilsPresent = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (!isSkytilsPresent) continue;
                try {
                    Class<?> skytilsCompanionClass = Class.forName(packageStart + ".skytilsmod.Skytils$Companion");
                    skytilsConfigClass = Class.forName(packageStart + ".skytilsmod.core.Config");
                    Field skytilsCompanionField = skytilsClass.getField("Companion");
                    skytilsCompanionObject = skytilsCompanionField.get(null);
                    Method skytilsGetConfigMethod = skytilsCompanionClass.getMethod("getConfig", new Class[0]);
                    skytilsConfigObject = skytilsGetConfigMethod.invoke(skytilsCompanionObject, new Object[0]);
                    skytilsGetShowItemRarity = skytilsConfigClass.getMethod("getShowItemRarity", new Class[0]);
                    renderUtilClass = Class.forName(packageStart + ".skytilsmod.utils.RenderUtil");
                    renderRarityMethod = renderUtilClass.getDeclaredMethod("renderRarity", ItemStack.class, Integer.TYPE, Integer.TYPE);
                    isSkytilsFullyPresent = true;
                    break;
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e2) {
                    exception = e2;
                }
            }
            if (!isSkytilsFullyPresent && exception != null) {
                System.err.println("Failed to get Skytils class even tho Skytils mod is present. This is (probably) a NEU bug");
                exception.printStackTrace();
            }
        }
    }
}

