/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import java.util.HashMap;
import java.util.function.Consumer;

public class ProfileApiSyncer {
    private static final ProfileApiSyncer INSTANCE = new ProfileApiSyncer();
    private final HashMap<String, Long> resyncTimes = new HashMap();
    private final HashMap<String, Runnable> syncingCallbacks = new HashMap();
    private final HashMap<String, Consumer<SkyblockProfiles>> finishSyncCallbacks = new HashMap();
    private long lastResync;

    public static ProfileApiSyncer getInstance() {
        return INSTANCE;
    }

    public void requestResync(String id, long timeBetween) {
        this.requestResync(id, timeBetween, null);
    }

    public void requestResync(String id, long timeBetween, Runnable syncingCallback) {
        this.requestResync(id, timeBetween, null, null);
    }

    public void requestResync(String id, long timeBetween, Runnable syncingCallback, Consumer<SkyblockProfiles> finishSyncCallback) {
        this.resyncTimes.put(id, timeBetween);
        this.syncingCallbacks.put(id, syncingCallback);
        this.finishSyncCallbacks.put(id, finishSyncCallback);
    }

    public long getCurrentResyncTime() {
        long time = -1L;
        for (long l : this.resyncTimes.values()) {
            if (l <= 0L || l >= time && time != -1L) continue;
            time = l;
        }
        return time;
    }
}

