/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;

public abstract class LateBindingChroma {
    private static final Pattern FORMATTING_CODE = Pattern.compile("\u00a7(.)");

    public static LateBindingChroma of(String raw) {
        if (!raw.contains("\u00a7z")) {
            return new WithoutChroma(raw);
        }
        Matcher matcher = FORMATTING_CODE.matcher(raw);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        StringBuffer sb = new StringBuffer();
        String color = "";
        String extraFormatting = "";
        while (matcher.find()) {
            sb.setLength(0);
            matcher.appendReplacement(sb, "");
            chunks.add(new Chunk(color, extraFormatting, sb.toString()));
            String c = matcher.group(1);
            if ("lnomk".contains(c)) {
                extraFormatting = extraFormatting + "\u00a7" + c;
                continue;
            }
            color = c;
            extraFormatting = "";
        }
        sb.setLength(0);
        matcher.appendTail(sb);
        chunks.add(new Chunk(color, extraFormatting, sb.toString()));
        chunks.removeIf(it -> ((Chunk)it).text.isEmpty());
        return new WithChroma(chunks);
    }

    public abstract String render(float var1);

    public static final class Chunk {
        private final String color;
        private final String extraFormatting;
        private final String text;

        public Chunk(String color, String extraFormatting, String text) {
            this.color = color;
            this.extraFormatting = extraFormatting;
            this.text = text;
        }

        public String getColor() {
            return this.color;
        }

        public String getExtraFormatting() {
            return this.extraFormatting;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Chunk)) {
                return false;
            }
            Chunk other = (Chunk)o;
            String this$color = this.getColor();
            String other$color = other.getColor();
            if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
                return false;
            }
            String this$extraFormatting = this.getExtraFormatting();
            String other$extraFormatting = other.getExtraFormatting();
            if (this$extraFormatting == null ? other$extraFormatting != null : !this$extraFormatting.equals(other$extraFormatting)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $color = this.getColor();
            result2 = result2 * 59 + ($color == null ? 43 : $color.hashCode());
            String $extraFormatting = this.getExtraFormatting();
            result2 = result2 * 59 + ($extraFormatting == null ? 43 : $extraFormatting.hashCode());
            String $text = this.getText();
            result2 = result2 * 59 + ($text == null ? 43 : $text.hashCode());
            return result2;
        }

        public String toString() {
            return "LateBindingChroma.Chunk(color=" + this.getColor() + ", extraFormatting=" + this.getExtraFormatting() + ", text=" + this.getText() + ")";
        }
    }

    static final class WithChroma
    extends LateBindingChroma {
        private final List<Chunk> chunks;

        @Override
        public String render(float offset) {
            StringBuilder sb = new StringBuilder();
            for (Chunk chunk : this.chunks) {
                String text = chunk.color.equals("z") ? Utils.chromaString(chunk.text, offset, chunk.extraFormatting) : (chunk.color.isEmpty() ? "" : "\u00a7" + chunk.color) + chunk.extraFormatting + chunk.text;
                sb.append(text);
                offset += (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
            }
            return sb.toString();
        }

        public WithChroma(List<Chunk> chunks) {
            this.chunks = chunks;
        }

        public List<Chunk> getChunks() {
            return this.chunks;
        }

        public String toString() {
            return "LateBindingChroma.WithChroma(chunks=" + this.getChunks() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithChroma)) {
                return false;
            }
            WithChroma other = (WithChroma)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Chunk> this$chunks = this.getChunks();
            List<Chunk> other$chunks = other.getChunks();
            return !(this$chunks == null ? other$chunks != null : !((Object)this$chunks).equals(other$chunks));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WithChroma;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            List<Chunk> $chunks = this.getChunks();
            result2 = result2 * 59 + ($chunks == null ? 43 : ((Object)$chunks).hashCode());
            return result2;
        }
    }

    static final class WithoutChroma
    extends LateBindingChroma {
        private final String content;

        @Override
        public String render(float chromaOffset) {
            return this.content;
        }

        public WithoutChroma(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public String toString() {
            return "LateBindingChroma.WithoutChroma(content=" + this.getContent() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithoutChroma)) {
                return false;
            }
            WithoutChroma other = (WithoutChroma)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WithoutChroma;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $content = this.getContent();
            result2 = result2 * 59 + ($content == null ? 43 : $content.hashCode());
            return result2;
        }
    }
}

