/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;

public class Calculator {
    static String binops = "+-*/^x";
    static String postops = "mkbts%";
    static String digits = "0123456789";
    static String nameCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_";

    public static DecimalFormat getDecimalFormat() {
        StringBuilder f = new StringBuilder("#,##0.");
        for (int i = 0; i < NotEnoughUpdates.INSTANCE.config.misc.calculationPrecision; ++i) {
            f.append("#");
        }
        return new DecimalFormat(f.toString());
    }

    public static BigDecimal calculate(String source, VariableProvider variables) throws CalculatorException {
        return Calculator.evaluate(variables, Calculator.shuntingYard(Calculator.lex(source)));
    }

    public static BigDecimal calculate(String source) throws CalculatorException {
        return Calculator.calculate(source, ignored -> Optional.empty());
    }

    static void readDigitsInto(Token token, String source, boolean decimals) {
        int startIndex = token.tokenStart + token.tokenLength;
        int j = 0;
        while (j + startIndex < source.length()) {
            char d = source.charAt(j + startIndex);
            int d0 = digits.indexOf(d);
            if (d0 != -1) {
                if (decimals) {
                    --token.exponent;
                }
                token.numericValue *= 10L;
                token.numericValue += (long)d0;
                ++token.tokenLength;
            } else {
                return;
            }
            ++j;
        }
    }

    public static List<Token> lex(String source) throws CalculatorException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        boolean doesNotHaveLValue = true;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (Character.isWhitespace(c)) {
                ++i;
                continue;
            }
            Token token = new Token();
            token.tokenStart = i;
            if (doesNotHaveLValue && c == '-') {
                token.tokenLength = 1;
                token.type = TokenType.PREOP;
                token.operatorValue = "-";
            } else if (binops.indexOf(c) != -1) {
                token.tokenLength = 1;
                token.type = TokenType.BINOP;
                token.operatorValue = String.valueOf(c);
                if (c == '*' && i + 1 < source.length() && source.charAt(i + 1) == '*') {
                    ++token.tokenLength;
                    token.operatorValue = "^";
                }
            } else if (postops.indexOf(c) != -1) {
                token.tokenLength = 1;
                token.type = TokenType.POSTOP;
                token.operatorValue = String.valueOf(c).toLowerCase(Locale.ROOT);
            } else if (c == ')') {
                token.tokenLength = 1;
                token.type = TokenType.RPAREN;
                token.operatorValue = ")";
            } else if (c == '(') {
                token.tokenLength = 1;
                token.type = TokenType.LPAREN;
                token.operatorValue = "(";
            } else if ('.' == c || ',' == c) {
                token.tokenLength = 1;
                token.type = TokenType.NUMBER;
                Calculator.readDigitsInto(token, source, true);
                if (token.tokenLength == 1) {
                    throw new CalculatorException("Invalid number literal", i, 1);
                }
            } else if ('$' == c) {
                token.tokenLength = 1;
                token.type = TokenType.VARIABLE;
                token.operatorValue = "";
                boolean inParenthesis = false;
                if (i + 1 < source.length() && source.charAt(i + 1) == '{') {
                    ++token.tokenLength;
                    inParenthesis = true;
                }
                for (int j = token.tokenStart + token.tokenLength; j < source.length(); ++j) {
                    char d = source.charAt(j);
                    if (inParenthesis) {
                        if (d == '}') {
                            ++token.tokenLength;
                            inParenthesis = false;
                            break;
                        }
                    } else if (nameCharacters.indexOf(d) == -1) break;
                    token.operatorValue = token.operatorValue + d;
                    ++token.tokenLength;
                }
                if (token.operatorValue.length() == 0 || inParenthesis) {
                    throw new CalculatorException("Unterminated variable literal", token.tokenStart, token.tokenLength);
                }
            } else if (digits.indexOf(c) != -1) {
                char p;
                token.type = TokenType.NUMBER;
                Calculator.readDigitsInto(token, source, false);
                if (i + token.tokenLength < source.length() && ('.' == (p = source.charAt(i + token.tokenLength)) || ',' == p)) {
                    ++token.tokenLength;
                    Calculator.readDigitsInto(token, source, true);
                }
            } else {
                throw new CalculatorException("Unknown thing " + c, i, 1);
            }
            doesNotHaveLValue = token.type == TokenType.LPAREN || token.type == TokenType.PREOP || token.type == TokenType.BINOP;
            tokens.add(token);
            i += token.tokenLength;
        }
        return tokens;
    }

    static int getPrecedence(Token token) throws CalculatorException {
        switch (token.operatorValue.intern()) {
            case "+": 
            case "-": {
                return 0;
            }
            case "*": 
            case "/": 
            case "x": {
                return 1;
            }
            case "^": {
                return 2;
            }
        }
        throw new CalculatorException("Unknown operator " + token.operatorValue, token.tokenStart, token.tokenLength);
    }

    public static List<Token> shuntingYard(List<Token> toShunt) throws CalculatorException {
        ArrayDeque<Token> op = new ArrayDeque<Token>();
        ArrayList<Token> out = new ArrayList<Token>();
        for (Token currentlyShunting : toShunt) {
            block0 : switch (currentlyShunting.type) {
                case NUMBER: 
                case VARIABLE: {
                    out.add(currentlyShunting);
                    break;
                }
                case BINOP: {
                    Token l;
                    int p = Calculator.getPrecedence(currentlyShunting);
                    while (!op.isEmpty()) {
                        l = (Token)op.peek();
                        if (l.type == TokenType.LPAREN) break;
                        assert (l.type == TokenType.BINOP || l.type == TokenType.PREOP);
                        int pl = Calculator.getPrecedence(l);
                        if (pl < p) break;
                        out.add((Token)op.pop());
                    }
                    op.push(currentlyShunting);
                    break;
                }
                case PREOP: {
                    op.push(currentlyShunting);
                    break;
                }
                case LPAREN: {
                    op.push(currentlyShunting);
                    break;
                }
                case RPAREN: {
                    Token l;
                    while (true) {
                        if (op.isEmpty()) {
                            throw new CalculatorException("Unbalanced right parenthesis", currentlyShunting.tokenStart, currentlyShunting.tokenLength);
                        }
                        l = (Token)op.pop();
                        if (l.type == TokenType.LPAREN) break block0;
                        out.add(l);
                    }
                }
                case POSTOP: {
                    out.add(currentlyShunting);
                }
            }
        }
        while (!op.isEmpty()) {
            Token l = (Token)op.pop();
            if (l.type == TokenType.LPAREN) {
                throw new CalculatorException("Unbalanced left parenthesis", l.tokenStart, l.tokenLength);
            }
            out.add(l);
        }
        return out;
    }

    public static BigDecimal evaluate(VariableProvider provider, List<Token> rpnTokens) throws CalculatorException {
        ArrayDeque<BigDecimal> values = new ArrayDeque<BigDecimal>();
        int precision = NotEnoughUpdates.INSTANCE != null ? NotEnoughUpdates.INSTANCE.config.misc.calculationPrecision : 5;
        try {
            for (Token command2 : rpnTokens) {
                block2 : switch (command2.type) {
                    case VARIABLE: {
                        values.push(provider.provideVariable(command2.operatorValue).orElseThrow(() -> new CalculatorException("Unknown variable " + command2.operatorValue, command2.tokenStart, command2.tokenLength)));
                        break;
                    }
                    case PREOP: {
                        values.push(((BigDecimal)values.pop()).negate());
                        break;
                    }
                    case NUMBER: {
                        values.push(new BigDecimal(command2.numericValue).scaleByPowerOfTen(command2.exponent));
                        break;
                    }
                    case BINOP: {
                        BigDecimal right = ((BigDecimal)values.pop()).setScale(precision, RoundingMode.HALF_UP);
                        BigDecimal left = ((BigDecimal)values.pop()).setScale(precision, RoundingMode.HALF_UP);
                        switch (command2.operatorValue.intern()) {
                            case "^": {
                                if (right.compareTo(new BigDecimal(1000)) >= 0) {
                                    Token rightToken = rpnTokens.get(rpnTokens.indexOf(command2) - 1);
                                    throw new CalculatorException(right + " is too large, pick a power less than 1000", rightToken.tokenStart, rightToken.tokenLength);
                                }
                                if (right.doubleValue() != (double)right.intValue()) {
                                    Token rightToken = rpnTokens.get(rpnTokens.indexOf(command2) - 1);
                                    throw new CalculatorException(right + " has a decimal, pick a power that is non-decimal", rightToken.tokenStart, rightToken.tokenLength);
                                }
                                if (right.doubleValue() < 0.0) {
                                    Token rightToken = rpnTokens.get(rpnTokens.indexOf(command2) - 1);
                                    throw new CalculatorException(right + " is a negative number, pick a power that is positive", rightToken.tokenStart, rightToken.tokenLength);
                                }
                                values.push(left.pow(right.intValue()).setScale(precision, RoundingMode.HALF_UP));
                                break block2;
                            }
                            case "x": 
                            case "*": {
                                values.push(left.multiply(right).setScale(precision, RoundingMode.HALF_UP));
                                break block2;
                            }
                            case "/": {
                                try {
                                    values.push(left.divide(right, RoundingMode.HALF_UP).setScale(precision, RoundingMode.HALF_UP));
                                    break block2;
                                }
                                catch (ArithmeticException e2) {
                                    throw new CalculatorException("Encountered division by 0", command2.tokenStart, command2.tokenLength);
                                }
                            }
                            case "+": {
                                values.push(left.add(right).setScale(precision, RoundingMode.HALF_UP));
                                break block2;
                            }
                            case "-": {
                                values.push(left.subtract(right).setScale(precision, RoundingMode.HALF_UP));
                                break block2;
                            }
                        }
                        throw new CalculatorException("Unknown operation " + command2.operatorValue, command2.tokenStart, command2.tokenLength);
                    }
                    case LPAREN: 
                    case RPAREN: {
                        throw new CalculatorException("Did not expect unshunted token in RPN", command2.tokenStart, command2.tokenLength);
                    }
                    case POSTOP: {
                        BigDecimal p = (BigDecimal)values.pop();
                        switch (command2.operatorValue.intern()) {
                            case "s": {
                                values.push(p.multiply(new BigDecimal(64)).setScale(precision, RoundingMode.HALF_UP));
                                break block2;
                            }
                            case "k": {
                                values.push(p.multiply(new BigDecimal(1000)).setScale(precision, RoundingMode.HALF_UP));
                                break block2;
                            }
                            case "m": {
                                values.push(p.multiply(new BigDecimal(1000000)).setScale(precision, RoundingMode.HALF_UP));
                                break block2;
                            }
                            case "b": {
                                values.push(p.multiply(new BigDecimal(1000000000)).setScale(precision, RoundingMode.HALF_UP));
                                break block2;
                            }
                            case "t": {
                                values.push(p.multiply(new BigDecimal("1000000000000")).setScale(precision, RoundingMode.HALF_UP));
                                break block2;
                            }
                            case "%": {
                                values.push(p.setScale(precision + 1, RoundingMode.HALF_UP).divide(new BigDecimal(100), RoundingMode.HALF_UP).setScale(precision, RoundingMode.HALF_UP));
                                break block2;
                            }
                        }
                        throw new CalculatorException("Unknown operation " + command2.operatorValue, command2.tokenStart, command2.tokenLength);
                    }
                }
            }
            BigDecimal peek = (BigDecimal)values.pop();
            return peek.stripTrailingZeros();
        }
        catch (NoSuchElementException e3) {
            throw new CalculatorException("Unfinished expression", 0, 0);
        }
    }

    public static class CalculatorException
    extends Exception {
        int offset;
        int length;

        public CalculatorException(String message, int offset, int length) {
            super(message);
            this.offset = offset;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    public static class Token {
        public TokenType type;
        String operatorValue;
        long numericValue;
        int exponent;
        int tokenStart;
        int tokenLength;
    }

    public static enum TokenType {
        NUMBER,
        BINOP,
        LPAREN,
        RPAREN,
        POSTOP,
        PREOP,
        VARIABLE;

    }

    public static interface VariableProvider {
        public Optional<BigDecimal> provideVariable(String var1) throws CalculatorException;
    }
}

