/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.common.base.Objects;
import io.github.moulberry.notenoughupdates.util.AsyncDependencyLoaderImpl;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface AsyncDependencyLoader<T> {
    public Optional<T> peekValue();

    public static <R, T> AsyncDependencyLoader<T> withObjectIdentity(Supplier<R> supplier, Function<R, CompletableFuture<T>> generator) {
        return new AsyncDependencyLoaderImpl<Object, T>(supplier, generator, (a, b) -> a != b);
    }

    public static <R, T> AsyncDependencyLoader<T> withEqualsInvocation(Supplier<R> supplier, Function<R, CompletableFuture<T>> generator) {
        return new AsyncDependencyLoaderImpl<Object, T>(supplier, generator, (a, b) -> !Objects.equal((Object)a, (Object)b));
    }

    public static <R, T> AsyncDependencyLoader<T> withEqualityFunction(Supplier<R> supplier, Function<R, CompletableFuture<T>> generator, BiFunction<R, R, Boolean> isEqual) {
        return new AsyncDependencyLoaderImpl<Object, T>(supplier, generator, (a, b) -> (Boolean)isEqual.apply(a, b) == false);
    }
}

