/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.miscgui.GuiItemRecipe;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.recipes.RecipeSlot;
import io.github.moulberry.notenoughupdates.recipes.RecipeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;

public interface NeuRecipe {
    public Set<Ingredient> getIngredients();

    public Set<Ingredient> getOutputs();

    public List<RecipeSlot> getSlots();

    public RecipeType getType();

    default public String getTitle() {
        return this.getType().getLabel();
    }

    default public void drawExtraInfo(GuiItemRecipe gui, int mouseX, int mouseY) {
    }

    default public void drawExtraBackground(GuiItemRecipe gui, int mouseX, int mouseY) {
    }

    default public void drawHoverInformation(GuiItemRecipe gui, int mouseX, int mouseY) {
    }

    default public void mouseClicked(GuiItemRecipe gui, int mouseX, int mouseY, int mouseButton) {
    }

    default public void handleKeyboardInput() {
    }

    default public Set<Ingredient> getCatalystItems() {
        return Collections.emptySet();
    }

    public boolean hasVariableCost();

    public JsonObject serialize();

    default public List<GuiButton> getExtraButtons(GuiItemRecipe guiItemRecipe) {
        return new ArrayList<GuiButton>();
    }

    public ResourceLocation getBackground();

    public static NeuRecipe parseRecipe(NEUManager manager, JsonObject recipe, JsonObject output) {
        RecipeType recipeType = RecipeType.CRAFTING;
        if (recipe.has("type")) {
            recipeType = RecipeType.getRecipeTypeForId(recipe.get("type").getAsString());
        }
        if (recipeType == null) {
            return null;
        }
        return recipeType.createRecipe(manager, recipe, output);
    }

    default public boolean shouldUseForCraftCost() {
        return true;
    }

    default public boolean isAvailable() {
        return true;
    }

    default public int[] getPageFlipPositionLeftTopCorner() {
        return new int[]{110, 90};
    }

    default public void actionPerformed(GuiButton button) {
    }

    default public void genericMouseInput(int mouseX, int mouseY) {
    }
}

