/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.miscgui.GuiItemRecipe;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.recipes.RecipeSlot;
import io.github.moulberry.notenoughupdates.recipes.RecipeType;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CraftingRecipe
implements NeuRecipe {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("notenoughupdates", "textures/gui/crafting_table_tall.png");
    private static final int EXTRA_STRING_X = 90;
    private static final int EXTRA_STRING_Y = 35;
    private final NEUManager manager;
    private final Ingredient[] inputs;
    private final String extraText;
    private final Ingredient outputIngredient;
    private List<RecipeSlot> slots;

    public CraftingRecipe(NEUManager manager, Ingredient[] inputs, Ingredient output, String extra) {
        this.manager = manager;
        this.inputs = inputs;
        this.outputIngredient = output;
        this.extraText = extra;
        if (inputs.length != 9) {
            throw new IllegalArgumentException("Cannot construct crafting recipe with non standard crafting grid size");
        }
    }

    @Override
    public Set<Ingredient> getIngredients() {
        HashSet ingredients = Sets.newHashSet((Object[])this.inputs);
        ingredients.remove(null);
        return ingredients;
    }

    @Override
    public RecipeType getType() {
        return RecipeType.CRAFTING;
    }

    @Override
    public boolean hasVariableCost() {
        return false;
    }

    @Override
    public Set<Ingredient> getOutputs() {
        return Collections.singleton(this.getOutput());
    }

    public Ingredient getOutput() {
        return this.outputIngredient;
    }

    public Ingredient[] getInputs() {
        return this.inputs;
    }

    @Override
    public List<RecipeSlot> getSlots() {
        if (this.slots != null) {
            return this.slots;
        }
        this.slots = new ArrayList<RecipeSlot>();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack item;
                Ingredient input = this.inputs[x + y * 3];
                if (input == null || (item = input.getItemStack()) == null) continue;
                this.slots.add(new RecipeSlot(30 + x * 18, 48 + y * 18, item));
            }
        }
        this.slots.add(new RecipeSlot(124, 66, this.outputIngredient.getItemStack()));
        return this.slots;
    }

    public String getCraftText() {
        return this.extraText;
    }

    @Override
    public ResourceLocation getBackground() {
        return BACKGROUND;
    }

    @Override
    public void drawExtraInfo(GuiItemRecipe gui, int mouseX, int mouseY) {
        String craftingText = this.getCraftText();
        if (craftingText != null) {
            Utils.drawStringCenteredScaledMaxWidth(craftingText, gui.guiLeft + 90, gui.guiTop + 35, false, 85, 0x404040);
        }
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "crafting");
        object.addProperty("count", this.outputIngredient.getCount());
        object.addProperty("overrideOutputId", this.outputIngredient.getInternalItemId());
        for (int i = 0; i < 9; ++i) {
            Ingredient ingredient = this.inputs[i];
            if (ingredient == null) continue;
            String[] x = new String[]{"1", "2", "3"};
            String[] y = new String[]{"A", "B", "C"};
            String name = x[i / 3] + y[i % 3];
            object.addProperty(name, ingredient.serialize());
        }
        if (this.extraText != null) {
            object.addProperty("crafttext", this.extraText);
        }
        return object;
    }

    public static CraftingRecipe parseCraftingRecipe(NEUManager manager, JsonObject recipe, JsonObject outputItem) {
        Ingredient[] craftMatrix = new Ingredient[9];
        String[] x = new String[]{"1", "2", "3"};
        String[] y = new String[]{"A", "B", "C"};
        for (int i = 0; i < 9; ++i) {
            String item;
            String name = y[i / 3] + x[i % 3];
            if (!recipe.has(name) || (item = recipe.get(name).getAsString()) == null || item.isEmpty()) continue;
            craftMatrix[i] = new Ingredient(manager, item);
        }
        int resultCount = 1;
        if (recipe.has("count")) {
            resultCount = recipe.get("count").getAsInt();
        }
        String extra = null;
        if (outputItem.has("crafttext")) {
            extra = outputItem.get("crafttext").getAsString();
        }
        if (recipe.has("crafttext")) {
            extra = recipe.get("crafttext").getAsString();
        }
        String outputItemId = outputItem.get("internalname").getAsString();
        if (recipe.has("overrideOutputId")) {
            outputItemId = recipe.get("overrideOutputId").getAsString();
        }
        return new CraftingRecipe(manager, craftMatrix, new Ingredient(manager, outputItemId, resultCount), extra);
    }
}

