/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.miscfeatures.EnchantingSolvers;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.recipes.CraftingRecipe;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;

public class CraftingOverlay {
    private final NEUManager manager;
    private CraftingRecipe currentRecipe = null;

    public CraftingOverlay(NEUManager manager) {
        this.manager = manager;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void setShownRecipe(CraftingRecipe recipe) {
        this.currentRecipe = recipe;
    }

    private void forEachSlot(ContainerChest chest, BiConsumer<Ingredient, Slot> block) {
        for (int i = 0; i < 9; ++i) {
            Ingredient recipeIngredient = this.currentRecipe.getInputs()[i];
            Slot slot = (Slot)chest.field_75151_b.get(10 + 9 * (i / 3) + i % 3);
            block.accept(recipeIngredient, slot);
        }
    }

    private void forEachHoveredSlot(GuiChest gui, ContainerChest chest, int mouseX, int mouseY, BiConsumer<Ingredient, Slot> block) {
        this.forEachSlot(chest, (recipeIngredient, slot) -> {
            if (Utils.isWithinRect(mouseX, mouseY, slot.field_75223_e + ((AccessorGuiContainer)gui).getGuiLeft(), slot.field_75221_f + ((AccessorGuiContainer)gui).getGuiTop(), 16, 16)) {
                block.accept((Ingredient)recipeIngredient, (Slot)slot);
            }
        });
    }

    private void runIfCraftingOverlayIsPresent(Gui gui, BiConsumer<GuiChest, ContainerChest> block) {
        if (this.currentRecipe == null) {
            return;
        }
        if (!(gui instanceof GuiChest)) {
            return;
        }
        GuiChest guiChest = (GuiChest)gui;
        ContainerChest chest = (ContainerChest)guiChest.field_147002_h;
        IInventory chestInventory = chest.func_85151_d();
        if (!"Craft Item".equals(chestInventory.func_145748_c_().func_150260_c())) {
            return;
        }
        block.accept(guiChest, chest);
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        this.currentRecipe = null;
    }

    @SubscribeEvent
    public void onRender(GuiScreenEvent.DrawScreenEvent.Post event) {
        this.runIfCraftingOverlayIsPresent((Gui)event.gui, (guiChest, chest) -> {
            this.renderSlots((GuiChest)guiChest, (ContainerChest)chest);
            if (this.currentRecipe.getCraftText() != null) {
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                fontRenderer.func_175063_a(this.currentRecipe.getCraftText(), (float)Utils.peekGuiScale().func_78326_a() / 2.0f - (float)fontRenderer.func_78256_a(this.currentRecipe.getCraftText()) / 2.0f, (float)((AccessorGuiContainer)guiChest).getGuiTop() - 15.0f, 0x808080);
            }
            this.renderTooltip((GuiChest)guiChest, (ContainerChest)chest);
        });
    }

    @SubscribeEvent
    public void onKeyDown(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (!Keyboard.getEventKeyState() || Keyboard.getEventKey() != 22 && Keyboard.getEventKey() != 19) {
            return;
        }
        if (EnchantingSolvers.currentSolver != EnchantingSolvers.SolverType.NONE) {
            return;
        }
        this.runIfCraftingOverlayIsPresent((Gui)event.gui, (guiChest, chest) -> {
            int mouseX = Utils.getMouseX();
            int mouseY = Utils.getMouseY();
            this.forEachHoveredSlot((GuiChest)guiChest, (ContainerChest)chest, mouseX, mouseY, (recipeIngredient, slot) -> {
                if (slot.func_75211_c() == null && recipeIngredient != null) {
                    if (Keyboard.getEventKey() == 19) {
                        this.manager.showRecipe(recipeIngredient.getInternalItemId());
                    }
                    if (Keyboard.getEventKey() == 22) {
                        this.manager.displayGuiItemRecipe(recipeIngredient.getInternalItemId());
                    }
                }
            });
        });
    }

    private void renderTooltip(GuiChest guiChest, ContainerChest chest) {
        int mouseX = Utils.getMouseX();
        int mouseY = Utils.getMouseY();
        this.forEachHoveredSlot(guiChest, chest, mouseX, mouseY, (recipeIngredient, slot) -> {
            ItemStack actualItem = slot.func_75211_c();
            if (actualItem == null && recipeIngredient != null) {
                Utils.drawHoveringText(recipeIngredient.getItemStack().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false), mouseX, mouseY, Utils.peekGuiScale().func_78326_a(), Utils.peekGuiScale().func_78328_b(), -1);
            }
        });
    }

    private void renderSlots(GuiChest guiChest, ContainerChest chest) {
        this.forEachSlot(chest, (recipeIngredient, slot) -> {
            ItemStack actualItem = slot.func_75211_c();
            if (actualItem != null && (recipeIngredient == null || !recipeIngredient.getInternalItemId().equals(this.manager.getInternalNameForItem(actualItem)) || (double)actualItem.field_77994_a < recipeIngredient.getCount())) {
                this.drawItemStack(guiChest, (Slot)slot, actualItem);
            }
            if (recipeIngredient != null && actualItem == null) {
                this.drawItemStack(guiChest, (Slot)slot, recipeIngredient.getItemStack());
            }
        });
    }

    private void drawItemStack(GuiChest gui, Slot slot, ItemStack item) {
        int slotX = slot.field_75223_e + ((AccessorGuiContainer)gui).getGuiLeft();
        int slotY = slot.field_75221_f + ((AccessorGuiContainer)gui).getGuiTop();
        Gui.func_73734_a((int)slotX, (int)slotY, (int)(slotX + 16), (int)(slotY + 16), (int)1694433280);
        if (item != null) {
            Utils.drawItemStack(item, slotX, slotY);
        }
    }
}

