/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.weight.lily;

import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.SlayerWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.WeightStruct;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Map;

public class LilySlayerWeight
extends SlayerWeight {
    public LilySlayerWeight(Map<String, ProfileViewer.Level> player) {
        super(player);
    }

    @Override
    public void getSlayerWeight(String slayerName) {
        double weight;
        double score;
        int currentSlayerXp = (int)((ProfileViewer.Level)this.player.get((Object)slayerName)).totalXp;
        double d = (double)currentSlayerXp / 100000.0;
        if (currentSlayerXp >= 6416) {
            double D = (d - Math.pow(3.0, -2.5)) * (d + Math.pow(3.0, -2.5));
            double u = Math.cbrt(3.0 * (d + Math.sqrt(D)));
            double v = Math.cbrt(3.0 * (d - Math.sqrt(D)));
            score = u + v - 1.0;
        } else {
            score = Math.sqrt(1.3333333333333333) * Math.cos(Math.acos(d * Math.pow(3.0, 2.5)) / 3.0) - 1.0;
        }
        double scaleFactor = Utils.getElementAsFloat(Utils.getElement(Constants.WEIGHT, "lily.slayer.deprecation_scaling." + slayerName), 0.0f);
        int intScore = (int)score;
        double distance = (double)currentSlayerXp - this.actualInt(intScore);
        double effectiveDistance = distance * Math.pow(scaleFactor, intScore);
        double effectiveScore = this.effectiveInt(intScore, scaleFactor) + effectiveDistance;
        switch (slayerName) {
            case "zombie": {
                weight = effectiveScore / 9250.0 + (double)currentSlayerXp / 1000000.0;
                break;
            }
            case "spider": {
                weight = effectiveScore / 7019.57 + (double)currentSlayerXp * 1.6 / 1000000.0;
                break;
            }
            case "wolf": {
                weight = effectiveScore / 2982.06 + (double)currentSlayerXp * 3.6 / 1000000.0;
                break;
            }
            case "enderman": {
                weight = effectiveScore / 996.3003 + (double)currentSlayerXp * 10.0 / 1000000.0;
                break;
            }
            case "blaze": {
                weight = effectiveScore / 935.0455 + (double)currentSlayerXp * 10.0 / 1000000.0;
                break;
            }
            default: {
                return;
            }
        }
        this.weightStruct.add(new WeightStruct(2.0 * weight));
    }

    private double actualInt(int intScore) {
        return (Math.pow(intScore, 3.0) / 6.0 + Math.pow(intScore, 2.0) / 2.0 + (double)intScore / 3.0) * 100000.0;
    }

    private double effectiveInt(int intScore, double scaleFactor) {
        double total = 0.0;
        for (int k = 0; k < intScore; ++k) {
            total += (Math.pow(k + 1, 2.0) + (double)(k + 1)) * Math.pow(scaleFactor, k + 1);
        }
        return 1000000.0 * total * (0.05 / scaleFactor);
    }
}

