/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.level;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.profileviewer.BasicPage;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.CoreTaskLevel;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.DungeonTaskLevel;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.EssenceTaskLevel;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.EventTaskLevel;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.GuiTaskLevel;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.MiscTaskLevel;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.SkillRelatedTaskLevel;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.SlayingTaskLevel;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.StoryTaskLevel;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LevelPage
extends GuiProfileViewerPage {
    private static final ResourceLocation pv_levels = new ResourceLocation("notenoughupdates:pv_levels.png");
    private final BasicPage basicPage;
    private final JsonObject constant;
    private final List<GuiTaskLevel> tasks = new ArrayList<GuiTaskLevel>();

    public LevelPage(GuiProfileViewer instance, BasicPage basicPage) {
        super(instance);
        this.basicPage = basicPage;
        this.constant = Constants.SBLEVELS;
        this.tasks.add(new CoreTaskLevel(this));
        this.tasks.add(new DungeonTaskLevel(this));
        this.tasks.add(new EssenceTaskLevel(this));
        this.tasks.add(new MiscTaskLevel(this));
        this.tasks.add(new SkillRelatedTaskLevel(this));
        this.tasks.add(new SlayingTaskLevel(this));
        this.tasks.add(new StoryTaskLevel(this));
        this.tasks.add(new EventTaskLevel(this));
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        this.basicPage.drawSideButtons(mouseX, mouseY);
        if (this.constant == null) {
            Utils.showOutdatedRepoNotification("sblevels.json");
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_levels);
        Utils.drawTexturedRect(guiLeft, guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        double skyblockLevel = selectedProfile.getSkyblockLevel();
        JsonObject profileInfo2 = selectedProfile.getProfileJson();
        this.drawMainBar(skyblockLevel, mouseX, mouseY, guiLeft, guiTop);
        this.tasks.forEach(task -> task.drawTask(profileInfo2, mouseX, mouseY, guiLeft, guiTop));
    }

    public void renderLevelBar(String name, ItemStack stack, int x, int y, int xSize, double level, double xp, double max2, int mouseX, int mouseY, boolean percentage, List<String> tooltip) {
        if (xp < 0.0) {
            xp = 0.0;
        }
        double experienceRequired = xp / max2;
        String second = EnumChatFormatting.WHITE.toString() + (int)level;
        if (percentage) {
            second = EnumChatFormatting.WHITE.toString() + (int)(experienceRequired * 100.0) + "%";
        }
        Utils.renderAlignedString(EnumChatFormatting.RED + name, second, x + 14, y - 4, xSize - 20);
        if (xp >= max2) {
            this.getInstance().renderGoldBar(x, y + 6, xSize);
        } else {
            this.getInstance().renderBar(x, y + 6, xSize, (float)experienceRequired);
        }
        if (mouseX > x && mouseX < x + 120 && mouseY > y - 4 && mouseY < y + 13) {
            String xpFormatted = StringUtils.formatNumber((int)xp);
            String maxFormatted = StringUtils.formatNumber((int)max2);
            String levelStr = EnumChatFormatting.GRAY + "Progress: " + EnumChatFormatting.DARK_PURPLE + (int)(experienceRequired * 100.0) + "% \u00a78(" + xpFormatted + "/" + maxFormatted + " XP)";
            if (tooltip != null && !tooltip.isEmpty()) {
                tooltip.add("");
                tooltip.add(levelStr);
                this.getInstance().tooltipToDisplay = tooltip;
            } else {
                this.getInstance().tooltipToDisplay = Utils.createList(levelStr);
            }
        }
        GlStateManager.func_179126_j();
        GL11.glTranslatef((float)x, (float)((float)y - 6.0f), (float)0.0f);
        GL11.glScalef((float)0.7f, (float)0.7f, (float)1.0f);
        Utils.drawItemStackLinear(stack, 0, 0);
        GL11.glScalef((float)1.4285715f, (float)1.4285715f, (float)1.0f);
        GL11.glTranslatef((float)(-x), (float)(-((float)y - 6.0f)), (float)0.0f);
        GlStateManager.func_179097_i();
    }

    private void drawMainBar(double skyblockLevel, int mouseX, int mouseY, int guiLeft, int guiTop) {
        this.renderLevelBar("Level", BasicPage.skull, guiLeft + 163, guiTop + 30, 110, skyblockLevel, Math.round((skyblockLevel - (double)((long)skyblockLevel)) * 100.0), 100.0, mouseX, mouseY, false, Collections.emptyList());
    }

    public String buildLore(String name, double xpGotten, double xpGainful, boolean hasNoLimit) {
        String xpGottenFormatted = StringUtils.formatNumber((int)xpGotten);
        String xpGainfulFormatted = StringUtils.formatNumber((int)xpGainful);
        if (xpGainful == 0.0 && xpGotten == 0.0 && !hasNoLimit) {
            return EnumChatFormatting.GOLD + name + ": \u00a7c\u00a7lNOT DETECTABLE!";
        }
        if (hasNoLimit) {
            return EnumChatFormatting.GOLD + name + ": " + EnumChatFormatting.YELLOW + xpGottenFormatted + " XP";
        }
        int percentage = (int)(xpGotten / xpGainful * 100.0);
        if (xpGotten >= xpGainful) {
            return EnumChatFormatting.GOLD + name + ": " + EnumChatFormatting.GREEN + percentage + "% \u00a78(" + xpGottenFormatted + "/" + xpGainfulFormatted + " XP)";
        }
        if (xpGotten == -1.0) {
            return EnumChatFormatting.GOLD + name + ": \u00a7c\u00a7lCOLLECTION DISABLED!";
        }
        return EnumChatFormatting.GOLD + name + ": " + EnumChatFormatting.YELLOW + percentage + "% \u00a78(" + xpGottenFormatted + "/" + xpGainfulFormatted + " XP)";
    }

    public JsonObject getConstant() {
        return this.constant;
    }
}

